/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GenericFutureListener;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Promise;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PromiseNotificationUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;
    private final boolean logNotifyFailure;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promiseArray) {
        this(true, promiseArray);
    }

    @SafeVarargs
    public PromiseNotifier(boolean bl, Promise<? super V> ... promiseArray) {
        ObjectUtil.checkNotNull(promiseArray, "promises");
        Promise<? super V>[] promiseArray2 = promiseArray;
        int n2 = promiseArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Promise<? super V> promise = promiseArray2[i2];
            if (promise != null) continue;
            throw new IllegalArgumentException("promises contains null Promise");
        }
        this.promises = (Promise[])promiseArray.clone();
        this.logNotifyFailure = bl;
    }

    @Override
    public void operationComplete(F object) {
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (object.isSuccess()) {
            object = object.get();
            Promise<? super V>[] promiseArray = this.promises;
            int n2 = this.promises.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Promise<? super V> promise = promiseArray[i2];
                PromiseNotificationUtil.trySuccess(promise, object, internalLogger);
            }
            return;
        }
        if (object.isCancelled()) {
            object = this.promises;
            int n3 = this.promises.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Object object2 = object[i3];
                PromiseNotificationUtil.tryCancel(object2, internalLogger);
            }
            return;
        }
        object = object.cause();
        Promise<? super V>[] promiseArray = this.promises;
        int n4 = this.promises.length;
        for (int i4 = 0; i4 < n4; ++i4) {
            Promise<? super V> promise = promiseArray[i4];
            PromiseNotificationUtil.tryFailure(promise, (Throwable)object, internalLogger);
        }
    }
}

