/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultPromise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.PromiseTask;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ScheduledFuture;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class ScheduledFutureTask<V>
extends PromiseTask<V>
implements ScheduledFuture<V> {
    private static final AtomicLong nextTaskId = new AtomicLong();
    private static final long START_TIME = System.nanoTime();
    private final long id = nextTaskId.getAndIncrement();
    private long deadlineNanos;
    private final long periodNanos;

    static long nanoTime() {
        return System.nanoTime() - START_TIME;
    }

    static long deadlineNanos(long l2) {
        return ScheduledFutureTask.nanoTime() + l2;
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Runnable runnable, V v2, long l2) {
        this(abstractScheduledEventExecutor, ScheduledFutureTask.toCallable(runnable, v2), l2);
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l2, long l3) {
        super(abstractScheduledEventExecutor, callable);
        if (l3 == 0L) {
            throw new IllegalArgumentException("period: 0 (expected: != 0)");
        }
        this.deadlineNanos = l2;
        this.periodNanos = l3;
    }

    ScheduledFutureTask(AbstractScheduledEventExecutor abstractScheduledEventExecutor, Callable<V> callable, long l2) {
        super(abstractScheduledEventExecutor, callable);
        this.deadlineNanos = l2;
        this.periodNanos = 0L;
    }

    @Override
    protected final EventExecutor executor() {
        return super.executor();
    }

    public final long deadlineNanos() {
        return this.deadlineNanos;
    }

    public final long delayNanos() {
        return Math.max(0L, this.deadlineNanos() - ScheduledFutureTask.nanoTime());
    }

    public final long delayNanos(long l2) {
        return Math.max(0L, this.deadlineNanos() - (l2 - START_TIME));
    }

    @Override
    public final long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.delayNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public final int compareTo(Delayed delayed) {
        if (this == delayed) {
            return 0;
        }
        delayed = (ScheduledFutureTask)delayed;
        long l2 = this.deadlineNanos() - ((ScheduledFutureTask)delayed).deadlineNanos();
        if (l2 < 0L) {
            return -1;
        }
        if (l2 > 0L) {
            return 1;
        }
        if (this.id < ((ScheduledFutureTask)delayed).id) {
            return -1;
        }
        if (this.id == ((ScheduledFutureTask)delayed).id) {
            throw new Error();
        }
        return 1;
    }

    @Override
    public final void run() {
        assert (((DefaultPromise)this).executor().inEventLoop());
        try {
            block9: {
                block8: {
                    block7: {
                        if (this.periodNanos != 0L) break block7;
                        if (!this.setUncancellableInternal()) break block8;
                        break block9;
                    }
                    if (!this.isCancelled()) {
                        this.task.call();
                        if (!((DefaultPromise)this).executor().isShutdown()) {
                            long l2 = this.periodNanos;
                            this.deadlineNanos = l2 > 0L ? (this.deadlineNanos += l2) : ScheduledFutureTask.nanoTime() - l2;
                            if (!this.isCancelled()) {
                                Queue<ScheduledFutureTask<?>> queue = ((AbstractScheduledEventExecutor)((DefaultPromise)this).executor()).scheduledTaskQueue;
                                assert (queue != null);
                                queue.add(this);
                            }
                        }
                    }
                }
                return;
            }
            Object v2 = this.task.call();
            this.setSuccessInternal(v2);
        }
        catch (Throwable throwable) {
            this.setFailureInternal(throwable);
        }
    }

    @Override
    public final boolean cancel(boolean bl) {
        if (bl = super.cancel(bl)) {
            ((AbstractScheduledEventExecutor)((DefaultPromise)this).executor()).removeScheduled(this);
        }
        return bl;
    }

    final boolean cancelWithoutRemove(boolean bl) {
        return super.cancel(bl);
    }

    @Override
    protected final StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = super.toStringBuilder();
        stringBuilder.setCharAt(stringBuilder.length() - 1, ',');
        return stringBuilder.append(" id: ").append(this.id).append(", deadline: ").append(this.deadlineNanos).append(", period: ").append(this.periodNanos).append(')');
    }
}

