/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultPromise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GlobalEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.OrderedEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Promise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.RejectedExecutionHandler;
import com.aliyun.openservices.shade.io.netty.util.concurrent.RejectedExecutionHandlers;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ScheduledFutureTask;
import com.aliyun.openservices.shade.io.netty.util.concurrent.SingleThreadEventExecutor$1;
import com.aliyun.openservices.shade.io.netty.util.concurrent.SingleThreadEventExecutor$2;
import com.aliyun.openservices.shade.io.netty.util.concurrent.SingleThreadEventExecutor$3;
import com.aliyun.openservices.shade.io.netty.util.concurrent.SingleThreadEventExecutor$4;
import com.aliyun.openservices.shade.io.netty.util.concurrent.SingleThreadEventExecutor$DefaultThreadProperties;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ThreadProperties;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class SingleThreadEventExecutor
extends AbstractScheduledEventExecutor
implements OrderedEventExecutor {
    static final int DEFAULT_MAX_PENDING_EXECUTOR_TASKS = Math.max(16, SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.eventexecutor.maxPendingTasks", Integer.MAX_VALUE));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final int ST_NOT_STARTED = 1;
    private static final int ST_STARTED = 2;
    private static final int ST_SHUTTING_DOWN = 3;
    private static final int ST_SHUTDOWN = 4;
    private static final int ST_TERMINATED = 5;
    private static final Runnable WAKEUP_TASK = new SingleThreadEventExecutor$1();
    private static final AtomicIntegerFieldUpdater<SingleThreadEventExecutor> STATE_UPDATER;
    private final EventExecutorGroup parent;
    private final Queue<Runnable> taskQueue;
    private final Thread thread;
    private final ThreadProperties threadProperties;
    private final Semaphore threadLock = new Semaphore(0);
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final boolean addTaskWakesUp;
    private final int maxPendingTasks;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private long lastExecutionTime;
    private volatile int state = 1;
    private volatile long gracefulShutdownQuietPeriod;
    private volatile long gracefulShutdownTimeout;
    private long gracefulShutdownStartTime;
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private static final long SCHEDULE_PURGE_INTERVAL;

    protected SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, ThreadFactory threadFactory, boolean bl) {
        this(eventExecutorGroup, threadFactory, bl, DEFAULT_MAX_PENDING_EXECUTOR_TASKS, RejectedExecutionHandlers.reject());
    }

    public SingleThreadEventExecutor(EventExecutorGroup eventExecutorGroup, ThreadFactory threadFactory, boolean bl, int n2, RejectedExecutionHandler rejectedExecutionHandler) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        this.parent = eventExecutorGroup;
        this.addTaskWakesUp = bl;
        this.thread = threadFactory.newThread(new SingleThreadEventExecutor$2(this));
        this.threadProperties = new SingleThreadEventExecutor$DefaultThreadProperties(this.thread);
        this.maxPendingTasks = Math.max(16, n2);
        this.taskQueue = this.newTaskQueue();
        this.rejectedExecutionHandler = ObjectUtil.checkNotNull(rejectedExecutionHandler, "rejectedHandler");
    }

    @Deprecated
    protected Queue<Runnable> newTaskQueue() {
        SingleThreadEventExecutor singleThreadEventExecutor = this;
        return singleThreadEventExecutor.newTaskQueue(singleThreadEventExecutor.maxPendingTasks);
    }

    protected Queue<Runnable> newTaskQueue(int n2) {
        return new LinkedBlockingQueue<Runnable>(n2);
    }

    @Override
    public EventExecutorGroup parent() {
        return this.parent;
    }

    protected void interruptThread() {
        this.thread.interrupt();
    }

    public Runnable pollTask() {
        Runnable runnable;
        assert (this.inEventLoop());
        while ((runnable = this.taskQueue.poll()) == WAKEUP_TASK) {
        }
        return runnable;
    }

    protected Runnable takeTask() {
        Runnable runnable;
        assert (this.inEventLoop());
        if (!(this.taskQueue instanceof BlockingQueue)) {
            throw new UnsupportedOperationException();
        }
        BlockingQueue blockingQueue = (BlockingQueue)this.taskQueue;
        do {
            if ((runnable = this.peekScheduledTask()) == null) {
                runnable = null;
                try {
                    runnable = (Runnable)blockingQueue.take();
                    if (runnable == WAKEUP_TASK) {
                        runnable = null;
                    }
                }
                catch (InterruptedException interruptedException) {}
                return runnable;
            }
            long l2 = runnable.delayNanos();
            runnable = null;
            if (l2 > 0L) {
                try {
                    runnable = (Runnable)blockingQueue.poll(l2, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (runnable != null) continue;
            this.fetchFromScheduledTaskQueue();
            runnable = (Runnable)blockingQueue.poll();
        } while (runnable == null);
        return runnable;
    }

    private boolean fetchFromScheduledTaskQueue() {
        long l2 = AbstractScheduledEventExecutor.nanoTime();
        Runnable runnable = this.pollScheduledTask(l2);
        while (runnable != null) {
            if (!this.taskQueue.offer(runnable)) {
                this.scheduledTaskQueue().add((ScheduledFutureTask)runnable);
                return false;
            }
            runnable = this.pollScheduledTask(l2);
        }
        return true;
    }

    protected Runnable peekTask() {
        assert (this.inEventLoop());
        return this.taskQueue.peek();
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        return !this.taskQueue.isEmpty();
    }

    public int pendingTasks() {
        return this.taskQueue.size();
    }

    protected void addTask(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("task");
        }
        if (!this.offerTask(runnable)) {
            this.rejectedExecutionHandler.rejected(runnable, this);
        }
    }

    final boolean offerTask(Runnable runnable) {
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        return this.taskQueue.offer(runnable);
    }

    protected boolean removeTask(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("task");
        }
        return this.taskQueue.remove(runnable);
    }

    protected boolean runAllTasks() {
        boolean bl;
        do {
            bl = this.fetchFromScheduledTaskQueue();
            Runnable runnable = this.pollTask();
            if (runnable == null) {
                return false;
            }
            do {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    logger.warn("A task raised an exception.", throwable);
                }
            } while ((runnable = this.pollTask()) != null);
        } while (!bl);
        this.lastExecutionTime = ScheduledFutureTask.nanoTime();
        return true;
    }

    protected boolean runAllTasks(long l2) {
        long l3;
        block4: {
            this.fetchFromScheduledTaskQueue();
            Runnable runnable = this.pollTask();
            if (runnable == null) {
                return false;
            }
            long l4 = ScheduledFutureTask.nanoTime() + l2;
            long l5 = 0L;
            do {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    logger.warn("A task raised an exception.", throwable);
                }
                if ((++l5 & 0x3FL) == 0L && (l3 = ScheduledFutureTask.nanoTime()) >= l4) break block4;
            } while ((runnable = this.pollTask()) != null);
            l3 = ScheduledFutureTask.nanoTime();
        }
        this.lastExecutionTime = l3;
        return true;
    }

    protected long delayNanos(long l2) {
        ScheduledFutureTask<?> scheduledFutureTask = this.peekScheduledTask();
        if (scheduledFutureTask == null) {
            return SCHEDULE_PURGE_INTERVAL;
        }
        return scheduledFutureTask.delayNanos(l2);
    }

    protected void updateLastExecutionTime() {
        this.lastExecutionTime = ScheduledFutureTask.nanoTime();
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected void wakeup(boolean bl) {
        if (!bl || STATE_UPDATER.get(this) == 3) {
            this.taskQueue.offer(WAKEUP_TASK);
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    public void addShutdownHook(Runnable runnable) {
        if (this.inEventLoop()) {
            this.shutdownHooks.add(runnable);
            return;
        }
        this.execute(new SingleThreadEventExecutor$3(this, runnable));
    }

    public void removeShutdownHook(Runnable runnable) {
        if (this.inEventLoop()) {
            this.shutdownHooks.remove(runnable);
            return;
        }
        this.execute(new SingleThreadEventExecutor$4(this, runnable));
    }

    private boolean runShutdownHooks() {
        boolean bl = false;
        while (!this.shutdownHooks.isEmpty()) {
            Object object = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            object = object.iterator();
            while (object.hasNext()) {
                Runnable runnable = (Runnable)object.next();
                try {
                    runnable.run();
                    bl = true;
                }
                catch (Throwable throwable) {
                    logger.warn("Shutdown hook raised an exception.", throwable);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.lastExecutionTime = ScheduledFutureTask.nanoTime();
        }
        return bl;
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        boolean bl;
        int n2;
        int n3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("quietPeriod: " + l2 + " (expected >= 0)");
        }
        if (l3 < l2) {
            throw new IllegalArgumentException("timeout: " + l3 + " (expected >= quietPeriod (" + l2 + "))");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        if (this.isShuttingDown()) {
            return this.terminationFuture();
        }
        boolean bl2 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return this.terminationFuture();
            }
            bl = true;
            n3 = STATE_UPDATER.get(this);
            if (bl2) {
                n2 = 3;
                continue;
            }
            switch (n3) {
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = n3;
                    bl = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n3, n2));
        this.gracefulShutdownQuietPeriod = timeUnit.toNanos(l2);
        this.gracefulShutdownTimeout = timeUnit.toNanos(l3);
        if (n3 == 1) {
            this.thread.start();
        }
        if (bl) {
            this.wakeup(bl2);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        boolean bl;
        int n2;
        int n3;
        if (this.isShutdown()) {
            return;
        }
        boolean bl2 = this.inEventLoop();
        do {
            if (this.isShuttingDown()) {
                return;
            }
            bl = true;
            n3 = STATE_UPDATER.get(this);
            if (bl2) {
                n2 = 4;
                continue;
            }
            switch (n3) {
                case 1: 
                case 2: 
                case 3: {
                    n2 = 4;
                    break;
                }
                default: {
                    n2 = n3;
                    bl = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, n3, n2));
        if (n3 == 1) {
            this.thread.start();
        }
        if (bl) {
            this.wakeup(bl2);
        }
    }

    @Override
    public boolean isShuttingDown() {
        return STATE_UPDATER.get(this) >= 3;
    }

    @Override
    public boolean isShutdown() {
        return STATE_UPDATER.get(this) >= 4;
    }

    @Override
    public boolean isTerminated() {
        return STATE_UPDATER.get(this) == 5;
    }

    protected boolean confirmShutdown() {
        if (!this.isShuttingDown()) {
            return false;
        }
        if (!this.inEventLoop()) {
            throw new IllegalStateException("must be invoked from an event loop");
        }
        this.cancelScheduledTasks();
        if (this.gracefulShutdownStartTime == 0L) {
            this.gracefulShutdownStartTime = ScheduledFutureTask.nanoTime();
        }
        if (this.runAllTasks() || this.runShutdownHooks()) {
            if (this.isShutdown()) {
                return true;
            }
            if (this.gracefulShutdownQuietPeriod == 0L) {
                return true;
            }
            this.wakeup(true);
            return false;
        }
        long l2 = ScheduledFutureTask.nanoTime();
        if (this.isShutdown() || l2 - this.gracefulShutdownStartTime > this.gracefulShutdownTimeout) {
            return true;
        }
        if (l2 - this.lastExecutionTime <= this.gracefulShutdownQuietPeriod) {
            this.wakeup(true);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        if (this.threadLock.tryAcquire(l2, timeUnit)) {
            this.threadLock.release();
        }
        return this.isTerminated();
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("task");
        }
        boolean bl = this.inEventLoop();
        if (bl) {
            this.addTask(runnable);
        } else {
            this.startThread();
            this.addTask(runnable);
            if (this.isShutdown() && this.removeTask(runnable)) {
                SingleThreadEventExecutor.reject();
            }
        }
        if (!this.addTaskWakesUp && this.wakesUpForTask(runnable)) {
            this.wakeup(bl);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) {
        this.throwIfInEventLoop("invokeAny");
        return super.invokeAny(collection, l2, timeUnit);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection);
    }

    @Override
    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) {
        this.throwIfInEventLoop("invokeAll");
        return super.invokeAll(collection, l2, timeUnit);
    }

    private void throwIfInEventLoop(String string) {
        if (this.inEventLoop()) {
            throw new RejectedExecutionException("Calling " + string + " from within the EventLoop is not allowed");
        }
    }

    public final ThreadProperties threadProperties() {
        return this.threadProperties;
    }

    protected boolean wakesUpForTask(Runnable runnable) {
        return true;
    }

    protected static void reject() {
        throw new RejectedExecutionException("event executor terminated");
    }

    private void startThread() {
        if (STATE_UPDATER.get(this) == 1 && STATE_UPDATER.compareAndSet(this, 1, 2)) {
            this.thread.start();
        }
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static /* synthetic */ AtomicIntegerFieldUpdater access$100() {
        return STATE_UPDATER;
    }

    static /* synthetic */ long access$200(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.gracefulShutdownStartTime;
    }

    static /* synthetic */ Semaphore access$300(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.threadLock;
    }

    static /* synthetic */ Queue access$400(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.taskQueue;
    }

    static /* synthetic */ Promise access$500(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.terminationFuture;
    }

    static /* synthetic */ Set access$600(SingleThreadEventExecutor singleThreadEventExecutor) {
        return singleThreadEventExecutor.shutdownHooks;
    }

    static {
        AtomicIntegerFieldUpdater<SingleThreadEventExecutor> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(SingleThreadEventExecutor.class, "state");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(SingleThreadEventExecutor.class, "state");
        }
        STATE_UPDATER = atomicIntegerFieldUpdater;
        SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
    }
}

