/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import com.aliyun.openservices.shade.io.netty.util.concurrent.FastThreadLocalThread;
import com.aliyun.openservices.shade.io.netty.util.internal.IntegerHolder;
import com.aliyun.openservices.shade.io.netty.util.internal.ThreadLocalRandom;
import com.aliyun.openservices.shade.io.netty.util.internal.TypeParameterMatcher;
import com.aliyun.openservices.shade.io.netty.util.internal.UnpaddedInternalThreadLocalMap;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class InternalThreadLocalMap
extends UnpaddedInternalThreadLocalMap {
    private static final int DEFAULT_ARRAY_LIST_INITIAL_CAPACITY = 8;
    public static final Object UNSET = new Object();
    public long rp1;
    public long rp2;
    public long rp3;
    public long rp4;
    public long rp5;
    public long rp6;
    public long rp7;
    public long rp8;
    public long rp9;

    public static InternalThreadLocalMap getIfSet() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return ((FastThreadLocalThread)thread).threadLocalMap();
        }
        return (InternalThreadLocalMap)slowThreadLocalMap.get();
    }

    public static InternalThreadLocalMap get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return InternalThreadLocalMap.fastGet((FastThreadLocalThread)thread);
        }
        return InternalThreadLocalMap.slowGet();
    }

    private static InternalThreadLocalMap fastGet(FastThreadLocalThread fastThreadLocalThread) {
        InternalThreadLocalMap internalThreadLocalMap = fastThreadLocalThread.threadLocalMap();
        if (internalThreadLocalMap == null) {
            internalThreadLocalMap = new InternalThreadLocalMap();
            fastThreadLocalThread.setThreadLocalMap(internalThreadLocalMap);
        }
        return internalThreadLocalMap;
    }

    private static InternalThreadLocalMap slowGet() {
        ThreadLocal<InternalThreadLocalMap> threadLocal = UnpaddedInternalThreadLocalMap.slowThreadLocalMap;
        InternalThreadLocalMap internalThreadLocalMap = threadLocal.get();
        if (internalThreadLocalMap == null) {
            internalThreadLocalMap = new InternalThreadLocalMap();
            threadLocal.set(internalThreadLocalMap);
        }
        return internalThreadLocalMap;
    }

    public static void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            ((FastThreadLocalThread)thread).setThreadLocalMap(null);
            return;
        }
        slowThreadLocalMap.remove();
    }

    public static void destroy() {
        slowThreadLocalMap.remove();
    }

    public static int nextVariableIndex() {
        int n2 = nextIndex.getAndIncrement();
        if (n2 < 0) {
            nextIndex.decrementAndGet();
            throw new IllegalStateException("too many thread-local indexed variables");
        }
        return n2;
    }

    public static int lastVariableIndex() {
        return nextIndex.get() - 1;
    }

    private InternalThreadLocalMap() {
        super(InternalThreadLocalMap.newIndexedVariableTable());
    }

    private static Object[] newIndexedVariableTable() {
        Object[] objectArray = new Object[32];
        Arrays.fill(objectArray, UNSET);
        return objectArray;
    }

    public final int size() {
        int n2 = 0;
        if (this.futureListenerStackDepth != 0) {
            ++n2;
        }
        if (this.localChannelReaderStackDepth != 0) {
            ++n2;
        }
        if (this.handlerSharableCache != null) {
            ++n2;
        }
        if (this.counterHashCode != null) {
            ++n2;
        }
        if (this.random != null) {
            ++n2;
        }
        if (this.typeParameterMatcherGetCache != null) {
            ++n2;
        }
        if (this.typeParameterMatcherFindCache != null) {
            ++n2;
        }
        if (this.stringBuilder != null) {
            ++n2;
        }
        if (this.charsetEncoderCache != null) {
            ++n2;
        }
        if (this.charsetDecoderCache != null) {
            ++n2;
        }
        if (this.arrayList != null) {
            ++n2;
        }
        Object[] objectArray = this.indexedVariables;
        int n3 = this.indexedVariables.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            if (object == UNSET) continue;
            ++n2;
        }
        return n2 - 1;
    }

    public final StringBuilder stringBuilder() {
        StringBuilder stringBuilder = this.stringBuilder;
        if (stringBuilder == null) {
            this.stringBuilder = stringBuilder = new StringBuilder(512);
        } else {
            stringBuilder.setLength(0);
        }
        return stringBuilder;
    }

    public final Map<Charset, CharsetEncoder> charsetEncoderCache() {
        Map<Charset, CharsetEncoder> map = this.charsetEncoderCache;
        if (map == null) {
            this.charsetEncoderCache = map = new IdentityHashMap<Charset, CharsetEncoder>();
        }
        return map;
    }

    public final Map<Charset, CharsetDecoder> charsetDecoderCache() {
        Map<Charset, CharsetDecoder> map = this.charsetDecoderCache;
        if (map == null) {
            this.charsetDecoderCache = map = new IdentityHashMap<Charset, CharsetDecoder>();
        }
        return map;
    }

    public final <E> ArrayList<E> arrayList() {
        return this.arrayList(8);
    }

    public final <E> ArrayList<E> arrayList(int n2) {
        ArrayList<Object> arrayList = this.arrayList;
        if (arrayList == null) {
            arrayList = new ArrayList(n2);
        } else {
            arrayList.clear();
            arrayList.ensureCapacity(n2);
        }
        return arrayList;
    }

    public final int futureListenerStackDepth() {
        return this.futureListenerStackDepth;
    }

    public final void setFutureListenerStackDepth(int n2) {
        this.futureListenerStackDepth = n2;
    }

    public final ThreadLocalRandom random() {
        ThreadLocalRandom threadLocalRandom = this.random;
        if (threadLocalRandom == null) {
            this.random = threadLocalRandom = new ThreadLocalRandom();
        }
        return threadLocalRandom;
    }

    public final Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache() {
        Map<Class<?>, TypeParameterMatcher> map = this.typeParameterMatcherGetCache;
        if (map == null) {
            this.typeParameterMatcherGetCache = map = new IdentityHashMap();
        }
        return map;
    }

    public final Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache() {
        Map<Class<?>, Map<String, TypeParameterMatcher>> map = this.typeParameterMatcherFindCache;
        if (map == null) {
            this.typeParameterMatcherFindCache = map = new IdentityHashMap();
        }
        return map;
    }

    public final IntegerHolder counterHashCode() {
        return this.counterHashCode;
    }

    public final void setCounterHashCode(IntegerHolder integerHolder) {
        this.counterHashCode = integerHolder;
    }

    public final Map<Class<?>, Boolean> handlerSharableCache() {
        Map<Class<?>, Boolean> map = this.handlerSharableCache;
        if (map == null) {
            this.handlerSharableCache = map = new WeakHashMap(4);
        }
        return map;
    }

    public final int localChannelReaderStackDepth() {
        return this.localChannelReaderStackDepth;
    }

    public final void setLocalChannelReaderStackDepth(int n2) {
        this.localChannelReaderStackDepth = n2;
    }

    public final Object indexedVariable(int n2) {
        Object[] objectArray = this.indexedVariables;
        if (n2 < objectArray.length) {
            return objectArray[n2];
        }
        return UNSET;
    }

    public final boolean setIndexedVariable(int n2, Object object) {
        Object[] objectArray = this.indexedVariables;
        if (n2 < objectArray.length) {
            Object object2 = objectArray[n2];
            objectArray[n2] = object;
            return object2 == UNSET;
        }
        this.expandIndexedVariableTableAndSet(n2, object);
        return true;
    }

    private void expandIndexedVariableTableAndSet(int n2, Object object) {
        Object[] objectArray = this.indexedVariables;
        int n3 = this.indexedVariables.length;
        int n4 = n2;
        int n5 = n4 | n4 >>> 1;
        n5 |= n5 >>> 2;
        n5 |= n5 >>> 4;
        n5 |= n5 >>> 8;
        n5 |= n5 >>> 16;
        objectArray = Arrays.copyOf(objectArray, ++n5);
        Arrays.fill(objectArray, n3, objectArray.length, UNSET);
        objectArray[n2] = object;
        this.indexedVariables = objectArray;
    }

    public final Object removeIndexedVariable(int n2) {
        Object[] objectArray = this.indexedVariables;
        if (n2 < objectArray.length) {
            Object object = objectArray[n2];
            objectArray[n2] = UNSET;
            return object;
        }
        return UNSET;
    }

    public final boolean isIndexedVariableSet(int n2) {
        Object[] objectArray = this.indexedVariables;
        return n2 < objectArray.length && objectArray[n2] != UNSET;
    }
}

