/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import com.aliyun.openservices.shade.io.netty.util.internal.NativeLibraryLoader$1;
import com.aliyun.openservices.shade.io.netty.util.internal.NativeLibraryLoader$2;
import com.aliyun.openservices.shade.io.netty.util.internal.NativeLibraryUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Locale;

public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final String OSNAME = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    private static final File WORKDIR;

    private static File tmpdir() {
        File file;
        try {
            file = NativeLibraryLoader.toDirectory(SystemPropertyUtil.get("com.aliyun.openservices.shade.io.netty.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: " + file);
                return file;
            }
            file = NativeLibraryLoader.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: " + file + " (java.io.tmpdir)");
                return file;
            }
            if (NativeLibraryLoader.isWindows()) {
                file = NativeLibraryLoader.toDirectory(System.getenv("TEMP"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: " + file + " (%TEMP%)");
                    return file;
                }
                String string = System.getenv("USERPROFILE");
                if (string != null) {
                    file = NativeLibraryLoader.toDirectory(string + "\\AppData\\Local\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: " + file + " (%USERPROFILE%\\AppData\\Local\\Temp)");
                        return file;
                    }
                    file = NativeLibraryLoader.toDirectory(string + "\\Local Settings\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: " + file + " (%USERPROFILE%\\Local Settings\\Temp)");
                        return file;
                    }
                }
            } else {
                file = NativeLibraryLoader.toDirectory(System.getenv("TMPDIR"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: " + file + " ($TMPDIR)");
                    return file;
                }
            }
        }
        catch (Exception exception) {}
        file = NativeLibraryLoader.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: " + file);
        return file;
    }

    private static File toDirectory(String object) {
        if (object == null) {
            return null;
        }
        object = new File((String)object);
        ((File)object).mkdirs();
        if (!((File)object).isDirectory()) {
            return null;
        }
        try {
            return ((File)object).getAbsoluteFile();
        }
        catch (Exception exception) {
            return object;
        }
    }

    private static boolean isWindows() {
        return OSNAME.startsWith("windows");
    }

    private static boolean isOSX() {
        return OSNAME.startsWith("macosx") || OSNAME.startsWith("osx");
    }

    public static void loadFirstAvailable(ClassLoader classLoader, String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray2[i2];
            try {
                NativeLibraryLoader.load(string, classLoader);
                logger.debug("Successfully loaded the library: {}", (Object)string);
                return;
            }
            catch (Throwable throwable) {
                logger.debug("Unable to load the library '{}', trying next name...", (Object)string, (Object)throwable);
                continue;
            }
        }
        throw new IllegalArgumentException("Failed to load any of the given libraries: " + Arrays.toString(stringArray));
    }

    public static void load(String string, ClassLoader classLoader) {
        Object object = System.mapLibraryName(string);
        String string2 = NATIVE_RESOURCE_HOME + (String)object;
        URL uRL = classLoader.getResource(string2);
        if (uRL == null && NativeLibraryLoader.isOSX()) {
            uRL = string2.endsWith(".jnilib") ? classLoader.getResource("META-INF/native/lib" + string + ".dynlib") : classLoader.getResource("META-INF/native/lib" + string + ".jnilib");
        }
        if (uRL == null) {
            NativeLibraryLoader.loadLibrary(classLoader, string, false);
            return;
        }
        int n2 = ((String)object).lastIndexOf(46);
        String string3 = ((String)object).substring(0, n2);
        object = ((String)object).substring(n2, ((String)object).length());
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = null;
        try {
            int n3;
            file = File.createTempFile(string3, (String)object, WORKDIR);
            inputStream = uRL.openStream();
            fileOutputStream = new FileOutputStream(file);
            object = new byte[8192];
            while ((n3 = inputStream.read((byte[])object)) > 0) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n3);
            }
            fileOutputStream.flush();
            NativeLibraryLoader.closeQuietly(fileOutputStream);
            fileOutputStream = null;
            NativeLibraryLoader.loadLibrary(classLoader, file.getPath(), true);
        }
        catch (Exception exception) {
            try {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("could not load a native library: " + string).initCause(exception);
            }
            catch (Throwable throwable) {
                NativeLibraryLoader.closeQuietly(inputStream);
                NativeLibraryLoader.closeQuietly(fileOutputStream);
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
                throw throwable;
            }
        }
        NativeLibraryLoader.closeQuietly(inputStream);
        NativeLibraryLoader.closeQuietly(null);
        if (file != null && !file.delete()) {
            file.deleteOnExit();
            return;
        }
    }

    private static void loadLibrary(ClassLoader object, String string, boolean bl) {
        try {
            object = NativeLibraryLoader.tryToLoadClass((ClassLoader)object, NativeLibraryUtil.class);
            NativeLibraryLoader.loadLibraryByHelper(object, string, bl);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)string, (Object)unsatisfiedLinkError);
        }
        catch (Exception exception) {
            logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)string, (Object)exception);
        }
        NativeLibraryUtil.loadLibrary(string, bl);
    }

    private static void loadLibraryByHelper(Class<?> object, String object2, boolean bl) {
        if ((object = AccessController.doPrivileged(new NativeLibraryLoader$1((Class)object, (String)object2, bl))) instanceof Throwable) {
            object2 = ((Throwable)(object = (Throwable)object)).getCause();
            if (object2 != null) {
                if (object2 instanceof UnsatisfiedLinkError) {
                    throw (UnsatisfiedLinkError)object2;
                }
                throw new UnsatisfiedLinkError(((Throwable)object2).getMessage());
            }
            throw new UnsatisfiedLinkError(((Throwable)object).getMessage());
        }
    }

    private static Class<?> tryToLoadClass(ClassLoader classLoader, Class<?> clazz) {
        try {
            return classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            byte[] byArray = NativeLibraryLoader.classToByteArray(clazz);
            return (Class)AccessController.doPrivileged(new NativeLibraryLoader$2(classLoader, clazz, byArray));
        }
    }

    private static byte[] classToByteArray(Class<?> clazz) {
        Object object = clazz.getName();
        int n2 = ((String)object).lastIndexOf(46);
        if (n2 > 0) {
            object = ((String)object).substring(n2 + 1);
        }
        if ((object = clazz.getResource((String)object + ".class")) == null) {
            throw new ClassNotFoundException(clazz.getName());
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        InputStream inputStream = null;
        try {
            int n3;
            inputStream = ((URL)object).openStream();
            while ((n3 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(clazz.getName(), iOException);
        }
        finally {
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(byteArrayOutputStream);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private NativeLibraryLoader() {
    }

    static {
        Object object = SystemPropertyUtil.get("com.aliyun.openservices.shade.io.netty.native.workdir");
        if (object != null) {
            object = new File((String)object);
            ((File)object).mkdirs();
            try {
                object = ((File)object).getAbsoluteFile();
            }
            catch (Exception exception) {}
            WORKDIR = object;
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR);
        } else {
            WORKDIR = NativeLibraryLoader.tmpdir();
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR + " (io.netty.tmpdir)");
        }
    }
}

