/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.JavassistTypeParameterMatcherGenerator;
import com.aliyun.openservices.shade.io.netty.util.internal.LongCounter;
import com.aliyun.openservices.shade.io.netty.util.internal.OutOfDirectMemoryError;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent$1;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent$AtomicLongCounter;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent$Mpsc;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ConcurrentHashMapV8;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.LongAdderV8;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.SpscLinkedQueue;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueue;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.atomic.SpscLinkedAtomicQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlatformDependent {
    private static final InternalLogger logger;
    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN;
    private static final boolean IS_ANDROID;
    private static final boolean IS_WINDOWS;
    private static volatile Boolean IS_ROOT;
    private static final int JAVA_VERSION;
    private static final boolean CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    private static final boolean IS_EXPLICIT_NO_UNSAFE;
    private static final boolean HAS_UNSAFE;
    private static final boolean CAN_USE_CHM_V8;
    private static final boolean DIRECT_BUFFER_PREFERRED;
    private static final long MAX_DIRECT_MEMORY;
    private static final int MPSC_CHUNK_SIZE = 1024;
    private static final int MIN_MAX_MPSC_CAPACITY = 2048;
    private static final int DEFAULT_MAX_MPSC_CAPACITY = 0x100000;
    private static final int MAX_ALLOWED_MPSC_CAPACITY = 0x40000000;
    private static final long ARRAY_BASE_OFFSET;
    private static final boolean HAS_JAVASSIST;
    private static final File TMPDIR;
    private static final int BIT_MODE;
    private static final int ADDRESS_SIZE;
    private static final boolean USE_DIRECT_BUFFER_NO_CLEANER;
    private static final AtomicLong DIRECT_MEMORY_COUNTER;
    private static final long DIRECT_MEMORY_LIMIT;
    public static final boolean BIG_ENDIAN_NATIVE_ORDER;

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isRoot() {
        if (IS_ROOT != null) return IS_ROOT;
        Class<PlatformDependent> clazz = PlatformDependent.class;
        synchronized (PlatformDependent.class) {
            if (IS_ROOT != null) return IS_ROOT;
            IS_ROOT = PlatformDependent.isRoot0();
            // ** MonitorExit[var0] (shouldn't be in output)
            return IS_ROOT;
        }
    }

    public static int javaVersion() {
        return JAVA_VERSION;
    }

    public static boolean canEnableTcpNoDelayByDefault() {
        return CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    }

    public static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    public static boolean isUnaligned() {
        return PlatformDependent0.isUnaligned();
    }

    public static boolean directBufferPreferred() {
        return DIRECT_BUFFER_PREFERRED;
    }

    public static long maxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }

    public static boolean hasJavassist() {
        return HAS_JAVASSIST;
    }

    public static File tmpdir() {
        return TMPDIR;
    }

    public static int bitMode() {
        return BIT_MODE;
    }

    public static int addressSize() {
        return ADDRESS_SIZE;
    }

    public static long allocateMemory(long l2) {
        return PlatformDependent0.allocateMemory(l2);
    }

    public static void freeMemory(long l2) {
        PlatformDependent0.freeMemory(l2);
    }

    public static void throwException(Throwable throwable) {
        if (PlatformDependent.hasUnsafe()) {
            PlatformDependent0.throwException(throwable);
            return;
        }
        PlatformDependent.throwException0(throwable);
    }

    private static <E extends Throwable> void throwException0(Throwable throwable) {
        throw throwable;
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap() {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8();
        }
        return new ConcurrentHashMap();
    }

    public static LongCounter newLongCounter() {
        if (HAS_UNSAFE) {
            return new LongAdderV8();
        }
        return new PlatformDependent$AtomicLongCounter(null);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n2) {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8(n2);
        }
        return new ConcurrentHashMap(n2);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n2, float f2) {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8(n2, f2);
        }
        return new ConcurrentHashMap(n2, f2);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n2, float f2, int n3) {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8(n2, f2, n3);
        }
        return new ConcurrentHashMap(n2, f2, n3);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> map) {
        if (CAN_USE_CHM_V8) {
            return new ConcurrentHashMapV8<K, V>(map);
        }
        return new ConcurrentHashMap<K, V>(map);
    }

    public static void freeDirectBuffer(ByteBuffer byteBuffer) {
        if (PlatformDependent.hasUnsafe() && !PlatformDependent.isAndroid()) {
            PlatformDependent0.freeDirectBuffer(byteBuffer);
        }
    }

    public static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.directBufferAddress(byteBuffer);
    }

    public static ByteBuffer directBuffer(long l2, int n2) {
        if (PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            return PlatformDependent0.newDirectBuffer(l2, n2);
        }
        throw new UnsupportedOperationException("sun.misc.Unsafe or java.nio.DirectByteBuffer.<init>(long, int) not available");
    }

    public static Object getObject(Object object, long l2) {
        return PlatformDependent0.getObject(object, l2);
    }

    public static Object getObjectVolatile(Object object, long l2) {
        return PlatformDependent0.getObjectVolatile(object, l2);
    }

    public static int getInt(Object object, long l2) {
        return PlatformDependent0.getInt(object, l2);
    }

    public static long objectFieldOffset(Field field) {
        return PlatformDependent0.objectFieldOffset(field);
    }

    public static byte getByte(long l2) {
        return PlatformDependent0.getByte(l2);
    }

    public static short getShort(long l2) {
        return PlatformDependent0.getShort(l2);
    }

    public static int getInt(long l2) {
        return PlatformDependent0.getInt(l2);
    }

    public static long getLong(long l2) {
        return PlatformDependent0.getLong(l2);
    }

    public static byte getByte(byte[] byArray, int n2) {
        return PlatformDependent0.getByte(byArray, n2);
    }

    public static short getShort(byte[] byArray, int n2) {
        return PlatformDependent0.getShort(byArray, n2);
    }

    public static int getInt(byte[] byArray, int n2) {
        return PlatformDependent0.getInt(byArray, n2);
    }

    public static long getLong(byte[] byArray, int n2) {
        return PlatformDependent0.getLong(byArray, n2);
    }

    public static void putOrderedObject(Object object, long l2, Object object2) {
        PlatformDependent0.putOrderedObject(object, l2, object2);
    }

    public static void putByte(long l2, byte by) {
        PlatformDependent0.putByte(l2, by);
    }

    public static void putShort(long l2, short s2) {
        PlatformDependent0.putShort(l2, s2);
    }

    public static void putInt(long l2, int n2) {
        PlatformDependent0.putInt(l2, n2);
    }

    public static void putLong(long l2, long l3) {
        PlatformDependent0.putLong(l2, l3);
    }

    public static void putByte(byte[] byArray, int n2, byte by) {
        PlatformDependent0.putByte(byArray, n2, by);
    }

    public static void putShort(byte[] byArray, int n2, short s2) {
        PlatformDependent0.putShort(byArray, n2, s2);
    }

    public static void putInt(byte[] byArray, int n2, int n3) {
        PlatformDependent0.putInt(byArray, n2, n3);
    }

    public static void putLong(byte[] byArray, int n2, long l2) {
        PlatformDependent0.putLong(byArray, n2, l2);
    }

    public static void copyMemory(long l2, long l3, long l4) {
        PlatformDependent0.copyMemory(l2, l3, l4);
    }

    public static void copyMemory(byte[] byArray, int n2, long l2, long l3) {
        PlatformDependent0.copyMemory(byArray, ARRAY_BASE_OFFSET + (long)n2, null, l2, l3);
    }

    public static void copyMemory(long l2, byte[] byArray, int n2, long l3) {
        PlatformDependent0.copyMemory(null, l2, byArray, ARRAY_BASE_OFFSET + (long)n2, l3);
    }

    public static void setMemory(byte[] byArray, int n2, long l2, byte by) {
        PlatformDependent0.setMemory(byArray, ARRAY_BASE_OFFSET + (long)n2, l2, by);
    }

    public static void setMemory(long l2, long l3, byte by) {
        PlatformDependent0.setMemory(l2, l3, by);
    }

    public static ByteBuffer allocateDirectNoCleaner(int n2) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        PlatformDependent.incrementMemoryCounter(n2);
        try {
            return PlatformDependent0.allocateDirectNoCleaner(n2);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n2);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n2) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n3 = n2 - byteBuffer.capacity();
        PlatformDependent.incrementMemoryCounter(n3);
        try {
            return PlatformDependent0.reallocateDirectNoCleaner(byteBuffer, n2);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n3);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static void freeDirectNoCleaner(ByteBuffer byteBuffer) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n2 = byteBuffer.capacity();
        PlatformDependent0.freeMemory(PlatformDependent0.directBufferAddress(byteBuffer));
        PlatformDependent.decrementMemoryCounter(n2);
    }

    private static void incrementMemoryCounter(int n2) {
        if (DIRECT_MEMORY_COUNTER != null) {
            long l2;
            long l3;
            do {
                if ((l2 = (l3 = DIRECT_MEMORY_COUNTER.get()) + (long)n2) <= DIRECT_MEMORY_LIMIT) continue;
                throw new OutOfDirectMemoryError("failed to allocate " + n2 + " byte(s) of direct memory (used: " + l3 + ", max: " + DIRECT_MEMORY_LIMIT + ')');
            } while (!DIRECT_MEMORY_COUNTER.compareAndSet(l3, l2));
        }
    }

    private static void decrementMemoryCounter(int n2) {
        if (DIRECT_MEMORY_COUNTER != null) {
            long l2 = DIRECT_MEMORY_COUNTER.addAndGet(-n2);
            assert (l2 >= 0L);
        }
    }

    public static boolean useDirectBufferNoCleaner() {
        return USE_DIRECT_BUFFER_NO_CLEANER;
    }

    public static <U, W> AtomicReferenceFieldUpdater<U, W> newAtomicReferenceFieldUpdater(Class<? super U> clazz, String string) {
        if (PlatformDependent.hasUnsafe()) {
            try {
                return PlatformDependent0.newAtomicReferenceFieldUpdater(clazz, string);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static <T> AtomicIntegerFieldUpdater<T> newAtomicIntegerFieldUpdater(Class<? super T> clazz, String string) {
        if (PlatformDependent.hasUnsafe()) {
            try {
                return PlatformDependent0.newAtomicIntegerFieldUpdater(clazz, string);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static <T> AtomicLongFieldUpdater<T> newAtomicLongFieldUpdater(Class<? super T> clazz, String string) {
        if (PlatformDependent.hasUnsafe()) {
            try {
                return PlatformDependent0.newAtomicLongFieldUpdater(clazz, string);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static <T> Queue<T> newMpscQueue() {
        return PlatformDependent.newMpscQueue(0x100000);
    }

    public static <T> Queue<T> newMpscQueue(int n2) {
        return PlatformDependent$Mpsc.newMpscQueue(n2);
    }

    public static <T> Queue<T> newSpscQueue() {
        if (PlatformDependent.hasUnsafe()) {
            return new SpscLinkedQueue();
        }
        return new SpscLinkedAtomicQueue();
    }

    public static <T> Queue<T> newFixedMpscQueue(int n2) {
        if (PlatformDependent.hasUnsafe()) {
            return new MpscArrayQueue(n2);
        }
        return new MpscAtomicArrayQueue(n2);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return PlatformDependent0.getClassLoader(clazz);
    }

    public static ClassLoader getContextClassLoader() {
        return PlatformDependent0.getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return PlatformDependent0.getSystemClassLoader();
    }

    public static <C> Deque<C> newConcurrentDeque() {
        if (PlatformDependent.javaVersion() < 7) {
            return new LinkedBlockingDeque();
        }
        return new ConcurrentLinkedDeque();
    }

    private static boolean isAndroid0() {
        boolean bl;
        try {
            Class.forName("android.app.Application", false, PlatformDependent.getSystemClassLoader());
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (bl) {
            logger.debug("Platform: Android");
        }
        return bl;
    }

    private static boolean isWindows0() {
        boolean bl = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("win");
        if (bl) {
            logger.debug("Platform: Windows");
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    private static boolean isRoot0() {
        Object object;
        Object object2;
        if (PlatformDependent.isWindows()) {
            return false;
        }
        Object object3 = new String[]{"/usr/bin/id", "/bin/id", "/usr/xpg4/bin/id", "id"};
        Pattern pattern = Pattern.compile("^(?:0|[1-9][0-9]*)$");
        int cfr_ignored_0 = ((String[])object3).length;
        for (int i2 = 0; i2 < 4; ++i2) {
            block42: {
                object2 = object3[i2];
                object = null;
                BufferedReader bufferedReader = null;
                object = Runtime.getRuntime().exec(new String[]{object2, "-u"});
                bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream(), CharsetUtil.US_ASCII));
                object2 = bufferedReader.readLine();
                bufferedReader.close();
                while (true) {
                    try {
                        int n2 = ((Process)object).waitFor();
                        if (n2 == 0) break;
                        object2 = null;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                if (object != null) {
                    try {
                        ((Process)object).destroy();
                    }
                    catch (Exception exception) {}
                }
                break block42;
                catch (Throwable throwable) {
                    object2 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (object != null) {
                        try {
                            ((Process)object).destroy();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (object != null) {
                        try {
                            ((Process)object).destroy();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
            }
            if (object2 == null || !pattern.matcher((CharSequence)object2).matches()) continue;
            logger.debug("UID: {}", object2);
            return "0".equals(object2);
        }
        logger.debug("Could not determine the current UID using /usr/bin/id; attempting to bind at privileged ports.");
        object3 = Pattern.compile(".*(?:denied|not.*permitted).*");
        for (int i3 = 1023; i3 > 0; --i3) {
            ServerSocket serverSocket;
            block40: {
                serverSocket = null;
                serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(i3));
                if (!logger.isDebugEnabled()) break block40;
                logger.debug("UID: 0 (succeded to bind at port {})", (Object)i3);
            }
            try {
                serverSocket.close();
            }
            catch (Exception exception) {}
            return true;
            catch (Exception exception) {
                block41: {
                    try {
                        object2 = exception;
                        object = exception.getMessage();
                        if (object == null) {
                            object = "";
                        }
                        if (!((Pattern)object3).matcher((CharSequence)(object = ((String)object).toLowerCase())).matches()) break block41;
                        if (serverSocket == null) break;
                    }
                    catch (Throwable throwable) {
                        if (serverSocket != null) {
                            try {
                                serverSocket.close();
                            }
                            catch (Exception exception2) {}
                        }
                        throw throwable;
                    }
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception3) {}
                    break;
                }
                if (serverSocket == null) continue;
                try {
                    serverSocket.close();
                }
                catch (Exception exception4) {}
                continue;
            }
        }
        logger.debug("UID: non-root (failed to bind at any privileged ports)");
        return false;
    }

    private static int javaVersion0() {
        int n2 = PlatformDependent.isAndroid() ? 6 : PlatformDependent.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)n2);
        return n2;
    }

    static int majorVersionFromJavaSpecificationVersion() {
        try {
            String string = AccessController.doPrivileged(new PlatformDependent$1());
            return PlatformDependent.majorVersion(string);
        }
        catch (SecurityException securityException) {
            logger.debug("security exception while reading java.specification.version", securityException);
            return 6;
        }
    }

    static int majorVersion(String stringArray) {
        stringArray = stringArray.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nArray[i2] = Integer.parseInt(stringArray[i2]);
        }
        if (nArray[0] == 1) {
            assert (nArray[1] >= 6);
            return nArray[1];
        }
        return nArray[0];
    }

    private static boolean explicitNoUnsafe0() {
        boolean bl = SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)bl);
        if (bl) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
            return true;
        }
        bl = SystemPropertyUtil.contains("com.aliyun.openservices.shade.io.netty.tryUnsafe") ? SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.tryUnsafe", true) : SystemPropertyUtil.getBoolean("org.jboss.netty.tryUnsafe", true);
        if (!bl) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.tryUnsafe/org.jboss.netty.tryUnsafe)");
            return true;
        }
        return false;
    }

    private static boolean hasUnsafe0() {
        if (PlatformDependent.isAndroid()) {
            logger.debug("sun.misc.Unsafe: unavailable (Android)");
            return false;
        }
        if (IS_EXPLICIT_NO_UNSAFE) {
            return false;
        }
        try {
            boolean bl = PlatformDependent0.hasUnsafe();
            logger.debug("sun.misc.Unsafe: {}", (Object)(bl ? "available" : "unavailable"));
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static long arrayBaseOffset0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1L;
        }
        return PlatformDependent0.arrayBaseOffset();
    }

    private static long maxDirectMemory0() {
        long l2;
        block13: {
            GenericDeclaration genericDeclaration;
            Object object;
            l2 = 0L;
            try {
                object = Class.forName("sun.misc.VM", true, PlatformDependent.getSystemClassLoader());
                genericDeclaration = ((Class)object).getDeclaredMethod("maxDirectMemory", new Class[0]);
                l2 = ((Number)((Method)genericDeclaration).invoke(null, new Object[0])).longValue();
            }
            catch (Throwable throwable) {}
            if (l2 > 0L) {
                return l2;
            }
            try {
                object = Class.forName("java.lang.management.ManagementFactory", true, PlatformDependent.getSystemClassLoader());
                genericDeclaration = Class.forName("java.lang.management.RuntimeMXBean", true, PlatformDependent.getSystemClassLoader());
                object = ((Class)object).getDeclaredMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
                object = (List)((Class)genericDeclaration).getDeclaredMethod("getInputArguments", new Class[0]).invoke(object, new Object[0]);
                for (int i2 = object.size() - 1; i2 >= 0; --i2) {
                    Matcher matcher = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN.matcher((CharSequence)object.get(i2));
                    if (!matcher.matches()) continue;
                    l2 = Long.parseLong(matcher.group(1));
                    switch (matcher.group(2).charAt(0)) {
                        case 'K': 
                        case 'k': {
                            l2 <<= 10;
                            break block13;
                        }
                        case 'M': 
                        case 'm': {
                            l2 *= 0x100000L;
                            break block13;
                        }
                        case 'G': 
                        case 'g': {
                            l2 *= 0x40000000L;
                        }
                    }
                    break;
                }
            }
            catch (Throwable throwable) {}
        }
        if (l2 <= 0L) {
            l2 = Runtime.getRuntime().maxMemory();
            logger.debug("maxDirectMemory: {} bytes (maybe)", (Object)l2);
        } else {
            logger.debug("maxDirectMemory: {} bytes", (Object)l2);
        }
        return l2;
    }

    private static boolean hasJavassist0() {
        if (PlatformDependent.isAndroid()) {
            return false;
        }
        boolean bl = SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.noJavassist", false);
        logger.debug("-Dio.netty.noJavassist: {}", (Object)bl);
        if (bl) {
            logger.debug("Javassist: unavailable (io.netty.noJavassist)");
            return false;
        }
        try {
            JavassistTypeParameterMatcherGenerator.generate(Object.class, PlatformDependent.getClassLoader(PlatformDependent.class));
            logger.debug("Javassist: available");
            return true;
        }
        catch (Throwable throwable) {
            logger.debug("Javassist: unavailable");
            logger.debug("You don't have Javassist in your class path or you don't have enough permission to load dynamically generated classes.  Please check the configuration for better performance.");
            return false;
        }
    }

    private static File tmpdir0() {
        File file;
        try {
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("com.aliyun.openservices.shade.io.netty.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {}", (Object)file);
                return file;
            }
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {} (java.io.tmpdir)", (Object)file);
                return file;
            }
            if (PlatformDependent.isWindows()) {
                file = PlatformDependent.toDirectory(System.getenv("TEMP"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} (%TEMP%)", (Object)file);
                    return file;
                }
                String string = System.getenv("USERPROFILE");
                if (string != null) {
                    file = PlatformDependent.toDirectory(string + "\\AppData\\Local\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\AppData\\Local\\Temp)", (Object)file);
                        return file;
                    }
                    file = PlatformDependent.toDirectory(string + "\\Local Settings\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\Local Settings\\Temp)", (Object)file);
                        return file;
                    }
                }
            } else {
                file = PlatformDependent.toDirectory(System.getenv("TMPDIR"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} ($TMPDIR)", (Object)file);
                    return file;
                }
            }
        }
        catch (Throwable throwable) {}
        file = PlatformDependent.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: {}", (Object)file);
        return file;
    }

    private static File toDirectory(String object) {
        if (object == null) {
            return null;
        }
        object = new File((String)object);
        ((File)object).mkdirs();
        if (!((File)object).isDirectory()) {
            return null;
        }
        try {
            return ((File)object).getAbsoluteFile();
        }
        catch (Exception exception) {
            return object;
        }
    }

    private static int bitMode0() {
        int n2 = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.bitMode", 0);
        if (n2 > 0) {
            logger.debug("-Dio.netty.bitMode: {}", (Object)n2);
            return n2;
        }
        n2 = SystemPropertyUtil.getInt("sun.arch.data.model", 0);
        if (n2 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (sun.arch.data.model)", (Object)n2);
            return n2;
        }
        n2 = SystemPropertyUtil.getInt("com.ibm.vm.bitmode", 0);
        if (n2 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (com.ibm.vm.bitmode)", (Object)n2);
            return n2;
        }
        Object object = SystemPropertyUtil.get("os.arch", "").toLowerCase(Locale.US).trim();
        if ("amd64".equals(object) || "x86_64".equals(object)) {
            n2 = 64;
        } else if ("i386".equals(object) || "i486".equals(object) || "i586".equals(object) || "i686".equals(object)) {
            n2 = 32;
        }
        if (n2 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (os.arch: {})", (Object)n2, object);
        }
        Object object2 = SystemPropertyUtil.get("java.vm.name", "").toLowerCase(Locale.US);
        object = Pattern.compile("([1-9][0-9]+)-?bit");
        object2 = ((Pattern)object).matcher((CharSequence)object2);
        if (((Matcher)object2).find()) {
            return Integer.parseInt(((Matcher)object2).group(1));
        }
        return 64;
    }

    private static int addressSize0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1;
        }
        return PlatformDependent0.addressSize();
    }

    private PlatformDependent() {
    }

    static /* synthetic */ InternalLogger access$100() {
        return logger;
    }

    static {
        long l2;
        logger = InternalLoggerFactory.getInstance(PlatformDependent.class);
        MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");
        IS_ANDROID = PlatformDependent.isAndroid0();
        IS_WINDOWS = PlatformDependent.isWindows0();
        JAVA_VERSION = PlatformDependent.javaVersion0();
        CAN_ENABLE_TCP_NODELAY_BY_DEFAULT = !PlatformDependent.isAndroid();
        IS_EXPLICIT_NO_UNSAFE = PlatformDependent.explicitNoUnsafe0();
        HAS_UNSAFE = PlatformDependent.hasUnsafe0();
        CAN_USE_CHM_V8 = HAS_UNSAFE && JAVA_VERSION < 8;
        DIRECT_BUFFER_PREFERRED = HAS_UNSAFE && !SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.noPreferDirect", false);
        MAX_DIRECT_MEMORY = PlatformDependent.maxDirectMemory0();
        ARRAY_BASE_OFFSET = PlatformDependent.arrayBaseOffset0();
        HAS_JAVASSIST = PlatformDependent.hasJavassist0();
        TMPDIR = PlatformDependent.tmpdir0();
        BIT_MODE = PlatformDependent.bitMode0();
        ADDRESS_SIZE = PlatformDependent.addressSize0();
        boolean bl = BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noPreferDirect: {}", (Object)(!DIRECT_BUFFER_PREFERRED ? 1 : 0));
        }
        if (!(PlatformDependent.hasUnsafe() || PlatformDependent.isAndroid() || IS_EXPLICIT_NO_UNSAFE)) {
            logger.info("Your platform does not provide complete low-level API for accessing direct buffers reliably. Unless explicitly requested, heap buffer will always be preferred to avoid potential system unstability.");
        }
        if ((l2 = SystemPropertyUtil.getLong("com.aliyun.openservices.shade.io.netty.maxDirectMemory", -1L)) == 0L || !PlatformDependent.hasUnsafe() || !PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            USE_DIRECT_BUFFER_NO_CLEANER = false;
            DIRECT_MEMORY_COUNTER = null;
        } else {
            USE_DIRECT_BUFFER_NO_CLEANER = true;
            DIRECT_MEMORY_COUNTER = l2 < 0L ? ((l2 = PlatformDependent.maxDirectMemory0()) <= 0L ? null : new AtomicLong()) : new AtomicLong();
        }
        DIRECT_MEMORY_LIMIT = l2;
        logger.debug("com.aliyun.openservices.shade.io.netty.maxDirectMemory: {} bytes", (Object)l2);
    }
}

