/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import com.aliyun.openservices.shade.io.netty.util.internal.Cleaner0;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0$1;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0$2;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0$3;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0$4;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0$5;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0$6;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0$7;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent0$8;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.UnsafeAtomicIntegerFieldUpdater;
import com.aliyun.openservices.shade.io.netty.util.internal.UnsafeAtomicLongFieldUpdater;
import com.aliyun.openservices.shade.io.netty.util.internal.UnsafeAtomicReferenceFieldUpdater;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;

final class PlatformDependent0 {
    private static final InternalLogger logger;
    static final Unsafe UNSAFE;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final Constructor<?> DIRECT_BUFFER_CONSTRUCTOR;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final boolean UNALIGNED;

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static void throwException(Throwable throwable) {
        UNSAFE.throwException(ObjectUtil.checkNotNull(throwable, "cause"));
    }

    static boolean hasDirectBufferNoCleanerConstructor() {
        return DIRECT_BUFFER_CONSTRUCTOR != null;
    }

    static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n2) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.reallocateMemory(PlatformDependent0.directBufferAddress(byteBuffer), n2), n2);
    }

    static ByteBuffer allocateDirectNoCleaner(int n2) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.allocateMemory(n2), n2);
    }

    static ByteBuffer newDirectBuffer(long l2, int n2) {
        ObjectUtil.checkPositiveOrZero(l2, "address");
        ObjectUtil.checkPositiveOrZero(n2, "capacity");
        try {
            return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(l2, n2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Error) {
                throw (Error)throwable2;
            }
            throw new Error(throwable2);
        }
    }

    static void freeDirectBuffer(ByteBuffer byteBuffer) {
        Cleaner0.freeDirectBuffer(byteBuffer);
    }

    static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.getLong(byteBuffer, ADDRESS_FIELD_OFFSET);
    }

    static long arrayBaseOffset() {
        return UNSAFE.arrayBaseOffset(byte[].class);
    }

    static Object getObject(Object object, long l2) {
        return UNSAFE.getObject(object, l2);
    }

    static Object getObjectVolatile(Object object, long l2) {
        return UNSAFE.getObjectVolatile(object, l2);
    }

    static int getInt(Object object, long l2) {
        return UNSAFE.getInt(object, l2);
    }

    private static long getLong(Object object, long l2) {
        return UNSAFE.getLong(object, l2);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long l2) {
        return UNSAFE.getByte(l2);
    }

    static short getShort(long l2) {
        return UNSAFE.getShort(l2);
    }

    static int getInt(long l2) {
        return UNSAFE.getInt(l2);
    }

    static long getLong(long l2) {
        return UNSAFE.getLong(l2);
    }

    static byte getByte(byte[] byArray, int n2) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static short getShort(byte[] byArray, int n2) {
        return UNSAFE.getShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static int getInt(byte[] byArray, int n2) {
        return UNSAFE.getInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static long getLong(byte[] byArray, int n2) {
        return UNSAFE.getLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2);
    }

    static void putOrderedObject(Object object, long l2, Object object2) {
        UNSAFE.putOrderedObject(object, l2, object2);
    }

    static void putByte(long l2, byte by) {
        UNSAFE.putByte(l2, by);
    }

    static void putShort(long l2, short s2) {
        UNSAFE.putShort(l2, s2);
    }

    static void putInt(long l2, int n2) {
        UNSAFE.putInt(l2, n2);
    }

    static void putLong(long l2, long l3) {
        UNSAFE.putLong(l2, l3);
    }

    static void putByte(byte[] byArray, int n2, byte by) {
        UNSAFE.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, by);
    }

    static void putShort(byte[] byArray, int n2, short s2) {
        UNSAFE.putShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, s2);
    }

    static void putInt(byte[] byArray, int n2, int n3) {
        UNSAFE.putInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, n3);
    }

    static void putLong(byte[] byArray, int n2, long l2) {
        UNSAFE.putLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n2, l2);
    }

    static void copyMemory(long l2, long l3, long l4) {
        while (l4 > 0L) {
            long l5 = Math.min(l4, 0x100000L);
            UNSAFE.copyMemory(l2, l3, l5);
            l4 -= l5;
            l2 += l5;
            l3 += l5;
        }
    }

    static void copyMemory(Object object, long l2, Object object2, long l3, long l4) {
        while (l4 > 0L) {
            long l5 = Math.min(l4, 0x100000L);
            UNSAFE.copyMemory(object, l2, object2, l3, l5);
            l4 -= l5;
            l2 += l5;
            l3 += l5;
        }
    }

    static void setMemory(long l2, long l3, byte by) {
        UNSAFE.setMemory(l2, l3, by);
    }

    static void setMemory(Object object, long l2, long l3, byte by) {
        UNSAFE.setMemory(object, l2, l3, by);
    }

    static <U, W> AtomicReferenceFieldUpdater<U, W> newAtomicReferenceFieldUpdater(Class<? super U> clazz, String string) {
        return new UnsafeAtomicReferenceFieldUpdater(UNSAFE, clazz, string);
    }

    static <T> AtomicIntegerFieldUpdater<T> newAtomicIntegerFieldUpdater(Class<? super T> clazz, String string) {
        return new UnsafeAtomicIntegerFieldUpdater<T>(UNSAFE, clazz, string);
    }

    static <T> AtomicLongFieldUpdater<T> newAtomicLongFieldUpdater(Class<? super T> clazz, String string) {
        return new UnsafeAtomicLongFieldUpdater<T>(UNSAFE, clazz, string);
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$6(clazz));
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$7());
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$8());
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static long allocateMemory(long l2) {
        return UNSAFE.allocateMemory(l2);
    }

    static void freeMemory(long l2) {
        UNSAFE.freeMemory(l2);
    }

    private PlatformDependent0() {
    }

    static {
        Unsafe unsafe;
        Object object;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        Object object2 = AccessController.doPrivileged(new PlatformDependent0$1(byteBuffer));
        if (object2 instanceof Field) {
            object2 = (Field)object2;
            logger.debug("java.nio.Buffer.address: available");
        } else {
            logger.debug("java.nio.Buffer.address: unavailable", (Exception)object2);
            object2 = null;
        }
        if (object2 != null) {
            object = AccessController.doPrivileged(new PlatformDependent0$2());
            if (object instanceof Exception) {
                unsafe = null;
                logger.debug("sun.misc.Unsafe.theUnsafe: unavailable", (Exception)object);
            } else {
                unsafe = (Unsafe)object;
                logger.debug("sun.misc.Unsafe.theUnsafe: available");
            }
            if (unsafe != null) {
                object = unsafe;
                if ((object = AccessController.doPrivileged(new PlatformDependent0$3((Unsafe)object))) == null) {
                    logger.debug("sun.misc.Unsafe.copyMemory: available");
                } else {
                    unsafe = null;
                    logger.debug("sun.misc.Unsafe.copyMemory: unavailable", (Exception)object);
                }
            }
        } else {
            unsafe = null;
        }
        UNSAFE = unsafe;
        if (unsafe == null) {
            BYTE_ARRAY_BASE_OFFSET = -1L;
            ADDRESS_FIELD_OFFSET = -1L;
            UNALIGNED = false;
            DIRECT_BUFFER_CONSTRUCTOR = null;
        } else {
            boolean bl;
            long l2 = -1L;
            try {
                object = AccessController.doPrivileged(new PlatformDependent0$4(byteBuffer));
                if (object instanceof Constructor) {
                    l2 = UNSAFE.allocateMemory(1L);
                    try {
                        ((Constructor)object).newInstance(l2, 1);
                        object = (Constructor)object;
                        logger.debug("direct buffer constructor: available");
                    }
                    catch (InstantiationException instantiationException) {
                        object = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object = null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object = null;
                    }
                } else {
                    logger.debug("direct buffer constructor: unavailable", (Exception)object);
                    object = null;
                }
            }
            finally {
                if (l2 != -1L) {
                    UNSAFE.freeMemory(l2);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = object;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset((Field)object2);
            object2 = AccessController.doPrivileged(new PlatformDependent0$5());
            if (object2 instanceof Boolean) {
                bl = (Boolean)object2;
                logger.debug("java.nio.Bits.unaligned: available, {}", (Object)bl);
            } else {
                object = SystemPropertyUtil.get("os.arch", "");
                bl = ((String)object).matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
                object2 = (Exception)object2;
                logger.debug("java.nio.Bits.unaligned: unavailable, " + bl, (Throwable)object2);
            }
            UNALIGNED = bl;
            BYTE_ARRAY_BASE_OFFSET = PlatformDependent0.arrayBaseOffset();
        }
        logger.debug("java.nio.DirectByteBuffer.<init>(long, int): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
        PlatformDependent0.freeDirectBuffer(byteBuffer);
    }
}

