/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import com.aliyun.openservices.shade.io.netty.util.Recycler;
import com.aliyun.openservices.shade.io.netty.util.Recycler$Handle;
import com.aliyun.openservices.shade.io.netty.util.internal.RecyclableArrayList$1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public final class RecyclableArrayList
extends ArrayList<Object> {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Recycler<RecyclableArrayList> RECYCLER = new RecyclableArrayList$1();
    private boolean insertSinceRecycled;
    private final Recycler$Handle handle;

    public static RecyclableArrayList newInstance() {
        return RecyclableArrayList.newInstance(8);
    }

    public static RecyclableArrayList newInstance(int n2) {
        RecyclableArrayList recyclableArrayList = RECYCLER.get();
        recyclableArrayList.ensureCapacity(n2);
        return recyclableArrayList;
    }

    private RecyclableArrayList(Recycler$Handle recycler$Handle) {
        this(recycler$Handle, 8);
    }

    private RecyclableArrayList(Recycler$Handle recycler$Handle, int n2) {
        super(n2);
        this.handle = recycler$Handle;
    }

    @Override
    public final boolean addAll(Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public final boolean addAll(int n2, Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(n2, collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    private static void checkNullElements(Collection<?> object) {
        if (object instanceof RandomAccess && object instanceof List) {
            object = (List)object;
            int n2 = object.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (object.get(i2) != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 != null) continue;
            throw new IllegalArgumentException("c contains null values");
        }
    }

    @Override
    public final boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        if (super.add(object)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public final void add(int n2, Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        super.add(n2, object);
        this.insertSinceRecycled = true;
    }

    @Override
    public final Object set(int n2, Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        Object object2 = super.set(n2, object);
        this.insertSinceRecycled = true;
        return object2;
    }

    public final boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    public final boolean recycle() {
        this.clear();
        this.insertSinceRecycled = false;
        RecyclableArrayList recyclableArrayList = this;
        return RECYCLER.recycle(recyclableArrayList, recyclableArrayList.handle);
    }

    /* synthetic */ RecyclableArrayList(Recycler$Handle recycler$Handle, RecyclableArrayList$1 recyclableArrayList$1) {
        this(recycler$Handle);
    }
}

