/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.IOException;

public final class StringUtil {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final String EMPTY_STRING = "";
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final int CSV_NUMBER_ESCAPE_CHARACTERS = 7;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    private StringUtil() {
    }

    public static String substringAfter(String string, char c2) {
        int n2 = string.indexOf(c2);
        c2 = (char)n2;
        if (n2 >= 0) {
            return string.substring(c2 + '\u0001');
        }
        return null;
    }

    public static boolean commonSuffixOfLength(String string, String string2, int n2) {
        if (string != null && string2 != null && n2 >= 0) {
            String string3 = string;
            String string4 = string2;
            if (string3.regionMatches(string3.length() - n2, string4, string4.length() - n2, n2)) {
                return true;
            }
        }
        return false;
    }

    public static String byteToHexStringPadded(int n2) {
        return BYTE2HEX_PAD[n2 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexStringPadded(T t2, int n2) {
        try {
            t2.append(StringUtil.byteToHexStringPadded(n2));
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            PlatformDependent.throwException(iOException);
        }
        return t2;
    }

    public static String toHexStringPadded(byte[] byArray) {
        return StringUtil.toHexStringPadded(byArray, 0, byArray.length);
    }

    public static String toHexStringPadded(byte[] byArray, int n2, int n3) {
        return StringUtil.toHexStringPadded(new StringBuilder(n3 << 1), byArray, n2, n3).toString();
    }

    public static <T extends Appendable> T toHexStringPadded(T t2, byte[] byArray) {
        return StringUtil.toHexStringPadded(t2, byArray, 0, byArray.length);
    }

    public static <T extends Appendable> T toHexStringPadded(T t2, byte[] byArray, int n2, int n3) {
        n3 = n2 + n3;
        while (n2 < n3) {
            StringUtil.byteToHexStringPadded(t2, byArray[n2]);
            ++n2;
        }
        return t2;
    }

    public static String byteToHexString(int n2) {
        return BYTE2HEX_NOPAD[n2 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexString(T t2, int n2) {
        try {
            t2.append(StringUtil.byteToHexString(n2));
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            PlatformDependent.throwException(iOException);
        }
        return t2;
    }

    public static String toHexString(byte[] byArray) {
        return StringUtil.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n2, int n3) {
        return StringUtil.toHexString(new StringBuilder(n3 << 1), byArray, n2, n3).toString();
    }

    public static <T extends Appendable> T toHexString(T t2, byte[] byArray) {
        return StringUtil.toHexString(t2, byArray, 0, byArray.length);
    }

    public static <T extends Appendable> T toHexString(T t2, byte[] byArray, int n2, int n3) {
        assert (n3 >= 0);
        if (n3 == 0) {
            return t2;
        }
        n3 = n2 + n3;
        int n4 = n3 - 1;
        while (n2 < n4 && byArray[n2] == 0) {
            ++n2;
        }
        StringUtil.byteToHexString(t2, byArray[n2++]);
        StringUtil.toHexStringPadded(t2, byArray, n2, n3 -= n2);
        return t2;
    }

    public static String simpleClassName(Object object) {
        if (object == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(object.getClass());
    }

    public static String simpleClassName(Class<?> object) {
        int n2 = ((String)(object = ObjectUtil.checkNotNull(object, "clazz").getName())).lastIndexOf(46);
        if (n2 >= 0) {
            return ((String)object).substring(n2 + 1);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence escapeCsv(CharSequence charSequence) {
        int n2 = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (n2 == 0) {
            return charSequence;
        }
        int n3 = n2 - 1;
        boolean bl = StringUtil.isDoubleQuote(charSequence.charAt(0)) && StringUtil.isDoubleQuote(charSequence.charAt(n3)) && n2 != 1;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder(n2 + 7).append('\"');
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            switch (c2) {
                case '\"': {
                    if (i2 == 0 || i2 == n3) {
                        if (bl) continue block4;
                        stringBuilder.append('\"');
                    } else {
                        boolean bl4 = StringUtil.isDoubleQuote(charSequence.charAt(i2 + 1));
                        if (StringUtil.isDoubleQuote(charSequence.charAt(i2 - 1)) || bl4 && i2 + 1 != n3) break;
                        stringBuilder.append('\"');
                        bl3 = true;
                        break;
                    }
                }
                case '\n': 
                case '\r': 
                case ',': {
                    bl2 = true;
                }
            }
            stringBuilder.append(c2);
        }
        if (bl3 || bl2 && !bl) {
            return stringBuilder.append('\"');
        }
        return charSequence;
    }

    public static CharSequence unescapeCsv(CharSequence charSequence) {
        int n2 = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (n2 == 0) {
            return charSequence;
        }
        int n3 = n2 - 1;
        n2 = StringUtil.isDoubleQuote(charSequence.charAt(0)) && StringUtil.isDoubleQuote(charSequence.charAt(n3)) && n2 != 1 ? 1 : 0;
        if (n2 == 0) {
            StringUtil.validateCsvFormat(charSequence);
            return charSequence;
        }
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        for (int i2 = 1; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '\"') {
                if (StringUtil.isDoubleQuote(charSequence.charAt(i2 + 1)) && i2 + 1 != n3) {
                    ++i2;
                } else {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2);
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static void validateCsvFormat(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            switch (charSequence.charAt(i2)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i2);
                }
            }
        }
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence charSequence, int n2) {
        return new IllegalArgumentException("invalid escaped CSV field: " + charSequence + " index: " + n2);
    }

    public static int length(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udfff';
    }

    private static boolean isDoubleQuote(char c2) {
        return c2 == '\"';
    }

    static {
        int n2 = 0;
        while (n2 < 10) {
            StringUtil.BYTE2HEX_PAD[n2] = "0" + n2;
            int n3 = n2++;
            StringUtil.BYTE2HEX_NOPAD[n3] = String.valueOf(n3);
        }
        while (n2 < 16) {
            char c2 = (char)(n2 + 97 - 10);
            StringUtil.BYTE2HEX_PAD[n2] = "0" + c2;
            StringUtil.BYTE2HEX_NOPAD[n2] = String.valueOf(c2);
            ++n2;
        }
        while (n2 < BYTE2HEX_PAD.length) {
            String string;
            StringUtil.BYTE2HEX_PAD[n2] = string = Integer.toHexString(n2);
            StringUtil.BYTE2HEX_NOPAD[n2] = string;
            ++n2;
        }
    }
}

