/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import com.aliyun.openservices.shade.io.netty.util.internal.JavassistTypeParameterMatcherGenerator;
import com.aliyun.openservices.shade.io.netty.util.internal.NoOpTypeParameterMatcher;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.TypeParameterMatcher$ReflectiveMatcher;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeParameterMatcher {
    private static final TypeParameterMatcher NOOP = new NoOpTypeParameterMatcher();
    private static final Object TEST_OBJECT = new Object();

    public static TypeParameterMatcher get(Class<?> clazz) {
        Map<Class<?>, TypeParameterMatcher> map = InternalThreadLocalMap.get().typeParameterMatcherGetCache();
        TypeParameterMatcher typeParameterMatcher = map.get(clazz);
        if (typeParameterMatcher == null) {
            if (clazz == Object.class) {
                typeParameterMatcher = NOOP;
            } else if (PlatformDependent.hasJavassist()) {
                try {
                    typeParameterMatcher = JavassistTypeParameterMatcherGenerator.generate(clazz);
                    typeParameterMatcher.match(TEST_OBJECT);
                }
                catch (IllegalAccessError illegalAccessError) {
                    typeParameterMatcher = null;
                }
                catch (Exception exception) {
                    typeParameterMatcher = null;
                }
            }
            if (typeParameterMatcher == null) {
                typeParameterMatcher = new TypeParameterMatcher$ReflectiveMatcher(clazz);
            }
            map.put(clazz, typeParameterMatcher);
        }
        return typeParameterMatcher;
    }

    public static TypeParameterMatcher find(Object object, Class<?> clazz, String string) {
        Class<?> clazz2;
        Map<Class<?>, Map<String, TypeParameterMatcher>> map = InternalThreadLocalMap.get().typeParameterMatcherFindCache();
        Map<String, TypeParameterMatcher> map2 = map.get(clazz2 = object.getClass());
        if (map2 == null) {
            map2 = new HashMap<String, TypeParameterMatcher>();
            map.put(clazz2, map2);
        }
        if ((map = map2.get(string)) == null) {
            map = TypeParameterMatcher.get(TypeParameterMatcher.find0(object, clazz, string));
            map2.put(string, (TypeParameterMatcher)((Object)map));
        }
        return map;
    }

    private static Class<?> find0(Object clazz, Class<?> object, String string) {
        Class<?> clazz2 = clazz = clazz.getClass();
        while (true) {
            if (clazz2.getSuperclass() == object) {
                int n2 = -1;
                TypeVariable<Class<?>>[] typeVariableArray = clazz2.getSuperclass().getTypeParameters();
                for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
                    if (!string.equals(typeVariableArray[i2].getName())) continue;
                    n2 = i2;
                    break;
                }
                if (n2 < 0) {
                    throw new IllegalStateException("unknown type parameter '" + string + "': " + object);
                }
                Type type = clazz2.getGenericSuperclass();
                if (!(type instanceof ParameterizedType)) {
                    return Object.class;
                }
                object = ((ParameterizedType)type).getActualTypeArguments();
                if ((object = object[n2]) instanceof ParameterizedType) {
                    object = ((ParameterizedType)object).getRawType();
                }
                if (object instanceof Class) {
                    return (Class)object;
                }
                if (object instanceof GenericArrayType) {
                    Type type2 = ((GenericArrayType)object).getGenericComponentType();
                    if (type2 instanceof ParameterizedType) {
                        type2 = ((ParameterizedType)type2).getRawType();
                    }
                    if (type2 instanceof Class) {
                        return Array.newInstance((Class)type2, 0).getClass();
                    }
                }
                if (object instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)object;
                    clazz2 = clazz;
                    if (!(typeVariable.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    object = (Class)typeVariable.getGenericDeclaration();
                    string = typeVariable.getName();
                    if (((Class)object).isAssignableFrom(clazz)) continue;
                    return Object.class;
                }
                return TypeParameterMatcher.fail(clazz, string);
            }
            if ((clazz2 = clazz2.getSuperclass()) == null) break;
        }
        return TypeParameterMatcher.fail(clazz, string);
    }

    private static Class<?> fail(Class<?> clazz, String string) {
        throw new IllegalStateException("cannot determine the type of the type parameter '" + string + "': " + clazz);
    }

    public abstract boolean match(Object var1);

    protected TypeParameterMatcher() {
    }
}

