/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import sun.misc.Unsafe;

final class UnsafeAtomicIntegerFieldUpdater<T>
extends AtomicIntegerFieldUpdater<T> {
    private final long offset;
    private final Unsafe unsafe;

    UnsafeAtomicIntegerFieldUpdater(Unsafe unsafe, Class<? super T> annotatedElement, String string) {
        annotatedElement = annotatedElement.getDeclaredField(string);
        if (!Modifier.isVolatile(((Field)annotatedElement).getModifiers())) {
            throw new IllegalArgumentException("Must be volatile");
        }
        this.unsafe = unsafe;
        this.offset = unsafe.objectFieldOffset((Field)annotatedElement);
    }

    @Override
    public final boolean compareAndSet(T t2, int n2, int n3) {
        return this.unsafe.compareAndSwapInt(t2, this.offset, n2, n3);
    }

    @Override
    public final boolean weakCompareAndSet(T t2, int n2, int n3) {
        return this.unsafe.compareAndSwapInt(t2, this.offset, n2, n3);
    }

    @Override
    public final void set(T t2, int n2) {
        this.unsafe.putIntVolatile(t2, this.offset, n2);
    }

    @Override
    public final void lazySet(T t2, int n2) {
        this.unsafe.putOrderedInt(t2, this.offset, n2);
    }

    @Override
    public final int get(T t2) {
        return this.unsafe.getIntVolatile(t2, this.offset);
    }
}

