/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import sun.misc.Unsafe;

final class UnsafeAtomicLongFieldUpdater<T>
extends AtomicLongFieldUpdater<T> {
    private final long offset;
    private final Unsafe unsafe;

    UnsafeAtomicLongFieldUpdater(Unsafe unsafe, Class<? super T> annotatedElement, String string) {
        annotatedElement = annotatedElement.getDeclaredField(string);
        if (!Modifier.isVolatile(((Field)annotatedElement).getModifiers())) {
            throw new IllegalArgumentException("Must be volatile");
        }
        this.unsafe = unsafe;
        this.offset = unsafe.objectFieldOffset((Field)annotatedElement);
    }

    @Override
    public final boolean compareAndSet(T t2, long l2, long l3) {
        return this.unsafe.compareAndSwapLong(t2, this.offset, l2, l3);
    }

    @Override
    public final boolean weakCompareAndSet(T t2, long l2, long l3) {
        return this.unsafe.compareAndSwapLong(t2, this.offset, l2, l3);
    }

    @Override
    public final void set(T t2, long l2) {
        this.unsafe.putLongVolatile(t2, this.offset, l2);
    }

    @Override
    public final void lazySet(T t2, long l2) {
        this.unsafe.putOrderedLong(t2, this.offset, l2);
    }

    @Override
    public final long get(T t2) {
        return this.unsafe.getLongVolatile(t2, this.offset);
    }
}

