/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import sun.misc.Unsafe;

final class UnsafeAtomicReferenceFieldUpdater<U, M>
extends AtomicReferenceFieldUpdater<U, M> {
    private final long offset;
    private final Unsafe unsafe;

    UnsafeAtomicReferenceFieldUpdater(Unsafe unsafe, Class<? super U> annotatedElement, String string) {
        annotatedElement = annotatedElement.getDeclaredField(string);
        if (!Modifier.isVolatile(((Field)annotatedElement).getModifiers())) {
            throw new IllegalArgumentException("Must be volatile");
        }
        this.unsafe = unsafe;
        this.offset = unsafe.objectFieldOffset((Field)annotatedElement);
    }

    @Override
    public final boolean compareAndSet(U u2, M m2, M m3) {
        return this.unsafe.compareAndSwapObject(u2, this.offset, m2, m3);
    }

    @Override
    public final boolean weakCompareAndSet(U u2, M m2, M m3) {
        return this.unsafe.compareAndSwapObject(u2, this.offset, m2, m3);
    }

    @Override
    public final void set(U u2, M m2) {
        this.unsafe.putObjectVolatile(u2, this.offset, m2);
    }

    @Override
    public final void lazySet(U u2, M m2) {
        this.unsafe.putOrderedObject(u2, this.offset, m2);
    }

    @Override
    public final M get(U u2) {
        return (M)this.unsafe.getObjectVolatile(u2, this.offset);
    }
}

