/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal.chmv8;

import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.CountedCompleter$1;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinTask;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import sun.misc.Unsafe;

public abstract class CountedCompleter<T>
extends ForkJoinTask<T> {
    private static final long serialVersionUID = 5232453752276485070L;
    final CountedCompleter<?> completer;
    volatile int pending;
    private static final Unsafe U;
    private static final long PENDING;

    protected CountedCompleter(CountedCompleter<?> countedCompleter, int n2) {
        this.completer = countedCompleter;
        this.pending = n2;
    }

    protected CountedCompleter(CountedCompleter<?> countedCompleter) {
        this.completer = countedCompleter;
    }

    protected CountedCompleter() {
        this.completer = null;
    }

    public abstract void compute();

    public void onCompletion(CountedCompleter<?> countedCompleter) {
    }

    public boolean onExceptionalCompletion(Throwable throwable, CountedCompleter<?> countedCompleter) {
        return true;
    }

    public final CountedCompleter<?> getCompleter() {
        return this.completer;
    }

    public final int getPendingCount() {
        return this.pending;
    }

    public final void setPendingCount(int n2) {
        this.pending = n2;
    }

    public final void addToPendingCount(int n2) {
        int n3;
        while (!U.compareAndSwapInt(this, PENDING, n3 = this.pending, n3 + n2)) {
        }
    }

    public final boolean compareAndSetPendingCount(int n2, int n3) {
        return U.compareAndSwapInt(this, PENDING, n2, n3);
    }

    public final int decrementPendingCountUnlessZero() {
        int n2;
        while ((n2 = this.pending) != 0) {
            int n3 = n2;
            if (!U.compareAndSwapInt(this, PENDING, n3, n3 - 1)) continue;
        }
        return n2;
    }

    public final CountedCompleter<?> getRoot() {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = this;
        while ((countedCompleter = countedCompleter2.completer) != null) {
            countedCompleter2 = countedCompleter;
        }
        return countedCompleter2;
    }

    public final void tryComplete() {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = countedCompleter = this;
        while (true) {
            int n2;
            if ((n2 = countedCompleter.pending) == 0) {
                countedCompleter.onCompletion(countedCompleter2);
                countedCompleter2 = countedCompleter;
                countedCompleter = countedCompleter2.completer;
                if (countedCompleter != null) continue;
                countedCompleter2.quietlyComplete();
                return;
            }
            int n3 = n2;
            if (U.compareAndSwapInt(countedCompleter, PENDING, n3, n3 - 1)) break;
        }
    }

    public final void propagateCompletion() {
        CountedCompleter<?> countedCompleter = this;
        while (true) {
            int n2;
            if ((n2 = countedCompleter.pending) == 0) {
                CountedCompleter<?> countedCompleter2 = countedCompleter;
                countedCompleter = countedCompleter2.completer;
                if (countedCompleter != null) continue;
                countedCompleter2.quietlyComplete();
                return;
            }
            int n3 = n2;
            if (U.compareAndSwapInt(countedCompleter, PENDING, n3, n3 - 1)) break;
        }
    }

    @Override
    public void complete(T object) {
        this.setRawResult((T)object);
        CountedCompleter countedCompleter = this;
        countedCompleter.onCompletion(countedCompleter);
        this.quietlyComplete();
        object = this.completer;
        if (object != null) {
            ((CountedCompleter)object).tryComplete();
        }
    }

    public final CountedCompleter<?> firstComplete() {
        int n2;
        do {
            int n3;
            if ((n3 = this.pending) == 0) {
                return this;
            }
            n2 = n3;
        } while (!U.compareAndSwapInt(this, PENDING, n2, n2 - 1));
        return null;
    }

    public final CountedCompleter<?> nextComplete() {
        CountedCompleter<?> countedCompleter = this.completer;
        if (countedCompleter != null) {
            return countedCompleter.firstComplete();
        }
        this.quietlyComplete();
        return null;
    }

    public final void quietlyCompleteRoot() {
        CountedCompleter<?> countedCompleter = this;
        while (true) {
            CountedCompleter<?> countedCompleter2;
            if ((countedCompleter2 = countedCompleter.completer) == null) {
                countedCompleter.quietlyComplete();
                return;
            }
            countedCompleter = countedCompleter2;
        }
    }

    @Override
    void internalPropagateException(Throwable throwable) {
        CountedCompleter<?> countedCompleter;
        CountedCompleter<?> countedCompleter2 = countedCompleter = this;
        while (countedCompleter.onExceptionalCompletion(throwable, countedCompleter2)) {
            countedCompleter2 = countedCompleter;
            countedCompleter = countedCompleter2.completer;
            if (countedCompleter != null && countedCompleter.status >= 0 && countedCompleter.recordExceptionalCompletion(throwable) == Integer.MIN_VALUE) continue;
        }
    }

    @Override
    protected final boolean exec() {
        this.compute();
        return false;
    }

    @Override
    public T getRawResult() {
        return null;
    }

    @Override
    protected void setRawResult(T t2) {
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new CountedCompleter$1());
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
            }
        }
    }

    static {
        try {
            U = CountedCompleter.getUnsafe();
            PENDING = U.objectFieldOffset(CountedCompleter.class.getDeclaredField("pending"));
            return;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

