/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal.chmv8;

import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.CountedCompleter;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinPool;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinPool$WorkQueue;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinTask$1;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinTask$AdaptedCallable;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinTask$AdaptedRunnable;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinTask$AdaptedRunnableAction;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinTask$ExceptionNode;
import com.aliyun.openservices.shade.io.netty.util.internal.chmv8.ForkJoinWorkerThread;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import sun.misc.Unsafe;

public abstract class ForkJoinTask<V>
implements Serializable,
Future<V> {
    volatile int status;
    static final int DONE_MASK = -268435456;
    static final int NORMAL = -268435456;
    static final int CANCELLED = -1073741824;
    static final int EXCEPTIONAL = Integer.MIN_VALUE;
    static final int SIGNAL = 65536;
    static final int SMASK = 65535;
    private static final ForkJoinTask$ExceptionNode[] exceptionTable;
    private static final ReentrantLock exceptionTableLock;
    private static final ReferenceQueue<Object> exceptionTableRefQueue;
    private static final int EXCEPTION_MAP_CAPACITY = 32;
    private static final long serialVersionUID = -7721805057305804111L;
    private static final Unsafe U;
    private static final long STATUS;

    private int setCompletion(int n2) {
        int n3;
        int n4;
        do {
            if ((n3 = this.status) < 0) {
                return n3;
            }
            n4 = n3;
        } while (!U.compareAndSwapInt(this, STATUS, n4, n4 | n2));
        if (n3 >>> 16 != 0) {
            ForkJoinTask forkJoinTask = this;
            synchronized (forkJoinTask) {
                this.notifyAll();
            }
        }
        return n2;
    }

    final int doExec() {
        int n2 = this.status;
        if (n2 >= 0) {
            boolean bl;
            try {
                bl = this.exec();
            }
            catch (Throwable throwable) {
                return this.setExceptionalCompletion(throwable);
            }
            if (bl) {
                n2 = this.setCompletion(-268435456);
            }
        }
        return n2;
    }

    final boolean trySetSignal() {
        int n2 = this.status;
        if (n2 >= 0) {
            int n3 = n2;
            if (U.compareAndSwapInt(this, STATUS, n3, n3 | 0x10000)) {
                return true;
            }
        }
        return false;
    }

    private int externalAwaitDone() {
        ForkJoinPool forkJoinPool = ForkJoinPool.common;
        int n2 = this.status;
        if (n2 >= 0) {
            if (forkJoinPool != null) {
                if (this instanceof CountedCompleter) {
                    n2 = forkJoinPool.externalHelpComplete((CountedCompleter)this);
                } else if (forkJoinPool.tryExternalUnpush(this)) {
                    n2 = this.doExec();
                }
            }
            if (n2 >= 0 && (n2 = this.status) >= 0) {
                boolean bl = false;
                do {
                    int n3 = n2;
                    if (!U.compareAndSwapInt(this, STATUS, n3, n3 | 0x10000)) continue;
                    ForkJoinTask forkJoinTask = this;
                    synchronized (forkJoinTask) {
                        if (this.status >= 0) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                bl = true;
                            }
                        } else {
                            this.notifyAll();
                        }
                    }
                } while ((n2 = this.status) >= 0);
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return n2;
    }

    private int externalInterruptibleAwaitDone() {
        int n2;
        Object object = ForkJoinPool.common;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.status >= 0 && object != null) {
            if (this instanceof CountedCompleter) {
                ((ForkJoinPool)object).externalHelpComplete((CountedCompleter)this);
            } else if (((ForkJoinPool)object).tryExternalUnpush(this)) {
                this.doExec();
            }
        }
        while ((n2 = this.status) >= 0) {
            int n3 = n2;
            if (!U.compareAndSwapInt(this, STATUS, n3, n3 | 0x10000)) continue;
            object = this;
            synchronized (object) {
                if (this.status >= 0) {
                    this.wait();
                } else {
                    this.notifyAll();
                }
            }
        }
        return n2;
    }

    private int doJoin() {
        int n2 = this.status;
        if (n2 < 0) {
            return n2;
        }
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            int n3;
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = forkJoinWorkerThread.workQueue;
            if (forkJoinPool$WorkQueue.tryUnpush(this) && (n3 = this.doExec()) < 0) {
                return n3;
            }
            return forkJoinWorkerThread.pool.awaitJoin(forkJoinPool$WorkQueue, this);
        }
        return this.externalAwaitDone();
    }

    private int doInvoke() {
        int n2 = this.doExec();
        if (n2 < 0) {
            return n2;
        }
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            thread = (ForkJoinWorkerThread)thread;
            return ((ForkJoinWorkerThread)thread).pool.awaitJoin(((ForkJoinWorkerThread)thread).workQueue, this);
        }
        return this.externalAwaitDone();
    }

    final int recordExceptionalCompletion(Throwable throwable) {
        int n2 = this.status;
        if (n2 >= 0) {
            n2 = System.identityHashCode(this);
            ReentrantLock reentrantLock = exceptionTableLock;
            reentrantLock.lock();
            try {
                ForkJoinTask.expungeStaleExceptions();
                ForkJoinTask$ExceptionNode[] forkJoinTask$ExceptionNodeArray = exceptionTable;
                ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNodeArray[n2 &= forkJoinTask$ExceptionNodeArray.length - 1];
                while (true) {
                    if (forkJoinTask$ExceptionNode == null) {
                        forkJoinTask$ExceptionNodeArray[n2] = new ForkJoinTask$ExceptionNode(this, throwable, forkJoinTask$ExceptionNodeArray[n2]);
                    } else if (forkJoinTask$ExceptionNode.get() != this) {
                        forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNode.next;
                        continue;
                    }
                    break;
                }
            }
            finally {
                reentrantLock.unlock();
            }
            n2 = this.setCompletion(Integer.MIN_VALUE);
        }
        return n2;
    }

    private int setExceptionalCompletion(Throwable throwable) {
        int n2 = this.recordExceptionalCompletion(throwable);
        if ((n2 & 0xF0000000) == Integer.MIN_VALUE) {
            this.internalPropagateException(throwable);
        }
        return n2;
    }

    void internalPropagateException(Throwable throwable) {
    }

    static final void cancelIgnoringExceptions(ForkJoinTask<?> forkJoinTask) {
        if (forkJoinTask != null && forkJoinTask.status >= 0) {
            try {
                forkJoinTask.cancel(false);
                return;
            }
            catch (Throwable throwable) {}
        }
    }

    private void clearExceptionalCompletion() {
        int n2 = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        reentrantLock.lock();
        try {
            ForkJoinTask$ExceptionNode[] forkJoinTask$ExceptionNodeArray = exceptionTable;
            ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNodeArray[n2 &= forkJoinTask$ExceptionNodeArray.length - 1];
            ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode2 = null;
            while (forkJoinTask$ExceptionNode != null) {
                ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode3 = forkJoinTask$ExceptionNode.next;
                if (forkJoinTask$ExceptionNode.get() == this) {
                    if (forkJoinTask$ExceptionNode2 == null) {
                        forkJoinTask$ExceptionNodeArray[n2] = forkJoinTask$ExceptionNode3;
                        break;
                    }
                    forkJoinTask$ExceptionNode2.next = forkJoinTask$ExceptionNode3;
                    break;
                }
                forkJoinTask$ExceptionNode2 = forkJoinTask$ExceptionNode;
                forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNode3;
            }
            ForkJoinTask.expungeStaleExceptions();
            this.status = 0;
            return;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private Throwable getThrowableException() {
        ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode;
        Object object;
        if ((this.status & 0xF0000000) != Integer.MIN_VALUE) {
            return null;
        }
        int n2 = System.identityHashCode(this);
        ReentrantLock reentrantLock = exceptionTableLock;
        reentrantLock.lock();
        try {
            ForkJoinTask.expungeStaleExceptions();
            object = exceptionTable;
            forkJoinTask$ExceptionNode = exceptionTable[n2 & ((ForkJoinTask$ExceptionNode[])object).length - 1];
            while (forkJoinTask$ExceptionNode != null && forkJoinTask$ExceptionNode.get() != this) {
                forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNode.next;
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (forkJoinTask$ExceptionNode == null || (object = forkJoinTask$ExceptionNode.ex) == null) {
            return null;
        }
        return object;
    }

    private static void expungeStaleExceptions() {
        Reference<Object> reference;
        block0: while ((reference = exceptionTableRefQueue.poll()) != null) {
            if (!(reference instanceof ForkJoinTask$ExceptionNode)) continue;
            ForkJoinTask forkJoinTask = (ForkJoinTask)((ForkJoinTask$ExceptionNode)reference).get();
            ForkJoinTask$ExceptionNode[] forkJoinTask$ExceptionNodeArray = exceptionTable;
            int n2 = System.identityHashCode(forkJoinTask) & forkJoinTask$ExceptionNodeArray.length - 1;
            ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNodeArray[n2];
            ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode2 = null;
            while (forkJoinTask$ExceptionNode != null) {
                ForkJoinTask$ExceptionNode forkJoinTask$ExceptionNode3 = forkJoinTask$ExceptionNode.next;
                if (forkJoinTask$ExceptionNode == reference) {
                    if (forkJoinTask$ExceptionNode2 == null) {
                        forkJoinTask$ExceptionNodeArray[n2] = forkJoinTask$ExceptionNode3;
                        continue block0;
                    }
                    forkJoinTask$ExceptionNode2.next = forkJoinTask$ExceptionNode3;
                    continue block0;
                }
                forkJoinTask$ExceptionNode2 = forkJoinTask$ExceptionNode;
                forkJoinTask$ExceptionNode = forkJoinTask$ExceptionNode3;
            }
        }
    }

    static final void helpExpungeStaleExceptions() {
        ReentrantLock reentrantLock = exceptionTableLock;
        if (reentrantLock.tryLock()) {
            try {
                ForkJoinTask.expungeStaleExceptions();
                return;
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    static void rethrow(Throwable throwable) {
        if (throwable != null) {
            ForkJoinTask.uncheckedThrow(throwable);
        }
    }

    static <T extends Throwable> void uncheckedThrow(Throwable throwable) {
        throw throwable;
    }

    private void reportException(int n2) {
        if (n2 == -1073741824) {
            throw new CancellationException();
        }
        if (n2 == Integer.MIN_VALUE) {
            ForkJoinTask.rethrow(this.getThrowableException());
        }
    }

    public final ForkJoinTask<V> fork() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ((ForkJoinWorkerThread)thread).workQueue.push(this);
        } else {
            ForkJoinPool.common.externalPush(this);
        }
        return this;
    }

    public final V join() {
        int n2 = this.doJoin() & 0xF0000000;
        if (n2 != -268435456) {
            this.reportException(n2);
        }
        return this.getRawResult();
    }

    public final V invoke() {
        int n2 = this.doInvoke() & 0xF0000000;
        if (n2 != -268435456) {
            this.reportException(n2);
        }
        return this.getRawResult();
    }

    public static void invokeAll(ForkJoinTask<?> forkJoinTask, ForkJoinTask<?> forkJoinTask2) {
        int n2;
        forkJoinTask2.fork();
        int n3 = super.doInvoke() & 0xF0000000;
        if (n3 != -268435456) {
            super.reportException(n3);
        }
        if ((n2 = super.doJoin() & 0xF0000000) != -268435456) {
            super.reportException(n2);
        }
    }

    public static void invokeAll(ForkJoinTask<?> ... forkJoinTaskArray) {
        ForkJoinTask<?> forkJoinTask;
        int n2;
        int n3;
        Throwable throwable = null;
        for (n3 = n2 = forkJoinTaskArray.length - 1; n3 >= 0; --n3) {
            forkJoinTask = forkJoinTaskArray[n3];
            if (forkJoinTask == null) {
                if (throwable != null) continue;
                throwable = new NullPointerException();
                continue;
            }
            if (n3 != 0) {
                forkJoinTask.fork();
                continue;
            }
            if (super.doInvoke() >= -268435456 || throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        for (n3 = 1; n3 <= n2; ++n3) {
            forkJoinTask = forkJoinTaskArray[n3];
            if (forkJoinTask == null) continue;
            if (throwable != null) {
                forkJoinTask.cancel(false);
                continue;
            }
            if (super.doJoin() >= -268435456) continue;
            throwable = forkJoinTask.getException();
        }
        if (throwable != null) {
            ForkJoinTask.rethrow(throwable);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> collection) {
        ForkJoinTask forkJoinTask;
        int n2;
        int n3;
        if (!(collection instanceof RandomAccess) || !(collection instanceof List)) {
            Collection<ForkJoinTask> collection2 = collection;
            ForkJoinTask.invokeAll(collection2.toArray(new ForkJoinTask[collection2.size()]));
            return collection;
        }
        List list = (List)collection;
        Throwable throwable = null;
        for (n3 = n2 = list.size() - 1; n3 >= 0; --n3) {
            forkJoinTask = (ForkJoinTask)list.get(n3);
            if (forkJoinTask == null) {
                if (throwable != null) continue;
                throwable = new NullPointerException();
                continue;
            }
            if (n3 != 0) {
                forkJoinTask.fork();
                continue;
            }
            if (forkJoinTask.doInvoke() >= -268435456 || throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        for (n3 = 1; n3 <= n2; ++n3) {
            forkJoinTask = (ForkJoinTask)list.get(n3);
            if (forkJoinTask == null) continue;
            if (throwable != null) {
                forkJoinTask.cancel(false);
                continue;
            }
            if (forkJoinTask.doJoin() >= -268435456) continue;
            throwable = forkJoinTask.getException();
        }
        if (throwable != null) {
            ForkJoinTask.rethrow(throwable);
        }
        return collection;
    }

    @Override
    public boolean cancel(boolean bl) {
        return (this.setCompletion(-1073741824) & 0xF0000000) == -1073741824;
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0xF0000000) == -1073741824;
    }

    public final boolean isCompletedAbnormally() {
        return this.status < -268435456;
    }

    public final boolean isCompletedNormally() {
        return (this.status & 0xF0000000) == -268435456;
    }

    public final Throwable getException() {
        int n2 = this.status & 0xF0000000;
        if (n2 >= -268435456) {
            return null;
        }
        if (n2 == -1073741824) {
            return new CancellationException();
        }
        return this.getThrowableException();
    }

    public void completeExceptionally(Throwable throwable) {
        this.setExceptionalCompletion(throwable instanceof RuntimeException || throwable instanceof Error ? throwable : new RuntimeException(throwable));
    }

    public void complete(V v2) {
        try {
            this.setRawResult(v2);
        }
        catch (Throwable throwable) {
            this.setExceptionalCompletion(throwable);
            return;
        }
        this.setCompletion(-268435456);
    }

    public final void quietlyComplete() {
        this.setCompletion(-268435456);
    }

    @Override
    public final V get() {
        Throwable throwable;
        int n2 = Thread.currentThread() instanceof ForkJoinWorkerThread ? this.doJoin() : this.externalInterruptibleAwaitDone();
        if ((n2 = n2 & 0xF0000000) == -1073741824) {
            throw new CancellationException();
        }
        if (n2 == Integer.MIN_VALUE && (throwable = this.getThrowableException()) != null) {
            throw new ExecutionException(throwable);
        }
        return this.getRawResult();
    }

    @Override
    public final V get(long l2, TimeUnit object) {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long l3 = object.toNanos(l2);
        int n2 = this.status;
        if (n2 >= 0 && l3 > 0L) {
            long l4 = System.nanoTime() + l3;
            ForkJoinPool forkJoinPool = null;
            object = null;
            Object object2 = Thread.currentThread();
            if (object2 instanceof ForkJoinWorkerThread) {
                ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)object2;
                forkJoinPool = forkJoinWorkerThread.pool;
                object = forkJoinWorkerThread.workQueue;
                forkJoinPool.helpJoinOnce((ForkJoinPool$WorkQueue)object, this);
            } else {
                object2 = ForkJoinPool.common;
                if (object2 != null) {
                    if (this instanceof CountedCompleter) {
                        ((ForkJoinPool)object2).externalHelpComplete((CountedCompleter)this);
                    } else if (((ForkJoinPool)object2).tryExternalUnpush(this)) {
                        this.doExec();
                    }
                }
            }
            boolean bl = false;
            boolean bl2 = false;
            try {
                while ((n2 = this.status) >= 0) {
                    if (object != null && ((ForkJoinPool$WorkQueue)object).qlock < 0) {
                        ForkJoinTask.cancelIgnoringExceptions(this);
                        continue;
                    }
                    if (!bl) {
                        if (forkJoinPool != null) {
                            ForkJoinPool forkJoinPool2 = forkJoinPool;
                            if (!forkJoinPool2.tryCompensate(forkJoinPool2.ctl)) continue;
                        }
                        bl = true;
                        continue;
                    }
                    long l5 = TimeUnit.NANOSECONDS.toMillis(l3);
                    if (l5 > 0L) {
                        int n3 = n2;
                        if (U.compareAndSwapInt(this, STATUS, n3, n3 | 0x10000)) {
                            ForkJoinTask forkJoinTask = this;
                            synchronized (forkJoinTask) {
                                if (this.status >= 0) {
                                    try {
                                        this.wait(l5);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        if (forkJoinPool == null) {
                                            bl2 = true;
                                        }
                                    }
                                } else {
                                    this.notifyAll();
                                }
                            }
                        }
                    }
                    if ((n2 = this.status) >= 0 && !bl2 && (l3 = l4 - System.nanoTime()) > 0L) continue;
                    break;
                }
            }
            finally {
                if (forkJoinPool != null && bl) {
                    forkJoinPool.incrementActiveCount();
                }
            }
            if (bl2) {
                throw new InterruptedException();
            }
        }
        if ((n2 &= 0xF0000000) != -268435456) {
            if (n2 == -1073741824) {
                throw new CancellationException();
            }
            if (n2 != Integer.MIN_VALUE) {
                throw new TimeoutException();
            }
            Throwable throwable = this.getThrowableException();
            if (throwable != null) {
                throw new ExecutionException(throwable);
            }
        }
        return this.getRawResult();
    }

    public final void quietlyJoin() {
        this.doJoin();
    }

    public final void quietlyInvoke() {
        this.doInvoke();
    }

    public static void helpQuiesce() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            thread = (ForkJoinWorkerThread)thread;
            ((ForkJoinWorkerThread)thread).pool.helpQuiescePool(((ForkJoinWorkerThread)thread).workQueue);
            return;
        }
        ForkJoinPool.quiesceCommonPool();
    }

    public void reinitialize() {
        if ((this.status & 0xF0000000) == Integer.MIN_VALUE) {
            this.clearExceptionalCompletion();
            return;
        }
        this.status = 0;
    }

    public static ForkJoinPool getPool() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            return ((ForkJoinWorkerThread)thread).pool;
        }
        return null;
    }

    public static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            return ((ForkJoinWorkerThread)thread).workQueue.tryUnpush(this);
        }
        return ForkJoinPool.common.tryExternalUnpush(this);
    }

    public static int getQueuedTaskCount() {
        Object object = Thread.currentThread();
        object = object instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)object).workQueue : ForkJoinPool.commonSubmitterQueue();
        if (object == null) {
            return 0;
        }
        return ((ForkJoinPool$WorkQueue)object).queueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ForkJoinPool.getSurplusQueuedTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        Object object = Thread.currentThread();
        object = object instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)object).workQueue : ForkJoinPool.commonSubmitterQueue();
        if (object == null) {
            return null;
        }
        return ((ForkJoinPool$WorkQueue)object).peek();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            return ((ForkJoinWorkerThread)thread).workQueue.nextLocalTask();
        }
        return null;
    }

    protected static ForkJoinTask<?> pollTask() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            thread = (ForkJoinWorkerThread)thread;
            return ((ForkJoinWorkerThread)thread).pool.nextTaskFor(((ForkJoinWorkerThread)thread).workQueue);
        }
        return null;
    }

    public final short getForkJoinTaskTag() {
        return (short)this.status;
    }

    public final short setForkJoinTaskTag(short s2) {
        int n2;
        while (!U.compareAndSwapInt(this, STATUS, n2 = this.status, n2 & 0xFFFF0000 | s2 & 0xFFFF)) {
        }
        return (short)n2;
    }

    public final boolean compareAndSetForkJoinTaskTag(short s2, short s3) {
        int n2;
        do {
            int n3;
            if ((short)(n3 = this.status) != s2) {
                return false;
            }
            n2 = n3;
        } while (!U.compareAndSwapInt(this, STATUS, n2, n2 & 0xFFFF0000 | s3 & 0xFFFF));
        return true;
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        return new ForkJoinTask$AdaptedRunnableAction(runnable);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T t2) {
        return new ForkJoinTask$AdaptedRunnable<T>(runnable, t2);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        return new ForkJoinTask$AdaptedCallable<T>(callable);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream object) {
        ((ObjectInputStream)object).defaultReadObject();
        object = ((ObjectInputStream)object).readObject();
        if (object != null) {
            this.setExceptionalCompletion((Throwable)object);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new ForkJoinTask$1());
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
            }
        }
    }

    static /* synthetic */ ReferenceQueue access$000() {
        return exceptionTableRefQueue;
    }

    static {
        exceptionTableLock = new ReentrantLock();
        exceptionTableRefQueue = new ReferenceQueue();
        exceptionTable = new ForkJoinTask$ExceptionNode[32];
        try {
            U = ForkJoinTask.getUnsafe();
            Class<ForkJoinTask> clazz = ForkJoinTask.class;
            STATUS = U.objectFieldOffset(clazz.getDeclaredField("status"));
            return;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

