/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal.logging;

import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogLevel;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Serializable;

public abstract class AbstractInternalLogger
implements InternalLogger,
Serializable {
    private static final long serialVersionUID = -6382972526573193470L;
    private final String name;

    protected AbstractInternalLogger(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.name = string;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEnabled(InternalLogLevel internalLogLevel) {
        switch (internalLogLevel) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Throwable throwable) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, throwable);
                return;
            }
            case DEBUG: {
                this.debug(string, throwable);
                return;
            }
            case INFO: {
                this.info(string, throwable);
                return;
            }
            case WARN: {
                this.warn(string, throwable);
                return;
            }
            case ERROR: {
                this.error(string, throwable);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string);
                return;
            }
            case DEBUG: {
                this.debug(string);
                return;
            }
            case INFO: {
                this.info(string);
                return;
            }
            case WARN: {
                this.warn(string);
                return;
            }
            case ERROR: {
                this.error(string);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object object) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, object);
                return;
            }
            case DEBUG: {
                this.debug(string, object);
                return;
            }
            case INFO: {
                this.info(string, object);
                return;
            }
            case WARN: {
                this.warn(string, object);
                return;
            }
            case ERROR: {
                this.error(string, object);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object object, Object object2) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, object, object2);
                return;
            }
            case DEBUG: {
                this.debug(string, object, object2);
                return;
            }
            case INFO: {
                this.info(string, object, object2);
                return;
            }
            case WARN: {
                this.warn(string, object, object2);
                return;
            }
            case ERROR: {
                this.error(string, object, object2);
                return;
            }
        }
        throw new Error();
    }

    @Override
    public void log(InternalLogLevel internalLogLevel, String string, Object ... objectArray) {
        switch (internalLogLevel) {
            case TRACE: {
                this.trace(string, objectArray);
                return;
            }
            case DEBUG: {
                this.debug(string, objectArray);
                return;
            }
            case INFO: {
                this.info(string, objectArray);
                return;
            }
            case WARN: {
                this.warn(string, objectArray);
                return;
            }
            case ERROR: {
                this.error(string, objectArray);
                return;
            }
        }
        throw new Error();
    }

    protected Object readResolve() {
        return InternalLoggerFactory.getInstance(this.name());
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.name() + ')';
    }
}

