/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal.logging;

import com.aliyun.openservices.shade.io.netty.util.internal.logging.AbstractInternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.FormattingTuple;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.MessageFormatter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class Log4JLogger
extends AbstractInternalLogger {
    private static final long serialVersionUID = 2851357342488183058L;
    final transient Logger logger;
    static final String FQCN = Log4JLogger.class.getName();
    final boolean traceCapable;

    Log4JLogger(Logger logger) {
        super(logger.getName());
        this.logger = logger;
        this.traceCapable = this.isTraceCapable();
    }

    private boolean isTraceCapable() {
        try {
            this.logger.isTraceEnabled();
            return true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    @Override
    public boolean isTraceEnabled() {
        if (this.traceCapable) {
            return this.logger.isTraceEnabled();
        }
        return this.logger.isDebugEnabled();
    }

    @Override
    public void trace(String string) {
        this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)string, null);
    }

    @Override
    public void trace(String object, Object object2) {
        if (this.isTraceEnabled()) {
            object = MessageFormatter.format((String)object, object2);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void trace(String object, Object object2, Object object3) {
        if (this.isTraceEnabled()) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void trace(String object, Object ... objectArray) {
        if (this.isTraceEnabled()) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void trace(String string, Throwable throwable) {
        this.logger.log(FQCN, (Priority)(this.traceCapable ? Level.TRACE : Level.DEBUG), (Object)string, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String string) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)string, null);
    }

    @Override
    public void debug(String object, Object object2) {
        if (this.logger.isDebugEnabled()) {
            object = MessageFormatter.format((String)object, object2);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void debug(String object, Object object2, Object object3) {
        if (this.logger.isDebugEnabled()) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void debug(String object, Object ... objectArray) {
        if (this.logger.isDebugEnabled()) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void debug(String string, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)string, throwable);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String string) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)string, null);
    }

    @Override
    public void info(String object, Object object2) {
        if (this.logger.isInfoEnabled()) {
            object = MessageFormatter.format((String)object, object2);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void info(String object, Object object2, Object object3) {
        if (this.logger.isInfoEnabled()) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void info(String object, Object ... objectArray) {
        if (this.logger.isInfoEnabled()) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void info(String string, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)string, throwable);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String string) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)string, null);
    }

    @Override
    public void warn(String object, Object object2) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            object = MessageFormatter.format((String)object, object2);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void warn(String object, Object object2, Object object3) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void warn(String object, Object ... objectArray) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void warn(String string, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)string, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String string) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)string, null);
    }

    @Override
    public void error(String object, Object object2) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            object = MessageFormatter.format((String)object, object2);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void error(String object, Object object2, Object object3) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            object = MessageFormatter.format((String)object, object2, object3);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void error(String object, Object ... objectArray) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            object = MessageFormatter.arrayFormat((String)object, objectArray);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)((FormattingTuple)object).getMessage(), ((FormattingTuple)object).getThrowable());
        }
    }

    @Override
    public void error(String string, Throwable throwable) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)string, throwable);
    }
}

