/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal.logging;

import com.aliyun.openservices.shade.io.netty.util.internal.logging.FormattingTuple;
import java.util.HashMap;
import java.util.Map;

final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    static FormattingTuple format(String string, Object object) {
        return MessageFormatter.arrayFormat(string, new Object[]{object});
    }

    static FormattingTuple format(String string, Object object, Object object2) {
        return MessageFormatter.arrayFormat(string, new Object[]{object, object2});
    }

    static Throwable getThrowableCandidate(Object[] object) {
        if (object == null || ((Object[])object).length == 0) {
            return null;
        }
        if ((object = object[((Object[])object).length - 1]) instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    static FormattingTuple arrayFormat(String string, Object[] objectArray) {
        int n2;
        Throwable throwable = MessageFormatter.getThrowableCandidate(objectArray);
        if (string == null) {
            return new FormattingTuple(null, objectArray, throwable);
        }
        if (objectArray == null) {
            return new FormattingTuple(string);
        }
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            int n4 = string.indexOf(DELIM_STR, n3);
            if (n4 == -1) {
                if (n3 == 0) {
                    return new FormattingTuple(string, objectArray, throwable);
                }
                stringBuffer.append(string.substring(n3, string.length()));
                return new FormattingTuple(stringBuffer.toString(), objectArray, throwable);
            }
            if (MessageFormatter.isEscapedDelimeter(string, n4)) {
                if (!MessageFormatter.isDoubleEscaped(string, n4)) {
                    --n2;
                    stringBuffer.append(string.substring(n3, n4 - 1));
                    stringBuffer.append('{');
                    n3 = n4 + 1;
                    continue;
                }
                stringBuffer.append(string.substring(n3, n4 - 1));
                MessageFormatter.deeplyAppendParameter(stringBuffer, objectArray[n2], new HashMap<Object[], Void>());
                n3 = n4 + 2;
                continue;
            }
            stringBuffer.append(string.substring(n3, n4));
            MessageFormatter.deeplyAppendParameter(stringBuffer, objectArray[n2], new HashMap<Object[], Void>());
            n3 = n4 + 2;
        }
        stringBuffer.append(string.substring(n3, string.length()));
        if (n2 < objectArray.length - 1) {
            return new FormattingTuple(stringBuffer.toString(), objectArray, throwable);
        }
        return new FormattingTuple(stringBuffer.toString(), objectArray, null);
    }

    static boolean isEscapedDelimeter(String string, int n2) {
        if (n2 == 0) {
            return false;
        }
        return string.charAt(n2 - 1) == '\\';
    }

    static boolean isDoubleEscaped(String string, int n2) {
        return n2 >= 2 && string.charAt(n2 - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuffer stringBuffer, Object object, Map<Object[], Void> map) {
        if (object == null) {
            stringBuffer.append("null");
            return;
        }
        if (!object.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(stringBuffer, object);
            return;
        }
        if (object instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(stringBuffer, (boolean[])object);
            return;
        }
        if (object instanceof byte[]) {
            MessageFormatter.byteArrayAppend(stringBuffer, (byte[])object);
            return;
        }
        if (object instanceof char[]) {
            MessageFormatter.charArrayAppend(stringBuffer, (char[])object);
            return;
        }
        if (object instanceof short[]) {
            MessageFormatter.shortArrayAppend(stringBuffer, (short[])object);
            return;
        }
        if (object instanceof int[]) {
            MessageFormatter.intArrayAppend(stringBuffer, (int[])object);
            return;
        }
        if (object instanceof long[]) {
            MessageFormatter.longArrayAppend(stringBuffer, (long[])object);
            return;
        }
        if (object instanceof float[]) {
            MessageFormatter.floatArrayAppend(stringBuffer, (float[])object);
            return;
        }
        if (object instanceof double[]) {
            MessageFormatter.doubleArrayAppend(stringBuffer, (double[])object);
            return;
        }
        MessageFormatter.objectArrayAppend(stringBuffer, (Object[])object, map);
    }

    private static void safeObjectAppend(StringBuffer stringBuffer, Object object) {
        try {
            String string = object.toString();
            stringBuffer.append(string);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("SLF4J: Failed toString() invocation on an object of type [" + object.getClass().getName() + ']');
            throwable.printStackTrace();
            stringBuffer.append("[FAILED toString()]");
            return;
        }
    }

    private static void objectArrayAppend(StringBuffer stringBuffer, Object[] objectArray, Map<Object[], Void> map) {
        stringBuffer.append('[');
        if (!map.containsKey(objectArray)) {
            map.put(objectArray, null);
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MessageFormatter.deeplyAppendParameter(stringBuffer, objectArray[i2], map);
                if (i2 == n2 - 1) continue;
                stringBuffer.append(", ");
            }
            map.remove(objectArray);
        } else {
            stringBuffer.append("...");
        }
        stringBuffer.append(']');
    }

    private static void booleanArrayAppend(StringBuffer stringBuffer, boolean[] blArray) {
        stringBuffer.append('[');
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(blArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
    }

    private static void byteArrayAppend(StringBuffer stringBuffer, byte[] byArray) {
        stringBuffer.append('[');
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(byArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
    }

    private static void charArrayAppend(StringBuffer stringBuffer, char[] cArray) {
        stringBuffer.append('[');
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(cArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
    }

    private static void shortArrayAppend(StringBuffer stringBuffer, short[] sArray) {
        stringBuffer.append('[');
        int n2 = sArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(sArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
    }

    private static void intArrayAppend(StringBuffer stringBuffer, int[] nArray) {
        stringBuffer.append('[');
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(nArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
    }

    private static void longArrayAppend(StringBuffer stringBuffer, long[] lArray) {
        stringBuffer.append('[');
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(lArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
    }

    private static void floatArrayAppend(StringBuffer stringBuffer, float[] fArray) {
        stringBuffer.append('[');
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(fArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
    }

    private static void doubleArrayAppend(StringBuffer stringBuffer, double[] dArray) {
        stringBuffer.append('[');
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(dArray[i2]);
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
    }

    private MessageFormatter() {
    }
}

