/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues;

import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.CircularArrayOffsetCalculator;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$ExitCondition;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$WaitStrategy;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueue;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueueColdProducerFields;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueueConsumerFields;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueueProducerFields;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;
import java.lang.reflect.Field;
import java.util.Iterator;

public class MpscChunkedArrayQueue<E>
extends MpscChunkedArrayQueueConsumerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    long p0;
    long p1;
    long p2;
    long p3;
    long p4;
    long p5;
    long p6;
    long p7;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final long P_LIMIT_OFFSET;
    private static final Object JUMP;

    public MpscChunkedArrayQueue(int n2) {
        this(Math.max(2, Pow2.roundToPowerOfTwo(n2 / 8)), n2, false);
    }

    public MpscChunkedArrayQueue(int n2, int n3, boolean bl) {
        if (n2 < 2) {
            throw new IllegalArgumentException("Initial capacity must be 2 or more");
        }
        if (n3 < 4) {
            throw new IllegalArgumentException("Max capacity must be 4 or more");
        }
        if (Pow2.roundToPowerOfTwo(n2) >= Pow2.roundToPowerOfTwo(n3)) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity(both rounded up to a power of 2)");
        }
        n2 = Pow2.roundToPowerOfTwo(n2);
        long l2 = n2 - 1 << 1;
        E[] EArray = CircularArrayOffsetCalculator.allocate(n2 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l2;
        this.consumerBuffer = EArray;
        this.consumerMask = l2;
        this.maxQueueCapacity = (long)Pow2.roundToPowerOfTwo(n3) << 1;
        this.isFixedChunkSize = bl;
        this.soProducerLimit(l2);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e2) {
        E[] EArray;
        long l2;
        long l3;
        long l4;
        if (e2 == null) {
            throw new NullPointerException();
        }
        block6: while (true) {
            l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            EArray = this.producerBuffer;
            if (l4 <= l3) {
                int n2 = this.offerSlowPath(l2, EArray, l3, l4);
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l2, EArray, l3, this.consumerIndex, this.maxQueueCapacity, e2);
                        return true;
                    }
                }
            }
            long l5 = l3;
            if (this.casProducerIndex(l5, l5 + 2L)) break;
        }
        l4 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l3, l2);
        UnsafeRefArrayAccess.soElement(EArray, l4, e2);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int offerSlowPath(long l2, E[] EArray, long l3, long l4) {
        long l5 = this.lvConsumerIndex();
        long l6 = this.maxQueueCapacity;
        long l7 = this.getCurrentBufferCapacity(l2, l6);
        int n2 = 0;
        if (l5 + l7 <= l3) {
            if (l5 == l3 - l6) {
                return 2;
            }
            long l8 = l3;
            if (!this.casProducerIndex(l8, l8 + 1L)) return 1;
            return 3;
        }
        if (this.casProducerLimit(l4, l5 + l7)) return n2;
        return 1;
    }

    private static long modifiedCalcElementOffset(long l2, long l3) {
        return UnsafeRefArrayAccess.REF_ARRAY_BASE + ((l2 & l3) << UnsafeRefArrayAccess.REF_ELEMENT_SHIFT - 1);
    }

    @Override
    public E poll() {
        E[] EArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l2, l3);
        Object e2 = UnsafeRefArrayAccess.lvElement(EArray, l4);
        if (e2 == null) {
            if (l2 != this.lvProducerIndex()) {
                while ((e2 = UnsafeRefArrayAccess.lvElement(EArray, l4)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e2 == JUMP) {
            EArray = this.getNextBuffer(EArray, l3);
            return this.newBufferPoll(EArray, l2);
        }
        UnsafeRefArrayAccess.soElement(EArray, l4, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    @Override
    public E peek() {
        E[] EArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l2, l3);
        Object e2 = UnsafeRefArrayAccess.lvElement(EArray, l4);
        if (e2 == null && l2 != this.lvProducerIndex()) {
            while ((e2 = UnsafeRefArrayAccess.lvElement(EArray, l4)) == null) {
            }
        }
        if (e2 == JUMP) {
            MpscChunkedArrayQueue mpscChunkedArrayQueue = this;
            return mpscChunkedArrayQueue.newBufferPeek(mpscChunkedArrayQueue.getNextBuffer(EArray, l3), l2);
        }
        return e2;
    }

    private E[] getNextBuffer(E[] EArray, long l2) {
        long l3 = this.nextArrayOffset(l2);
        Object[] objectArray = (Object[])UnsafeRefArrayAccess.lvElement(EArray, l3);
        UnsafeRefArrayAccess.soElement(EArray, l3, null);
        return objectArray;
    }

    private long nextArrayOffset(long l2) {
        return MpscChunkedArrayQueue.modifiedCalcElementOffset(l2 + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] EArray, long l2) {
        long l3 = this.newBufferAndOffset(EArray, l2);
        E e2 = UnsafeRefArrayAccess.lvElement(EArray, l3);
        if (e2 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soElement(EArray, l3, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    private E newBufferPeek(E[] object, long l2) {
        long l3 = this.newBufferAndOffset((E[])object, l2);
        if ((object = UnsafeRefArrayAccess.lvElement(object, l3)) == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return (E)object;
    }

    private long newBufferAndOffset(E[] EArray, long l2) {
        this.consumerBuffer = EArray;
        this.consumerMask = EArray.length - 2 << 1;
        long l3 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l2, this.consumerMask);
        return l3;
    }

    @Override
    public final int size() {
        long l2;
        long l3;
        long l4 = this.lvConsumerIndex();
        do {
            l3 = l4;
            l2 = this.lvProducerIndex();
        } while (l3 != (l4 = this.lvConsumerIndex()));
        return (int)(l2 - l4) >> 1;
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, l2);
    }

    private boolean casProducerIndex(long l2, long l3) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_INDEX_OFFSET, l2, l3);
    }

    private void soConsumerIndex(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, l2);
    }

    private long lvProducerLimit() {
        return this.producerLimit;
    }

    private boolean casProducerLimit(long l2, long l3) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_LIMIT_OFFSET, l2, l3);
    }

    private void soProducerLimit(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_LIMIT_OFFSET, l2);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    @Override
    public int capacity() {
        return (int)(this.maxQueueCapacity / 2L);
    }

    @Override
    public boolean relaxedOffer(E e2) {
        return this.offer(e2);
    }

    @Override
    public E relaxedPoll() {
        E[] EArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l2, l3);
        Object e2 = UnsafeRefArrayAccess.lvElement(EArray, l4);
        if (e2 == null) {
            return null;
        }
        if (e2 == JUMP) {
            EArray = this.getNextBuffer(EArray, l3);
            return this.newBufferPoll(EArray, l2);
        }
        UnsafeRefArrayAccess.soElement(EArray, l4, null);
        this.soConsumerIndex(l2 + 2L);
        return e2;
    }

    @Override
    public E relaxedPeek() {
        E[] EArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l3 = this.consumerMask;
        long l4 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l2, l3);
        Object e2 = UnsafeRefArrayAccess.lvElement(EArray, l4);
        if (e2 == JUMP) {
            MpscChunkedArrayQueue mpscChunkedArrayQueue = this;
            return mpscChunkedArrayQueue.newBufferPeek(mpscChunkedArrayQueue.getNextBuffer(EArray, l3), l2);
        }
        return e2;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n2) {
        long l2;
        E[] EArray;
        long l3;
        long l4;
        block5: while (true) {
            long l5 = this.lvProducerLimit();
            l4 = this.lvProducerIndex();
            if ((l4 & 1L) == 1L) continue;
            l3 = this.producerMask;
            EArray = this.producerBuffer;
            l2 = Math.min(l5, l4 + (long)(2 * n2));
            if (l4 == l5 || l5 < l2) {
                int n3 = this.offerSlowPath(l3, EArray, l4, l5);
                switch (n3) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l3, EArray, l4, this.consumerIndex, this.maxQueueCapacity, messagePassingQueue$Supplier.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l4, l2)) break;
        }
        n2 = (int)((l2 - l4) / 2L);
        for (int i2 = 0; i2 < n2; ++i2) {
            long l6 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l4 + (long)(2 * i2), l3);
            UnsafeRefArrayAccess.soElement(EArray, l6, messagePassingQueue$Supplier.get());
        }
        return n2;
    }

    private void resize(long l2, E[] EArray, long l3, long l4, long l5, E e2) {
        int n2 = this.getNextBufferCapacity(EArray, l5);
        E[] EArray2 = CircularArrayOffsetCalculator.allocate(n2);
        this.producerBuffer = EArray2;
        this.producerMask = n2 - 2 << 1;
        long l6 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l3, l2);
        long l7 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l3, this.producerMask);
        UnsafeRefArrayAccess.soElement(EArray2, l7, e2);
        UnsafeRefArrayAccess.soElement(EArray, this.nextArrayOffset(l2), EArray2);
        long l8 = l5 - (l3 - l4);
        if (l8 <= 0L) {
            throw new IllegalStateException();
        }
        this.soProducerLimit(l3 + Math.min(l2, l8));
        UnsafeRefArrayAccess.soElement(EArray, l6, JUMP);
        this.soProducerIndex(l3 + 2L);
    }

    private int getNextBufferCapacity(E[] EArray, long l2) {
        int n2;
        int cfr_ignored_0 = EArray.length;
        if (this.isFixedChunkSize) {
            n2 = EArray.length;
        } else {
            if ((long)(EArray.length - 1) == l2) {
                throw new IllegalStateException();
            }
            n2 = 2 * EArray.length - 1;
        }
        return n2;
    }

    protected long getCurrentBufferCapacity(long l2, long l3) {
        if (!this.isFixedChunkSize && l2 + 2L == l3) {
            return l3;
        }
        return l2;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        int n2;
        long l2 = 0L;
        int n3 = this.capacity();
        do {
            if ((n2 = this.fill(messagePassingQueue$Supplier, MpmcArrayQueue.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l2;
        } while ((l2 += (long)n2) <= (long)n3);
        return (int)l2;
    }

    @Override
    public void fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            while (this.fill(messagePassingQueue$Supplier, MpmcArrayQueue.RECOMENDED_OFFER_BATCH) != 0) {
            }
            int n2 = 0;
            while (this.fill(messagePassingQueue$Supplier, MpmcArrayQueue.RECOMENDED_OFFER_BATCH) == 0 && messagePassingQueue$ExitCondition.keepRunning()) {
                n2 = messagePassingQueue$WaitStrategy.idle(n2);
            }
        }
    }

    @Override
    public void drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        int n2 = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            E e2 = this.relaxedPoll();
            if (e2 == null) {
                n2 = messagePassingQueue$WaitStrategy.idle(n2);
                continue;
            }
            n2 = 0;
            messagePassingQueue$Consumer.accept(e2);
        }
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        return this.drain(messagePassingQueue$Consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n2) {
        E e2;
        int n3;
        for (n3 = 0; n3 < n2 && (e2 = this.relaxedPoll()) != null; ++n3) {
            messagePassingQueue$Consumer.accept(e2);
        }
        return n3;
    }

    static {
        Field field;
        try {
            field = MpscChunkedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        try {
            field = MpscChunkedArrayQueueConsumerFields.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        try {
            field = MpscChunkedArrayQueueColdProducerFields.class.getDeclaredField("producerLimit");
            P_LIMIT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        JUMP = new Object();
    }
}

