/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.internal.shaded.org.jctools.util;

public final class Pow2 {
    public static final int MAX_POW2 = 0x40000000;

    private Pow2() {
    }

    public static int roundToPowerOfTwo(int n2) {
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("There is no larger power of 2 int for value:" + n2 + " since it exceeds 2^31.");
        }
        n2 = 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
        return n2;
    }

    public static boolean isPowerOfTwo(int n2) {
        int n3 = n2;
        return (n3 & n3 - 1) == 0;
    }

    public static long align(long l2, int n2) {
        if (!Pow2.isPowerOfTwo(n2)) {
            throw new IllegalArgumentException("alignment must be a power of 2:" + n2);
        }
        return l2 + (long)(n2 - 1) & (long)(~(n2 - 1));
    }
}

