/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.codec.binary;

import com.aliyun.openservices.shade.org.apache.commons.codec.BinaryDecoder;
import com.aliyun.openservices.shade.org.apache.commons.codec.BinaryEncoder;
import com.aliyun.openservices.shade.org.apache.commons.codec.Charsets;
import com.aliyun.openservices.shade.org.apache.commons.codec.DecoderException;
import com.aliyun.openservices.shade.org.apache.commons.codec.EncoderException;
import java.nio.charset.Charset;

public class Hex
implements BinaryDecoder,
BinaryEncoder {
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Charset charset;

    public static byte[] decodeHex(char[] cArray) {
        int n2 = cArray.length;
        if ((n2 & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        byte[] byArray = new byte[n2 >> 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = Hex.toDigit(cArray[n4], n4) << 4;
            n5 |= Hex.toDigit(cArray[++n4], n4);
            ++n4;
            byArray[n3] = (byte)n5;
            ++n3;
        }
        return byArray;
    }

    public static char[] encodeHex(byte[] byArray) {
        return Hex.encodeHex(byArray, true);
    }

    public static char[] encodeHex(byte[] byArray, boolean bl) {
        return Hex.encodeHex(byArray, bl ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        char[] cArray2 = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray2[n3++] = cArray[(0xF0 & byArray[i2]) >>> 4];
            cArray2[n3++] = cArray[0xF & byArray[i2]];
        }
        return cArray2;
    }

    public static String encodeHexString(byte[] byArray) {
        return new String(Hex.encodeHex(byArray));
    }

    protected static int toDigit(char c2, int n2) {
        int n3 = Character.digit(c2, 16);
        if (n3 == -1) {
            throw new DecoderException("Illegal hexadecimal character " + c2 + " at index " + n2);
        }
        return n3;
    }

    public Hex() {
        this.charset = DEFAULT_CHARSET;
    }

    public Hex(Charset charset) {
        this.charset = charset;
    }

    public Hex(String string) {
        this(Charset.forName(string));
    }

    @Override
    public byte[] decode(byte[] byArray) {
        return Hex.decodeHex(new String(byArray, this.getCharset()).toCharArray());
    }

    @Override
    public Object decode(Object object) {
        try {
            char[] cArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            object = cArray;
            return Hex.decodeHex(cArray);
        }
        catch (ClassCastException classCastException) {
            throw new DecoderException(classCastException.getMessage(), classCastException);
        }
    }

    @Override
    public byte[] encode(byte[] byArray) {
        return Hex.encodeHexString(byArray).getBytes(this.getCharset());
    }

    @Override
    public Object encode(Object object) {
        try {
            byte[] byArray = object instanceof String ? ((String)object).getBytes(this.getCharset()) : (byte[])object;
            object = byArray;
            return Hex.encodeHex(byArray);
        }
        catch (ClassCastException classCastException) {
            throw new EncoderException(classCastException.getMessage(), classCastException);
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset.name();
    }

    public String toString() {
        return super.toString() + "[charsetName=" + this.charset + "]";
    }
}

