/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.codec.language;

import com.aliyun.openservices.shade.org.apache.commons.codec.EncoderException;
import com.aliyun.openservices.shade.org.apache.commons.codec.StringEncoder;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.SoundexUtils;

public class Soundex
implements StringEncoder {
    public static final String US_ENGLISH_MAPPING_STRING = "01230120022455012623010202";
    private static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    public static final Soundex US_ENGLISH = new Soundex();
    @Deprecated
    private int maxLength = 4;
    private final char[] soundexMapping;

    public Soundex() {
        this.soundexMapping = US_ENGLISH_MAPPING;
    }

    public Soundex(char[] cArray) {
        this.soundexMapping = new char[cArray.length];
        System.arraycopy(cArray, 0, this.soundexMapping, 0, cArray.length);
    }

    public Soundex(String string) {
        this.soundexMapping = string.toCharArray();
    }

    public int difference(String string, String string2) {
        return SoundexUtils.difference(this, string, string2);
    }

    @Override
    public Object encode(Object object) {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        return this.soundex((String)object);
    }

    @Override
    public String encode(String string) {
        return this.soundex(string);
    }

    private char getMappingCode(String string, int n2) {
        char c2;
        char c3 = this.map(string.charAt(n2));
        if (n2 > 1 && c3 != '0' && ('H' == (c2 = string.charAt(n2 - 1)) || 'W' == c2)) {
            char c4 = string.charAt(n2 - 2);
            char c5 = this.map(c4);
            n2 = c5;
            if (c5 == c3 || 'H' == c4 || 'W' == c4) {
                return '\u0000';
            }
        }
        return c3;
    }

    @Deprecated
    public int getMaxLength() {
        return this.maxLength;
    }

    private char[] getSoundexMapping() {
        return this.soundexMapping;
    }

    private char map(char c2) {
        int n2 = c2 - 65;
        if (n2 < 0 || n2 >= this.getSoundexMapping().length) {
            throw new IllegalArgumentException("The character is not mapped: " + c2);
        }
        return this.getSoundexMapping()[n2];
    }

    @Deprecated
    public void setMaxLength(int n2) {
        this.maxLength = n2;
    }

    public String soundex(String string) {
        if (string == null) {
            return null;
        }
        if ((string = SoundexUtils.clean(string)).length() == 0) {
            return string;
        }
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 1;
        int n3 = 1;
        cArray[0] = string.charAt(0);
        char c2 = this.getMappingCode(string, 0);
        while (n2 < string.length() && n3 < cArray.length) {
            char c3;
            if ((c3 = this.getMappingCode(string, n2++)) == '\u0000') continue;
            if (c3 != '0' && c3 != c2) {
                cArray[n3++] = c3;
            }
            c2 = c3;
        }
        return new String(cArray);
    }
}

