/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.codec.language.bm;

import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Lang$LangRule;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Languages;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Languages$LanguageSet;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.NameType;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;

public class Lang {
    private static final Map<NameType, Lang> Langs = new EnumMap<NameType, Lang>(NameType.class);
    private static final String LANGUAGE_RULES_RN = "com/aliyun/openservices/shade/org/apache/commons/codec/language/bm/lang.txt";
    private final Languages languages;
    private final List<Lang$LangRule> rules;

    public static Lang instance(NameType nameType) {
        return Langs.get((Object)nameType);
    }

    public static Lang loadFromResource(String string, Languages languages) {
        ArrayList<Lang$LangRule> arrayList = new ArrayList<Lang$LangRule>();
        Closeable closeable = Lang.class.getClassLoader().getResourceAsStream(string);
        if (closeable == null) {
            throw new IllegalStateException("Unable to resolve required resource:org/apache/commons/codec/language/bm/lang.txt");
        }
        closeable = new Scanner((InputStream)closeable, "UTF-8");
        try {
            boolean bl = false;
            while (((Scanner)closeable).hasNextLine()) {
                Object object;
                String[] stringArray = object = ((Scanner)closeable).nextLine();
                if (bl) {
                    if (!stringArray.endsWith("*/")) continue;
                    bl = false;
                    continue;
                }
                if (stringArray.startsWith("/*")) {
                    bl = true;
                    continue;
                }
                int n2 = stringArray.indexOf("//");
                if (n2 >= 0) {
                    stringArray = stringArray.substring(0, n2);
                }
                if ((stringArray = stringArray.trim()).length() == 0) continue;
                if ((stringArray = stringArray.split("\\s+")).length != 3) {
                    throw new IllegalArgumentException("Malformed line '" + (String)object + "' in language resource '" + string + "'");
                }
                object = Pattern.compile(stringArray[0]);
                String[] stringArray2 = stringArray[1].split("\\+");
                boolean bl2 = stringArray[2].equals("true");
                arrayList.add(new Lang$LangRule((Pattern)object, new HashSet<String>(Arrays.asList(stringArray2)), bl2, null));
            }
        }
        finally {
            ((Scanner)closeable).close();
        }
        return new Lang(arrayList, languages);
    }

    private Lang(List<Lang$LangRule> list, Languages languages) {
        this.rules = Collections.unmodifiableList(list);
        this.languages = languages;
    }

    public String guessLanguage(String object) {
        if (((Languages$LanguageSet)(object = this.guessLanguages((String)object))).isSingleton()) {
            return ((Languages$LanguageSet)object).getAny();
        }
        return "any";
    }

    public Languages$LanguageSet guessLanguages(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        HashSet<String> hashSet = new HashSet<String>(this.languages.getLanguages());
        for (Lang$LangRule lang$LangRule : this.rules) {
            if (!lang$LangRule.matches(string)) continue;
            if (Lang$LangRule.access$100(lang$LangRule)) {
                hashSet.retainAll(Lang$LangRule.access$200(lang$LangRule));
                continue;
            }
            hashSet.removeAll(Lang$LangRule.access$200(lang$LangRule));
        }
        Languages$LanguageSet languages$LanguageSet = Languages$LanguageSet.from(hashSet);
        if (languages$LanguageSet.equals(Languages.NO_LANGUAGES)) {
            return Languages.ANY_LANGUAGE;
        }
        return languages$LanguageSet;
    }

    static {
        for (NameType nameType : NameType.values()) {
            Langs.put(nameType, Lang.loadFromResource(LANGUAGE_RULES_RN, Languages.getInstance(nameType)));
        }
    }
}

