/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.codec.language.bm;

import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Lang;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Languages$LanguageSet;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.NameType;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.PhoneticEngine$PhonemeBuilder;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.PhoneticEngine$RulesApplication;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$Phoneme;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.RuleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PhoneticEngine {
    private static final Map<NameType, Set<String>> NAME_PREFIXES = new EnumMap<NameType, Set<String>>(NameType.class);
    private static final int DEFAULT_MAX_PHONEMES = 20;
    private final Lang lang;
    private final NameType nameType;
    private final RuleType ruleType;
    private final boolean concat;
    private final int maxPhonemes;

    private static String join(Iterable<String> object, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((object = object.iterator()).hasNext()) {
            stringBuilder.append((String)object.next());
        }
        while (object.hasNext()) {
            stringBuilder.append(string).append((String)object.next());
        }
        return stringBuilder.toString();
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl) {
        this(nameType, ruleType, bl, 20);
    }

    public PhoneticEngine(NameType nameType, RuleType ruleType, boolean bl, int n2) {
        if (ruleType == RuleType.RULES) {
            throw new IllegalArgumentException("ruleType must not be " + (Object)((Object)RuleType.RULES));
        }
        this.nameType = nameType;
        this.ruleType = ruleType;
        this.concat = bl;
        this.lang = Lang.instance(nameType);
        this.maxPhonemes = n2;
    }

    private PhoneticEngine$PhonemeBuilder applyFinalRules(PhoneticEngine$PhonemeBuilder object, Map<String, List<Rule>> map) {
        if (map == null) {
            throw new NullPointerException("finalRules can not be null");
        }
        if (map.isEmpty()) {
            return object;
        }
        TreeSet<Rule$Phoneme> treeSet = new TreeSet<Rule$Phoneme>(Rule$Phoneme.COMPARATOR);
        for (Rule$Phoneme rule$Phoneme : ((PhoneticEngine$PhonemeBuilder)((Object)object)).getPhonemes()) {
            PhoneticEngine$PhonemeBuilder phoneticEngine$PhonemeBuilder = PhoneticEngine$PhonemeBuilder.empty(rule$Phoneme.getLanguages());
            String object2 = rule$Phoneme.getPhonemeText().toString();
            int n2 = 0;
            while (n2 < object2.length()) {
                PhoneticEngine$RulesApplication phoneticEngine$RulesApplication = new PhoneticEngine$RulesApplication(map, object2, phoneticEngine$PhonemeBuilder, n2, this.maxPhonemes).invoke();
                boolean bl = phoneticEngine$RulesApplication.isFound();
                phoneticEngine$PhonemeBuilder = phoneticEngine$RulesApplication.getPhonemeBuilder();
                if (!bl) {
                    int n3 = n2;
                    phoneticEngine$PhonemeBuilder.append(object2.subSequence(n3, n3 + 1));
                }
                n2 = phoneticEngine$RulesApplication.getI();
            }
            treeSet.addAll(phoneticEngine$PhonemeBuilder.getPhonemes());
        }
        return new PhoneticEngine$PhonemeBuilder(treeSet, null);
    }

    public String encode(String string) {
        Languages$LanguageSet languages$LanguageSet = this.lang.guessLanguages(string);
        return this.encode(string, languages$LanguageSet);
    }

    public String encode(String string, Languages$LanguageSet languages$LanguageSet) {
        Object object3;
        Object object2;
        Map<String, List<Rule>> map = Rule.getInstanceMap(this.nameType, RuleType.RULES, languages$LanguageSet);
        Map<String, List<Rule>> map2 = Rule.getInstanceMap(this.nameType, this.ruleType, "common");
        Map<String, List<Rule>> map3 = Rule.getInstanceMap(this.nameType, this.ruleType, languages$LanguageSet);
        string = string.toLowerCase(Locale.ENGLISH).replace('-', ' ').trim();
        if (this.nameType == NameType.GENERIC) {
            if (string.length() >= 2 && string.substring(0, 2).equals("d'")) {
                String string2 = string.substring(2);
                String string3 = "d" + string2;
                return "(" + this.encode(string2) + ")-(" + this.encode(string3) + ")";
            }
            for (String object42 : NAME_PREFIXES.get((Object)this.nameType)) {
                if (!string.startsWith(object42 + " ")) continue;
                String object3 = string.substring(object42.length() + 1);
                String object22 = object42 + object3;
                return "(" + this.encode(object3) + ")-(" + this.encode(object22) + ")";
            }
        }
        List<String> list = Arrays.asList(string.split("\\s+"));
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (this.nameType) {
            case SEPHARDIC: {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    String n2 = (String)object2.next();
                    object3 = n2.split("'");
                    string = object3[((String[])object3).length - 1];
                    arrayList.add(string);
                }
                arrayList.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case ASHKENAZI: {
                arrayList.addAll(list);
                arrayList.removeAll((Collection)NAME_PREFIXES.get((Object)this.nameType));
                break;
            }
            case GENERIC: {
                arrayList.addAll(list);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable case: " + (Object)((Object)this.nameType));
            }
        }
        if (this.concat) {
            string = PhoneticEngine.join(arrayList, " ");
        } else if (arrayList.size() == 1) {
            string = (String)list.iterator().next();
        } else {
            object2 = new StringBuilder();
            for (Object object3 : arrayList) {
                ((StringBuilder)object2).append("-").append(this.encode((String)object3));
            }
            return ((StringBuilder)object2).substring(1);
        }
        object2 = PhoneticEngine$PhonemeBuilder.empty(languages$LanguageSet);
        int n2 = 0;
        while (n2 < string.length()) {
            object3 = new PhoneticEngine$RulesApplication(map, string, (PhoneticEngine$PhonemeBuilder)object2, n2, this.maxPhonemes).invoke();
            n2 = ((PhoneticEngine$RulesApplication)object3).getI();
            object2 = ((PhoneticEngine$RulesApplication)object3).getPhonemeBuilder();
        }
        object2 = this.applyFinalRules((PhoneticEngine$PhonemeBuilder)object2, map2);
        object2 = this.applyFinalRules((PhoneticEngine$PhonemeBuilder)object2, map3);
        return ((PhoneticEngine$PhonemeBuilder)object2).makeString();
    }

    public Lang getLang() {
        return this.lang;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public boolean isConcat() {
        return this.concat;
    }

    public int getMaxPhonemes() {
        return this.maxPhonemes;
    }

    static {
        NAME_PREFIXES.put(NameType.ASHKENAZI, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bar", "ben", "da", "de", "van", "von"))));
        NAME_PREFIXES.put(NameType.SEPHARDIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("al", "el", "da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
        NAME_PREFIXES.put(NameType.GENERIC, Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("da", "dal", "de", "del", "dela", "de la", "della", "des", "di", "do", "dos", "du", "van", "von"))));
    }
}

