/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.codec.language.bm;

import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Languages;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Languages$LanguageSet;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.NameType;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$1;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$10;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$2;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$3;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$4;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$5;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$6;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$7;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$8;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$9;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$Phoneme;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$PhonemeExpr;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$PhonemeList;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.Rule$RPattern;
import com.aliyun.openservices.shade.org.apache.commons.codec.language.bm.RuleType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class Rule {
    public static final Rule$RPattern ALL_STRINGS_RMATCHER = new Rule$1();
    public static final String ALL = "ALL";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String HASH_INCLUDE = "#include";
    private static final Map<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>> RULES = new EnumMap<NameType, Map<RuleType, Map<String, Map<String, List<Rule>>>>>(NameType.class);
    private final Rule$RPattern lContext;
    private final String pattern;
    private final Rule$PhonemeExpr phoneme;
    private final Rule$RPattern rContext;

    private static boolean contains(CharSequence charSequence, char c2) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) != c2) continue;
            return true;
        }
        return false;
    }

    private static String createResourceName(NameType nameType, RuleType ruleType, String string) {
        return String.format("com/aliyun/openservices/shade/org/apache/commons/codec/language/bm/%s_%s_%s.txt", nameType.getName(), ruleType.getName(), string);
    }

    private static Scanner createScanner(NameType object, RuleType object2, String string) {
        object = Rule.createResourceName(object, object2, string);
        object2 = Languages.class.getClassLoader().getResourceAsStream((String)object);
        if (object2 == null) {
            throw new IllegalArgumentException("Unable to load resource: " + (String)object);
        }
        return new Scanner((InputStream)object2, "UTF-8");
    }

    private static Scanner createScanner(String string) {
        string = String.format("com/aliyun/openservices/shade/org/apache/commons/codec/language/bm/%s.txt", string);
        InputStream inputStream = Languages.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to load resource: " + string);
        }
        return new Scanner(inputStream, "UTF-8");
    }

    private static boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        int n2 = charSequence.length() - 1;
        for (int i2 = charSequence2.length() - 1; i2 >= 0; --i2) {
            if (charSequence.charAt(n2) != charSequence2.charAt(i2)) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static List<Rule> getInstance(NameType object, RuleType object2, Languages$LanguageSet object32) {
        object = Rule.getInstanceMap((NameType)((Object)object), (RuleType)((Object)object2), (Languages$LanguageSet)object32);
        object2 = new ArrayList();
        for (Object object32 : object.values()) {
            object2.addAll(object32);
        }
        return object2;
    }

    public static List<Rule> getInstance(NameType nameType, RuleType ruleType, String string) {
        return Rule.getInstance(nameType, ruleType, Languages$LanguageSet.from(new HashSet<String>(Arrays.asList(string))));
    }

    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType ruleType, Languages$LanguageSet languages$LanguageSet) {
        if (languages$LanguageSet.isSingleton()) {
            return Rule.getInstanceMap(nameType, ruleType, languages$LanguageSet.getAny());
        }
        return Rule.getInstanceMap(nameType, ruleType, "any");
    }

    public static Map<String, List<Rule>> getInstanceMap(NameType nameType, RuleType ruleType, String string) {
        Map<String, List<Rule>> map = RULES.get((Object)nameType).get((Object)ruleType).get(string);
        if (map == null) {
            throw new IllegalArgumentException(String.format("No rules found for %s, %s, %s.", nameType.getName(), ruleType.getName(), string));
        }
        return map;
    }

    private static Rule$Phoneme parsePhoneme(String object) {
        int n2 = ((String)object).indexOf("[");
        if (n2 >= 0) {
            if (!((String)object).endsWith("]")) {
                throw new IllegalArgumentException("Phoneme expression contains a '[' but does not end in ']'");
            }
            String string = ((String)object).substring(0, n2);
            object = ((String)object).substring(n2 + 1, ((String)object).length() - 1);
            object = new HashSet<String>(Arrays.asList(((String)object).split("[+]")));
            return new Rule$Phoneme(string, Languages$LanguageSet.from((Set<String>)object));
        }
        return new Rule$Phoneme((CharSequence)object, Languages.ANY_LANGUAGE);
    }

    private static Rule$PhonemeExpr parsePhonemeExpr(String string) {
        if (string.startsWith("(")) {
            if (!string.endsWith(")")) {
                throw new IllegalArgumentException("Phoneme starts with '(' so must end with ')'");
            }
            ArrayList<Rule$Phoneme> arrayList = new ArrayList<Rule$Phoneme>();
            string = string.substring(1, string.length() - 1);
            for (String string2 : string.split("[|]")) {
                arrayList.add(Rule.parsePhoneme(string2));
            }
            if (string.startsWith("|") || string.endsWith("|")) {
                arrayList.add(new Rule$Phoneme("", Languages.ANY_LANGUAGE));
            }
            return new Rule$PhonemeList(arrayList);
        }
        return Rule.parsePhoneme(string);
    }

    private static Map<String, List<Rule>> parseRules(Scanner scanner, String string) {
        HashMap<String, List<Rule>> hashMap = new HashMap<String, List<Rule>>();
        int n2 = 0;
        boolean bl = false;
        while (scanner.hasNextLine()) {
            Object object;
            ++n2;
            Object object2 = object = scanner.nextLine();
            if (bl) {
                if (!object2.endsWith("*/")) continue;
                bl = false;
                continue;
            }
            if (object2.startsWith("/*")) {
                bl = true;
                continue;
            }
            int n3 = object2.indexOf("//");
            if (n3 >= 0) {
                object2 = object2.substring(0, n3);
            }
            if ((object2 = object2.trim()).length() == 0) continue;
            if (object2.startsWith(HASH_INCLUDE)) {
                if ((object2 = object2.substring(8).trim()).contains(" ")) {
                    throw new IllegalArgumentException("Malformed import statement '" + (String)object + "' in " + string);
                }
                hashMap.putAll(Rule.parseRules(Rule.createScanner((String)object2), string + "->" + (String)object2));
                continue;
            }
            if (((String[])(object2 = object2.split("\\s+"))).length != 4) {
                throw new IllegalArgumentException("Malformed rule statement split into " + ((String[])object2).length + " parts: " + (String)object + " in " + string);
            }
            try {
                object = Rule.stripQuotes(object2[0]);
                ArrayList<String[]> arrayList = Rule.stripQuotes(object2[1]);
                String string2 = Rule.stripQuotes(object2[2]);
                object2 = Rule.parsePhonemeExpr(Rule.stripQuotes(object2[3]));
                int n4 = n2;
                object = new Rule$2((String)object, (String)((Object)arrayList), string2, (Rule$PhonemeExpr)object2, n4, string);
                object2 = object.pattern.substring(0, 1);
                arrayList = (List)hashMap.get(object2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String[]>();
                    hashMap.put((String)object2, arrayList);
                }
                arrayList.add((String[])object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException("Problem parsing line '" + n2 + "' in " + string, illegalArgumentException);
            }
        }
        return hashMap;
    }

    private static Rule$RPattern pattern(String string) {
        boolean bl;
        boolean bl2 = string.startsWith("^");
        String string2 = string.substring(bl2 ? 1 : 0, (bl = string.endsWith("$")) ? string.length() - 1 : string.length());
        boolean bl3 = string2.contains("[");
        if (!bl3) {
            if (bl2 && bl) {
                if (string2.length() == 0) {
                    return new Rule$3();
                }
                return new Rule$4(string2);
            }
            if ((bl2 || bl) && string2.length() == 0) {
                return ALL_STRINGS_RMATCHER;
            }
            if (bl2) {
                return new Rule$5(string2);
            }
            if (bl) {
                return new Rule$6(string2);
            }
        } else {
            bl3 = string2.startsWith("[");
            boolean bl4 = string2.endsWith("]");
            if (bl3 && bl4 && !(string2 = string2.substring(1, string2.length() - 1)).contains("[")) {
                bl3 = string2.startsWith("^");
                if (bl3) {
                    string2 = string2.substring(1);
                }
                boolean bl5 = bl3 = !bl3;
                if (bl2 && bl) {
                    return new Rule$7(string2, bl3);
                }
                if (bl2) {
                    return new Rule$8(string2, bl3);
                }
                if (bl) {
                    return new Rule$9(string2, bl3);
                }
            }
        }
        return new Rule$10(string);
    }

    private static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2.length() > charSequence.length()) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence2.length(); ++i2) {
            if (charSequence.charAt(i2) == charSequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    private static String stripQuotes(String string) {
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1);
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public Rule(String string, String string2, String string3, Rule$PhonemeExpr rule$PhonemeExpr) {
        this.pattern = string;
        this.lContext = Rule.pattern(string2 + "$");
        this.rContext = Rule.pattern("^" + string3);
        this.phoneme = rule$PhonemeExpr;
    }

    public Rule$RPattern getLContext() {
        return this.lContext;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Rule$PhonemeExpr getPhoneme() {
        return this.phoneme;
    }

    public Rule$RPattern getRContext() {
        return this.rContext;
    }

    public boolean patternAndContextMatches(CharSequence charSequence, int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Can not match pattern at negative indexes");
        }
        int n3 = this.pattern.length();
        if ((n3 = n2 + n3) > charSequence.length()) {
            return false;
        }
        if (!charSequence.subSequence(n2, n3).equals(this.pattern)) {
            return false;
        }
        if (!this.rContext.isMatch(charSequence.subSequence(n3, charSequence.length()))) {
            return false;
        }
        return this.lContext.isMatch(charSequence.subSequence(0, n2));
    }

    static /* synthetic */ boolean access$100(CharSequence charSequence, CharSequence charSequence2) {
        return Rule.startsWith(charSequence, charSequence2);
    }

    static /* synthetic */ boolean access$200(CharSequence charSequence, CharSequence charSequence2) {
        return Rule.endsWith(charSequence, charSequence2);
    }

    static /* synthetic */ boolean access$300(CharSequence charSequence, char c2) {
        return Rule.contains(charSequence, c2);
    }

    static {
        for (NameType nameType : NameType.values()) {
            EnumMap enumMap = new EnumMap(RuleType.class);
            for (RuleType ruleType : RuleType.values()) {
                HashMap<String, Map<String, List<Rule>>> hashMap = new HashMap<String, Map<String, List<Rule>>>();
                Languages languages = Languages.getInstance(nameType);
                for (String string : languages.getLanguages()) {
                    try {
                        hashMap.put(string, Rule.parseRules(Rule.createScanner(nameType, ruleType, string), Rule.createResourceName(nameType, ruleType, string)));
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new IllegalStateException("Problem processing " + Rule.createResourceName(nameType, ruleType, string), illegalStateException);
                    }
                }
                if (!ruleType.equals((Object)RuleType.RULES)) {
                    hashMap.put("common", Rule.parseRules(Rule.createScanner(nameType, ruleType, "common"), Rule.createResourceName(nameType, ruleType, "common")));
                }
                enumMap.put(ruleType, Collections.unmodifiableMap(hashMap));
            }
            RULES.put(nameType, Collections.unmodifiableMap(enumMap));
        }
    }
}

