/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3;

import com.aliyun.openservices.shade.org.apache.commons.lang3.AnnotationUtils$1;
import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringBuilder;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class AnnotationUtils {
    private static final ToStringStyle TO_STRING_STYLE = new AnnotationUtils$1();

    public static boolean equals(Annotation annotation, Annotation annotation2) {
        if (annotation == annotation2) {
            return true;
        }
        if (annotation == null || annotation2 == null) {
            return false;
        }
        Method[] methodArray = annotation.annotationType();
        Class<? extends Annotation> clazz = annotation2.annotationType();
        Validate.notNull(methodArray, "Annotation %s with null annotationType()", annotation);
        Validate.notNull(clazz, "Annotation %s with null annotationType()", annotation2);
        if (!methodArray.equals(clazz)) {
            return false;
        }
        try {
            for (Method method : methodArray.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 0 || !AnnotationUtils.isValidAnnotationMemberType(method.getReturnType())) continue;
                Object object = method.invoke((Object)annotation, new Object[0]);
                Object object2 = method.invoke((Object)annotation2, new Object[0]);
                if (AnnotationUtils.memberEquals(method.getReturnType(), object, object2)) continue;
                return false;
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
        return true;
    }

    public static int hashCode(Annotation annotation) {
        int n2 = 0;
        Method[] methodArray = annotation.annotationType();
        for (Method method : methodArray.getDeclaredMethods()) {
            Object object;
            try {
                object = method.invoke((Object)annotation, new Object[0]);
                if (object == null) {
                    throw new IllegalStateException(String.format("Annotation method %s returned null", method));
                }
                n2 += AnnotationUtils.hashMember(method.getName(), object);
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return n2;
    }

    public static String toString(Annotation object) {
        ToStringBuilder toStringBuilder = new ToStringBuilder(object, TO_STRING_STYLE);
        for (Method method : object.annotationType().getDeclaredMethods()) {
            if (method.getParameterTypes().length > 0) continue;
            try {
                toStringBuilder.append(method.getName(), method.invoke(object, new Object[0]));
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return toStringBuilder.build();
    }

    public static boolean isValidAnnotationMemberType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.isPrimitive() || clazz.isEnum() || clazz.isAnnotation() || String.class.equals(clazz) || Class.class.equals(clazz);
    }

    private static int hashMember(String string, Object object) {
        int n2 = string.hashCode() * 127;
        if (object.getClass().isArray()) {
            return n2 ^ AnnotationUtils.arrayMemberHash(object.getClass().getComponentType(), object);
        }
        if (object instanceof Annotation) {
            return n2 ^ AnnotationUtils.hashCode((Annotation)object);
        }
        return n2 ^ object.hashCode();
    }

    private static boolean memberEquals(Class<?> clazz, Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (clazz.isArray()) {
            return AnnotationUtils.arrayMemberEquals(clazz.getComponentType(), object, object2);
        }
        if (clazz.isAnnotation()) {
            return AnnotationUtils.equals((Annotation)object, (Annotation)object2);
        }
        return object.equals(object2);
    }

    private static boolean arrayMemberEquals(Class<?> clazz, Object object, Object object2) {
        if (clazz.isAnnotation()) {
            return AnnotationUtils.annotationArrayMemberEquals((Annotation[])object, (Annotation[])object2);
        }
        if (clazz.equals(Byte.TYPE)) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (clazz.equals(Short.TYPE)) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        if (clazz.equals(Integer.TYPE)) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (clazz.equals(Character.TYPE)) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (clazz.equals(Long.TYPE)) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (clazz.equals(Float.TYPE)) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (clazz.equals(Double.TYPE)) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        return Arrays.equals((Object[])object, (Object[])object2);
    }

    private static boolean annotationArrayMemberEquals(Annotation[] annotationArray, Annotation[] annotationArray2) {
        if (annotationArray.length != annotationArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            if (AnnotationUtils.equals(annotationArray[i2], annotationArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static int arrayMemberHash(Class<?> clazz, Object object) {
        if (clazz.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])object);
        }
        if (clazz.equals(Short.TYPE)) {
            return Arrays.hashCode((short[])object);
        }
        if (clazz.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])object);
        }
        if (clazz.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])object);
        }
        if (clazz.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])object);
        }
        if (clazz.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])object);
        }
        if (clazz.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])object);
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])object);
        }
        return Arrays.hashCode((Object[])object);
    }
}

