/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3;

import com.aliyun.openservices.shade.org.apache.commons.lang3.ArrayUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ObjectUtils$Null;
import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.exception.CloneFailedException;
import com.aliyun.openservices.shade.org.apache.commons.lang3.mutable.MutableInt;
import com.aliyun.openservices.shade.org.apache.commons.lang3.text.StrBuilder;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ObjectUtils {
    public static final ObjectUtils$Null NULL = new ObjectUtils$Null();

    public static <T> T defaultIfNull(T t2, T t3) {
        if (t2 != null) {
            return t2;
        }
        return t3;
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... TArray) {
        if (TArray != null) {
            for (T t2 : TArray) {
                if (t2 == null) continue;
                return t2;
            }
        }
        return null;
    }

    public static boolean anyNotNull(Object ... objectArray) {
        return ObjectUtils.firstNonNull(objectArray) != null;
    }

    public static boolean allNotNull(Object ... objectArray) {
        if (objectArray == null) {
            return false;
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean notEqual(Object object, Object object2) {
        return !ObjectUtils.equals(object, object2);
    }

    @Deprecated
    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    @Deprecated
    public static int hashCodeMulti(Object ... objectArray) {
        int n2 = 1;
        if (objectArray != null) {
            for (Object object : objectArray) {
                int n3 = ObjectUtils.hashCode(object);
                n2 = n2 * 31 + n3;
            }
        }
        return n2;
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ObjectUtils.identityToString(stringBuilder, object);
        return stringBuilder.toString();
    }

    public static void identityToString(Appendable appendable, Object object) {
        Validate.notNull(object, "Cannot get the toString of a null identity", new Object[0]);
        appendable.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    @Deprecated
    public static void identityToString(StrBuilder strBuilder, Object object) {
        Validate.notNull(object, "Cannot get the toString of a null identity", new Object[0]);
        strBuilder.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static void identityToString(StringBuffer stringBuffer, Object object) {
        Validate.notNull(object, "Cannot get the toString of a null identity", new Object[0]);
        stringBuffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static void identityToString(StringBuilder stringBuilder, Object object) {
        Validate.notNull(object, "Cannot get the toString of a null identity", new Object[0]);
        stringBuilder.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    @Deprecated
    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    @Deprecated
    public static String toString(Object object, String string) {
        if (object == null) {
            return string;
        }
        return object.toString();
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T min(T ... TArray) {
        T t2 = null;
        if (TArray != null) {
            for (T t3 : TArray) {
                if (ObjectUtils.compare(t3, t2, true) >= 0) continue;
                t2 = t3;
            }
        }
        return t2;
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T max(T ... TArray) {
        T t2 = null;
        if (TArray != null) {
            for (T t3 : TArray) {
                if (ObjectUtils.compare(t3, t2, false) <= 0) continue;
                t2 = t3;
            }
        }
        return t2;
    }

    public static <T extends Comparable<? super T>> int compare(T t2, T t3) {
        return ObjectUtils.compare(t2, t3, false);
    }

    public static <T extends Comparable<? super T>> int compare(T t2, T t3, boolean bl) {
        if (t2 == t3) {
            return 0;
        }
        if (t2 == null) {
            if (bl) {
                return 1;
            }
            return -1;
        }
        if (t3 == null) {
            if (bl) {
                return -1;
            }
            return 1;
        }
        return t2.compareTo(t3);
    }

    @SafeVarargs
    public static <T extends Comparable<? super T>> T median(T ... object) {
        Validate.notEmpty(object);
        Validate.noNullElements(object);
        TreeSet treeSet = new TreeSet();
        Collections.addAll(treeSet, object);
        object = (Comparable)treeSet.toArray()[(treeSet.size() - 1) / 2];
        return (T)object;
    }

    @SafeVarargs
    public static <T> T median(Comparator<T> object, T ... TArray) {
        Validate.notEmpty(TArray, "null/empty items", new Object[0]);
        Validate.noNullElements(TArray);
        Validate.notNull(object, "null comparator", new Object[0]);
        object = new TreeSet<T>(object);
        Collections.addAll(object, TArray);
        object = ((AbstractCollection)object).toArray()[(((TreeSet)object).size() - 1) / 2];
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T mode(T ... object) {
        if (ArrayUtils.isNotEmpty(object)) {
            void var0_3;
            HashMap<Object, MutableInt> hashMap = new HashMap<Object, MutableInt>(((Object)object).length);
            for (Object object2 : object) {
                MutableInt mutableInt = (MutableInt)hashMap.get(object2);
                if (mutableInt == null) {
                    hashMap.put(object2, new MutableInt(1));
                    continue;
                }
                mutableInt.increment();
            }
            Object var0_2 = null;
            int n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                int n3 = ((MutableInt)entry.getValue()).intValue();
                if (n3 == n2) {
                    Object var0_4 = null;
                    continue;
                }
                if (n3 <= n2) continue;
                n2 = n3;
                Object k2 = entry.getKey();
            }
            return var0_3;
        }
        return null;
    }

    public static <T> T clone(T t2) {
        if (t2 instanceof Cloneable) {
            Class<?> clazz;
            if (t2.getClass().isArray()) {
                clazz = t2.getClass().getComponentType();
                if (!clazz.isPrimitive()) {
                    clazz = ((Object[])t2).clone();
                } else {
                    int n2 = Array.getLength(t2);
                    clazz = Array.newInstance(clazz, n2);
                    while (n2-- > 0) {
                        Array.set(clazz, n2, Array.get(t2, n2));
                    }
                }
            } else {
                try {
                    clazz = t2.getClass().getMethod("clone", new Class[0]);
                    clazz = ((Method)((Object)clazz)).invoke(t2, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new CloneFailedException("Cloneable type " + t2.getClass().getName() + " has no clone method", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CloneFailedException("Cannot clone Cloneable type " + t2.getClass().getName(), illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new CloneFailedException("Exception cloning Cloneable type " + t2.getClass().getName(), invocationTargetException.getCause());
                }
            }
            return (T)clazz;
        }
        return null;
    }

    public static <T> T cloneIfPossible(T t2) {
        T t3 = ObjectUtils.clone(t2);
        if (t3 == null) {
            return t2;
        }
        return t3;
    }

    public static boolean CONST(boolean bl) {
        return bl;
    }

    public static byte CONST(byte by) {
        return by;
    }

    public static byte CONST_BYTE(int n2) {
        if (n2 < -128 || n2 > 127) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -128 and 127: [" + n2 + "]");
        }
        return (byte)n2;
    }

    public static char CONST(char c2) {
        return c2;
    }

    public static short CONST(short s2) {
        return s2;
    }

    public static short CONST_SHORT(int n2) {
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Supplied value must be a valid byte literal between -32768 and 32767: [" + n2 + "]");
        }
        return (short)n2;
    }

    public static int CONST(int n2) {
        return n2;
    }

    public static long CONST(long l2) {
        return l2;
    }

    public static float CONST(float f2) {
        return f2;
    }

    public static double CONST(double d2) {
        return d2;
    }

    public static <T> T CONST(T t2) {
        return t2;
    }
}

