/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3;

import com.aliyun.openservices.shade.org.apache.commons.lang3.ThreadUtils$AlwaysTruePredicate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ThreadUtils$NamePredicate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ThreadUtils$ThreadGroupPredicate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ThreadUtils$ThreadIdPredicate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ThreadUtils$ThreadPredicate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ThreadUtils {
    public static final ThreadUtils$AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new ThreadUtils$AlwaysTruePredicate(null);

    public static Thread findThreadById(long l2, ThreadGroup threadGroup) {
        Validate.isTrue(threadGroup != null, "The thread group must not be null", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && threadGroup.equals(thread.getThreadGroup())) {
            return thread;
        }
        return null;
    }

    public static Thread findThreadById(long l2, String string) {
        Validate.isTrue(string != null, "The thread group name must not be null", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(string)) {
            return thread;
        }
        return null;
    }

    public static Collection<Thread> findThreadsByName(String string, ThreadGroup threadGroup) {
        return ThreadUtils.findThreads(threadGroup, false, new ThreadUtils$NamePredicate(string));
    }

    public static Collection<Thread> findThreadsByName(String object, String iterator) {
        Validate.isTrue(object != null, "The thread name must not be null", new Object[0]);
        Validate.isTrue(iterator != null, "The thread group name must not be null", new Object[0]);
        iterator = ThreadUtils.findThreadGroups(new ThreadUtils$NamePredicate((String)((Object)iterator)));
        if (iterator.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        object = new ThreadUtils$NamePredicate((String)object);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ThreadGroup threadGroup = (ThreadGroup)iterator.next();
            arrayList.addAll(ThreadUtils.findThreads(threadGroup, false, (ThreadUtils$ThreadPredicate)object));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String string) {
        return ThreadUtils.findThreadGroups(new ThreadUtils$NamePredicate(string));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(ALWAYS_TRUE_PREDICATE);
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(ALWAYS_TRUE_PREDICATE);
    }

    public static Collection<Thread> findThreadsByName(String string) {
        return ThreadUtils.findThreads(new ThreadUtils$NamePredicate(string));
    }

    public static Thread findThreadById(long l2) {
        Collection<Thread> collection = ThreadUtils.findThreads(new ThreadUtils$ThreadIdPredicate(l2));
        if (collection.isEmpty()) {
            return null;
        }
        return collection.iterator().next();
    }

    public static Collection<Thread> findThreads(ThreadUtils$ThreadPredicate threadUtils$ThreadPredicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, threadUtils$ThreadPredicate);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadUtils$ThreadGroupPredicate threadUtils$ThreadGroupPredicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, threadUtils$ThreadGroupPredicate);
    }

    public static Collection<Thread> findThreads(ThreadGroup object, boolean n2, ThreadUtils$ThreadPredicate threadUtils$ThreadPredicate) {
        int n3;
        Thread[] threadArray;
        Validate.isTrue(object != null, "The group must not be null", new Object[0]);
        Validate.isTrue(threadUtils$ThreadPredicate != null, "The predicate must not be null", new Object[0]);
        int n4 = ((ThreadGroup)object).activeCount();
        do {
            n3 = n4;
        } while ((n4 = ((ThreadGroup)object).enumerate(threadArray = new Thread[n3 + n3 / 2 + 1], n2 != 0)) >= threadArray.length);
        object = new ArrayList(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            if (!threadUtils$ThreadPredicate.test(threadArray[n2])) continue;
            object.add(threadArray[n2]);
        }
        return Collections.unmodifiableCollection(object);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup object, boolean n2, ThreadUtils$ThreadGroupPredicate threadUtils$ThreadGroupPredicate) {
        int n3;
        ThreadGroup[] threadGroupArray;
        Validate.isTrue(object != null, "The group must not be null", new Object[0]);
        Validate.isTrue(threadUtils$ThreadGroupPredicate != null, "The predicate must not be null", new Object[0]);
        int n4 = ((ThreadGroup)object).activeGroupCount();
        do {
            n3 = n4;
        } while ((n4 = ((ThreadGroup)object).enumerate(threadGroupArray = new ThreadGroup[n3 + n3 / 2 + 1], n2 != 0)) >= threadGroupArray.length);
        object = new ArrayList(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            if (!threadUtils$ThreadGroupPredicate.test(threadGroupArray[n2])) continue;
            object.add(threadGroupArray[n2]);
        }
        return Collections.unmodifiableCollection(object);
    }
}

