/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3.builder;

import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.Builder;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.Diff;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$1;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$10;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$11;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$12;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$13;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$14;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$15;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$16;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$17;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$18;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$2;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$3;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$4;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$5;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$6;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$7;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$8;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder$9;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffResult;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DiffBuilder
implements Builder<DiffResult> {
    private final List<Diff<?>> diffs;
    private final boolean objectsTriviallyEqual;
    private final Object left;
    private final Object right;
    private final ToStringStyle style;

    public DiffBuilder(Object object, Object object2, ToStringStyle toStringStyle, boolean bl) {
        Validate.isTrue(object != null, "lhs cannot be null", new Object[0]);
        Validate.isTrue(object2 != null, "rhs cannot be null", new Object[0]);
        this.diffs = new ArrayList();
        this.left = object;
        this.right = object2;
        this.style = toStringStyle;
        this.objectsTriviallyEqual = bl && (object == object2 || object.equals(object2));
    }

    public DiffBuilder(Object object, Object object2, ToStringStyle toStringStyle) {
        this(object, object2, toStringStyle, true);
    }

    public DiffBuilder append(String string, boolean bl, boolean bl2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (bl != bl2) {
            this.diffs.add(new DiffBuilder$1(this, string, bl, bl2));
        }
        return this;
    }

    public DiffBuilder append(String string, boolean[] blArray, boolean[] blArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(blArray, blArray2)) {
            this.diffs.add(new DiffBuilder$2(this, string, blArray, blArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, byte by, byte by2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (by != by2) {
            this.diffs.add(new DiffBuilder$3(this, string, by, by2));
        }
        return this;
    }

    public DiffBuilder append(String string, byte[] byArray, byte[] byArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(byArray, byArray2)) {
            this.diffs.add(new DiffBuilder$4(this, string, byArray, byArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, char c2, char c3) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (c2 != c3) {
            this.diffs.add(new DiffBuilder$5(this, string, c2, c3));
        }
        return this;
    }

    public DiffBuilder append(String string, char[] cArray, char[] cArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(cArray, cArray2)) {
            this.diffs.add(new DiffBuilder$6(this, string, cArray, cArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, double d2, double d3) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Double.doubleToLongBits(d2) != Double.doubleToLongBits(d3)) {
            this.diffs.add(new DiffBuilder$7(this, string, d2, d3));
        }
        return this;
    }

    public DiffBuilder append(String string, double[] dArray, double[] dArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(dArray, dArray2)) {
            this.diffs.add(new DiffBuilder$8(this, string, dArray, dArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, float f2, float f3) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (Float.floatToIntBits(f2) != Float.floatToIntBits(f3)) {
            this.diffs.add(new DiffBuilder$9(this, string, f2, f3));
        }
        return this;
    }

    public DiffBuilder append(String string, float[] fArray, float[] fArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(fArray, fArray2)) {
            this.diffs.add(new DiffBuilder$10(this, string, fArray, fArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, int n2, int n3) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (n2 != n3) {
            this.diffs.add(new DiffBuilder$11(this, string, n2, n3));
        }
        return this;
    }

    public DiffBuilder append(String string, int[] nArray, int[] nArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(nArray, nArray2)) {
            this.diffs.add(new DiffBuilder$12(this, string, nArray, nArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, long l2, long l3) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (l2 != l3) {
            this.diffs.add(new DiffBuilder$13(this, string, l2, l3));
        }
        return this;
    }

    public DiffBuilder append(String string, long[] lArray, long[] lArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(lArray, lArray2)) {
            this.diffs.add(new DiffBuilder$14(this, string, lArray, lArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, short s2, short s3) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (s2 != s3) {
            this.diffs.add(new DiffBuilder$15(this, string, s2, s3));
        }
        return this;
    }

    public DiffBuilder append(String string, short[] sArray, short[] sArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(sArray, sArray2)) {
            this.diffs.add(new DiffBuilder$16(this, string, sArray, sArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, Object object, Object object2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (object == object2) {
            return this;
        }
        Object object3 = object != null ? object : object2;
        if (object3.getClass().isArray()) {
            if (object3 instanceof boolean[]) {
                return this.append(string, (boolean[])object, (boolean[])object2);
            }
            if (object3 instanceof byte[]) {
                return this.append(string, (byte[])object, (byte[])object2);
            }
            if (object3 instanceof char[]) {
                return this.append(string, (char[])object, (char[])object2);
            }
            if (object3 instanceof double[]) {
                return this.append(string, (double[])object, (double[])object2);
            }
            if (object3 instanceof float[]) {
                return this.append(string, (float[])object, (float[])object2);
            }
            if (object3 instanceof int[]) {
                return this.append(string, (int[])object, (int[])object2);
            }
            if (object3 instanceof long[]) {
                return this.append(string, (long[])object, (long[])object2);
            }
            if (object3 instanceof short[]) {
                return this.append(string, (short[])object, (short[])object2);
            }
            return this.append(string, (Object[])object, (Object[])object2);
        }
        if (object != null && object.equals(object2)) {
            return this;
        }
        this.diffs.add(new DiffBuilder$17(this, string, object, object2));
        return this;
    }

    public DiffBuilder append(String string, Object[] objectArray, Object[] objectArray2) {
        this.validateFieldNameNotNull(string);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        if (!Arrays.equals(objectArray, objectArray2)) {
            this.diffs.add(new DiffBuilder$18(this, string, objectArray, objectArray2));
        }
        return this;
    }

    public DiffBuilder append(String string, DiffResult object) {
        this.validateFieldNameNotNull(string);
        Validate.isTrue(object != null, "Diff result cannot be null", new Object[0]);
        if (this.objectsTriviallyEqual) {
            return this;
        }
        for (Diff<?> diff : ((DiffResult)((Object)object)).getDiffs()) {
            this.append(string + "." + diff.getFieldName(), diff.getLeft(), diff.getRight());
        }
        return this;
    }

    @Override
    public DiffResult build() {
        return new DiffResult(this.left, this.right, this.diffs, this.style);
    }

    private void validateFieldNameNotNull(String string) {
        Validate.isTrue(string != null, "Field name cannot be null", new Object[0]);
    }
}

