/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3.builder;

import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.Builder;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffBuilder;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.DiffResult;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle;
import com.aliyun.openservices.shade.org.apache.commons.lang3.reflect.FieldUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ReflectionDiffBuilder
implements Builder<DiffResult> {
    private final Object left;
    private final Object right;
    private final DiffBuilder diffBuilder;

    public <T> ReflectionDiffBuilder(T t2, T t3, ToStringStyle toStringStyle) {
        this.left = t2;
        this.right = t3;
        this.diffBuilder = new DiffBuilder(t2, t3, toStringStyle);
    }

    @Override
    public DiffResult build() {
        if (this.left.equals(this.right)) {
            return this.diffBuilder.build();
        }
        ReflectionDiffBuilder reflectionDiffBuilder = this;
        reflectionDiffBuilder.appendFields(reflectionDiffBuilder.left.getClass());
        return this.diffBuilder.build();
    }

    private void appendFields(Class<?> fieldArray) {
        for (Field field : FieldUtils.getAllFields(fieldArray)) {
            if (!this.accept(field)) continue;
            try {
                this.diffBuilder.append(field.getName(), FieldUtils.readField(field, this.left, true), FieldUtils.readField(field, this.right, true));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError("Unexpected IllegalAccessException: " + illegalAccessException.getMessage());
            }
        }
    }

    private boolean accept(Field field) {
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic(field.getModifiers());
    }
}

