/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3.builder;

import com.aliyun.openservices.shade.org.apache.commons.lang3.ClassUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ObjectUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle$DefaultToStringStyle;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle$JsonToStringStyle;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle$MultiLineToStringStyle;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle$NoClassNameToStringStyle;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle$NoFieldNameToStringStyle;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle$ShortPrefixToStringStyle;
import com.aliyun.openservices.shade.org.apache.commons.lang3.builder.ToStringStyle$SimpleToStringStyle;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class ToStringStyle
implements Serializable {
    private static final long serialVersionUID = -2587890625525655916L;
    public static final ToStringStyle DEFAULT_STYLE = new ToStringStyle$DefaultToStringStyle();
    public static final ToStringStyle MULTI_LINE_STYLE = new ToStringStyle$MultiLineToStringStyle();
    public static final ToStringStyle NO_FIELD_NAMES_STYLE = new ToStringStyle$NoFieldNameToStringStyle();
    public static final ToStringStyle SHORT_PREFIX_STYLE = new ToStringStyle$ShortPrefixToStringStyle();
    public static final ToStringStyle SIMPLE_STYLE = new ToStringStyle$SimpleToStringStyle();
    public static final ToStringStyle NO_CLASS_NAME_STYLE = new ToStringStyle$NoClassNameToStringStyle();
    public static final ToStringStyle JSON_STYLE = new ToStringStyle$JsonToStringStyle();
    private static final ThreadLocal<WeakHashMap<Object, Object>> REGISTRY = new ThreadLocal();
    private boolean useFieldNames = true;
    private boolean useClassName = true;
    private boolean useShortClassName = false;
    private boolean useIdentityHashCode = true;
    private String contentStart = "[";
    private String contentEnd = "]";
    private String fieldNameValueSeparator = "=";
    private boolean fieldSeparatorAtStart = false;
    private boolean fieldSeparatorAtEnd = false;
    private String fieldSeparator = ",";
    private String arrayStart = "{";
    private String arraySeparator = ",";
    private boolean arrayContentDetail = true;
    private String arrayEnd = "}";
    private boolean defaultFullDetail = true;
    private String nullText = "<null>";
    private String sizeStartText = "<size=";
    private String sizeEndText = ">";
    private String summaryObjectStartText = "<";
    private String summaryObjectEndText = ">";

    static Map<Object, Object> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object object) {
        Map<Object, Object> map = ToStringStyle.getRegistry();
        return map != null && map.containsKey(object);
    }

    static void register(Object object) {
        if (object != null) {
            Map<Object, Object> map = ToStringStyle.getRegistry();
            if (map == null) {
                REGISTRY.set(new WeakHashMap());
            }
            ToStringStyle.getRegistry().put(object, null);
        }
    }

    static void unregister(Object object) {
        Map<Object, Object> map;
        if (object != null && (map = ToStringStyle.getRegistry()) != null) {
            map.remove(object);
            if (map.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    public void appendSuper(StringBuffer stringBuffer, String string) {
        this.appendToString(stringBuffer, string);
    }

    public void appendToString(StringBuffer stringBuffer, String string) {
        int n2;
        int n3;
        if (string != null && (n3 = string.indexOf(this.contentStart) + this.contentStart.length()) != (n2 = string.lastIndexOf(this.contentEnd)) && n3 >= 0 && n2 >= 0) {
            string = string.substring(n3, n2);
            if (this.fieldSeparatorAtStart) {
                this.removeLastFieldSeparator(stringBuffer);
            }
            stringBuffer.append(string);
            this.appendFieldSeparator(stringBuffer);
        }
    }

    public void appendStart(StringBuffer stringBuffer, Object object) {
        if (object != null) {
            this.appendClassName(stringBuffer, object);
            this.appendIdentityHashCode(stringBuffer, object);
            this.appendContentStart(stringBuffer);
            if (this.fieldSeparatorAtStart) {
                this.appendFieldSeparator(stringBuffer);
            }
        }
    }

    public void appendEnd(StringBuffer stringBuffer, Object object) {
        if (!this.fieldSeparatorAtEnd) {
            this.removeLastFieldSeparator(stringBuffer);
        }
        this.appendContentEnd(stringBuffer);
        ToStringStyle.unregister(object);
    }

    protected void removeLastFieldSeparator(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        int n3 = this.fieldSeparator.length();
        if (n2 > 0 && n3 > 0 && n2 >= n3) {
            boolean bl = true;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (stringBuffer.charAt(n2 - 1 - i2) == this.fieldSeparator.charAt(n3 - 1 - i2)) continue;
                bl = false;
                break;
            }
            if (bl) {
                stringBuffer.setLength(n2 - n3);
            }
        }
    }

    public void append(StringBuffer stringBuffer, String string, Object object, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (object == null) {
            this.appendNullText(stringBuffer, string);
        } else {
            this.appendInternal(stringBuffer, string, object, this.isFullDetail(bl));
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendInternal(StringBuffer stringBuffer, String string, Object object, boolean bl) {
        if (ToStringStyle.isRegistered(object) && !(object instanceof Number) && !(object instanceof Boolean) && !(object instanceof Character)) {
            this.appendCyclicObject(stringBuffer, string, object);
            return;
        }
        ToStringStyle.register(object);
        try {
            if (object instanceof Collection) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (Collection)object);
                } else {
                    this.appendSummarySize(stringBuffer, string, ((Collection)object).size());
                }
            } else if (object instanceof Map) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (Map)object);
                } else {
                    this.appendSummarySize(stringBuffer, string, ((Map)object).size());
                }
            } else if (object instanceof long[]) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (long[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (long[])object);
                }
            } else if (object instanceof int[]) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (int[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (int[])object);
                }
            } else if (object instanceof short[]) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (short[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (short[])object);
                }
            } else if (object instanceof byte[]) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (byte[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (byte[])object);
                }
            } else if (object instanceof char[]) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (char[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (char[])object);
                }
            } else if (object instanceof double[]) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (double[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (double[])object);
                }
            } else if (object instanceof float[]) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (float[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (float[])object);
                }
            } else if (object instanceof boolean[]) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (boolean[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (boolean[])object);
                }
            } else if (object.getClass().isArray()) {
                if (bl) {
                    this.appendDetail(stringBuffer, string, (Object[])object);
                } else {
                    this.appendSummary(stringBuffer, string, (Object[])object);
                }
            } else if (bl) {
                this.appendDetail(stringBuffer, string, object);
            } else {
                this.appendSummary(stringBuffer, string, object);
            }
            return;
        }
        finally {
            ToStringStyle.unregister(object);
        }
    }

    protected void appendCyclicObject(StringBuffer stringBuffer, String string, Object object) {
        ObjectUtils.identityToString(stringBuffer, object);
    }

    public void appendDetail(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(object);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, Collection<?> collection) {
        stringBuffer.append(collection);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, Map<?, ?> map) {
        stringBuffer.append(map);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(this.summaryObjectStartText);
        stringBuffer.append(this.getShortClassName(object.getClass()));
        stringBuffer.append(this.summaryObjectEndText);
    }

    public void append(StringBuffer stringBuffer, String string, long l2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, l2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, long l2) {
        stringBuffer.append(l2);
    }

    public void append(StringBuffer stringBuffer, String string, int n2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, n2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, int n2) {
        stringBuffer.append(n2);
    }

    public void append(StringBuffer stringBuffer, String string, short s2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, s2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, short s2) {
        stringBuffer.append(s2);
    }

    public void append(StringBuffer stringBuffer, String string, byte by) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, by);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, byte by) {
        stringBuffer.append(by);
    }

    public void append(StringBuffer stringBuffer, String string, char c2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, c2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, char c2) {
        stringBuffer.append(c2);
    }

    public void append(StringBuffer stringBuffer, String string, double d2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, d2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, double d2) {
        stringBuffer.append(d2);
    }

    public void append(StringBuffer stringBuffer, String string, float f2) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, f2);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, float f2) {
        stringBuffer.append(f2);
    }

    public void append(StringBuffer stringBuffer, String string, boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        this.appendDetail(stringBuffer, string, bl);
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, boolean bl) {
        stringBuffer.append(bl);
    }

    public void append(StringBuffer stringBuffer, String string, Object[] objectArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (objectArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, objectArray);
        } else {
            this.appendSummary(stringBuffer, string, objectArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, Object[] objectArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            if (object == null) {
                this.appendNullText(stringBuffer, string);
                continue;
            }
            this.appendInternal(stringBuffer, string, object, this.arrayContentDetail);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void reflectionAppendArrayDetail(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(this.arrayStart);
        int n2 = Array.getLength(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = Array.get(object, i2);
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            if (object2 == null) {
                this.appendNullText(stringBuffer, string);
                continue;
            }
            this.appendInternal(stringBuffer, string, object2, this.arrayContentDetail);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, Object[] objectArray) {
        this.appendSummarySize(stringBuffer, string, objectArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, long[] lArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (lArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, lArray);
        } else {
            this.appendSummary(stringBuffer, string, lArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, long[] lArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string, lArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, long[] lArray) {
        this.appendSummarySize(stringBuffer, string, lArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, int[] nArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (nArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, nArray);
        } else {
            this.appendSummary(stringBuffer, string, nArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, int[] nArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string, nArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, int[] nArray) {
        this.appendSummarySize(stringBuffer, string, nArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, short[] sArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (sArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, sArray);
        } else {
            this.appendSummary(stringBuffer, string, sArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, short[] sArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string, sArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, short[] sArray) {
        this.appendSummarySize(stringBuffer, string, sArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, byte[] byArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (byArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, byArray);
        } else {
            this.appendSummary(stringBuffer, string, byArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, byte[] byArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string, byArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, byte[] byArray) {
        this.appendSummarySize(stringBuffer, string, byArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, char[] cArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (cArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, cArray);
        } else {
            this.appendSummary(stringBuffer, string, cArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, char[] cArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string, cArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, char[] cArray) {
        this.appendSummarySize(stringBuffer, string, cArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, double[] dArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (dArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, dArray);
        } else {
            this.appendSummary(stringBuffer, string, dArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, double[] dArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string, dArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, double[] dArray) {
        this.appendSummarySize(stringBuffer, string, dArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, float[] fArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (fArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, fArray);
        } else {
            this.appendSummary(stringBuffer, string, fArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, float[] fArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string, fArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, float[] fArray) {
        this.appendSummarySize(stringBuffer, string, fArray.length);
    }

    public void append(StringBuffer stringBuffer, String string, boolean[] blArray, Boolean bl) {
        this.appendFieldStart(stringBuffer, string);
        if (blArray == null) {
            this.appendNullText(stringBuffer, string);
        } else if (this.isFullDetail(bl)) {
            this.appendDetail(stringBuffer, string, blArray);
        } else {
            this.appendSummary(stringBuffer, string, blArray);
        }
        this.appendFieldEnd(stringBuffer, string);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string, boolean[] blArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string, blArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string, boolean[] blArray) {
        this.appendSummarySize(stringBuffer, string, blArray.length);
    }

    protected void appendClassName(StringBuffer stringBuffer, Object object) {
        if (this.useClassName && object != null) {
            ToStringStyle.register(object);
            if (this.useShortClassName) {
                stringBuffer.append(this.getShortClassName(object.getClass()));
                return;
            }
            stringBuffer.append(object.getClass().getName());
        }
    }

    protected void appendIdentityHashCode(StringBuffer stringBuffer, Object object) {
        if (this.isUseIdentityHashCode() && object != null) {
            ToStringStyle.register(object);
            stringBuffer.append('@');
            stringBuffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    protected void appendContentStart(StringBuffer stringBuffer) {
        stringBuffer.append(this.contentStart);
    }

    protected void appendContentEnd(StringBuffer stringBuffer) {
        stringBuffer.append(this.contentEnd);
    }

    protected void appendNullText(StringBuffer stringBuffer, String string) {
        stringBuffer.append(this.nullText);
    }

    protected void appendFieldSeparator(StringBuffer stringBuffer) {
        stringBuffer.append(this.fieldSeparator);
    }

    protected void appendFieldStart(StringBuffer stringBuffer, String string) {
        if (this.useFieldNames && string != null) {
            stringBuffer.append(string);
            stringBuffer.append(this.fieldNameValueSeparator);
        }
    }

    protected void appendFieldEnd(StringBuffer stringBuffer, String string) {
        this.appendFieldSeparator(stringBuffer);
    }

    protected void appendSummarySize(StringBuffer stringBuffer, String string, int n2) {
        stringBuffer.append(this.sizeStartText);
        stringBuffer.append(n2);
        stringBuffer.append(this.sizeEndText);
    }

    protected boolean isFullDetail(Boolean bl) {
        if (bl == null) {
            return this.defaultFullDetail;
        }
        return bl;
    }

    protected String getShortClassName(Class<?> clazz) {
        return ClassUtils.getShortClassName(clazz);
    }

    protected boolean isUseClassName() {
        return this.useClassName;
    }

    protected void setUseClassName(boolean bl) {
        this.useClassName = bl;
    }

    protected boolean isUseShortClassName() {
        return this.useShortClassName;
    }

    protected void setUseShortClassName(boolean bl) {
        this.useShortClassName = bl;
    }

    protected boolean isUseIdentityHashCode() {
        return this.useIdentityHashCode;
    }

    protected void setUseIdentityHashCode(boolean bl) {
        this.useIdentityHashCode = bl;
    }

    protected boolean isUseFieldNames() {
        return this.useFieldNames;
    }

    protected void setUseFieldNames(boolean bl) {
        this.useFieldNames = bl;
    }

    protected boolean isDefaultFullDetail() {
        return this.defaultFullDetail;
    }

    protected void setDefaultFullDetail(boolean bl) {
        this.defaultFullDetail = bl;
    }

    protected boolean isArrayContentDetail() {
        return this.arrayContentDetail;
    }

    protected void setArrayContentDetail(boolean bl) {
        this.arrayContentDetail = bl;
    }

    protected String getArrayStart() {
        return this.arrayStart;
    }

    protected void setArrayStart(String string) {
        if (string == null) {
            string = "";
        }
        this.arrayStart = string;
    }

    protected String getArrayEnd() {
        return this.arrayEnd;
    }

    protected void setArrayEnd(String string) {
        if (string == null) {
            string = "";
        }
        this.arrayEnd = string;
    }

    protected String getArraySeparator() {
        return this.arraySeparator;
    }

    protected void setArraySeparator(String string) {
        if (string == null) {
            string = "";
        }
        this.arraySeparator = string;
    }

    protected String getContentStart() {
        return this.contentStart;
    }

    protected void setContentStart(String string) {
        if (string == null) {
            string = "";
        }
        this.contentStart = string;
    }

    protected String getContentEnd() {
        return this.contentEnd;
    }

    protected void setContentEnd(String string) {
        if (string == null) {
            string = "";
        }
        this.contentEnd = string;
    }

    protected String getFieldNameValueSeparator() {
        return this.fieldNameValueSeparator;
    }

    protected void setFieldNameValueSeparator(String string) {
        if (string == null) {
            string = "";
        }
        this.fieldNameValueSeparator = string;
    }

    protected String getFieldSeparator() {
        return this.fieldSeparator;
    }

    protected void setFieldSeparator(String string) {
        if (string == null) {
            string = "";
        }
        this.fieldSeparator = string;
    }

    protected boolean isFieldSeparatorAtStart() {
        return this.fieldSeparatorAtStart;
    }

    protected void setFieldSeparatorAtStart(boolean bl) {
        this.fieldSeparatorAtStart = bl;
    }

    protected boolean isFieldSeparatorAtEnd() {
        return this.fieldSeparatorAtEnd;
    }

    protected void setFieldSeparatorAtEnd(boolean bl) {
        this.fieldSeparatorAtEnd = bl;
    }

    protected String getNullText() {
        return this.nullText;
    }

    protected void setNullText(String string) {
        if (string == null) {
            string = "";
        }
        this.nullText = string;
    }

    protected String getSizeStartText() {
        return this.sizeStartText;
    }

    protected void setSizeStartText(String string) {
        if (string == null) {
            string = "";
        }
        this.sizeStartText = string;
    }

    protected String getSizeEndText() {
        return this.sizeEndText;
    }

    protected void setSizeEndText(String string) {
        if (string == null) {
            string = "";
        }
        this.sizeEndText = string;
    }

    protected String getSummaryObjectStartText() {
        return this.summaryObjectStartText;
    }

    protected void setSummaryObjectStartText(String string) {
        if (string == null) {
            string = "";
        }
        this.summaryObjectStartText = string;
    }

    protected String getSummaryObjectEndText() {
        return this.summaryObjectEndText;
    }

    protected void setSummaryObjectEndText(String string) {
        if (string == null) {
            string = "";
        }
        this.summaryObjectEndText = string;
    }
}

