/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3.concurrent;

import com.aliyun.openservices.shade.org.apache.commons.lang3.concurrent.Computable;
import com.aliyun.openservices.shade.org.apache.commons.lang3.concurrent.Memoizer$1;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class Memoizer<I, O>
implements Computable<I, O> {
    private final ConcurrentMap<I, Future<O>> cache = new ConcurrentHashMap<I, Future<O>>();
    private final Computable<I, O> computable;
    private final boolean recalculate;

    public Memoizer(Computable<I, O> computable) {
        this(computable, false);
    }

    public Memoizer(Computable<I, O> computable, boolean bl) {
        this.computable = computable;
        this.recalculate = bl;
    }

    @Override
    public O compute(I i2) {
        while (true) {
            Object object;
            if ((object = (Future)this.cache.get(i2)) == null) {
                Object object2 = new Memoizer$1(this, i2);
                object = (Future)this.cache.putIfAbsent(i2, (Future<O>)(object2 = new FutureTask(object2)));
                if (object == null) {
                    object = object2;
                    ((FutureTask)object2).run();
                }
            }
            try {
                return (O)object.get();
            }
            catch (CancellationException cancellationException) {
                this.cache.remove(i2, object);
                continue;
            }
            catch (ExecutionException executionException) {
                if (this.recalculate) {
                    this.cache.remove(i2, object);
                }
                throw this.launderException(executionException.getCause());
            }
            break;
        }
    }

    private RuntimeException launderException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IllegalStateException("Unchecked exception", throwable);
    }

    static /* synthetic */ Computable access$000(Memoizer memoizer) {
        return memoizer.computable;
    }
}

