/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3.reflect;

import com.aliyun.openservices.shade.org.apache.commons.lang3.ArrayUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ClassUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ClassUtils$Interfaces;
import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.reflect.MemberUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.reflect.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MethodUtils {
    public static Object invokeMethod(Object object, String string) {
        return MethodUtils.invokeMethod(object, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, boolean bl, String string) {
        return MethodUtils.invokeMethod(object, bl, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, boolean bl, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeMethod(object, bl, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, boolean bl, String string, Object[] objectArray, Class<?>[] classArray) {
        Method method;
        String string2;
        classArray = ArrayUtils.nullToEmpty(classArray);
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        if (bl) {
            string2 = "No such method: ";
            method = MethodUtils.getMatchingMethod(object.getClass(), string, classArray);
            if (method != null && !method.isAccessible()) {
                method.setAccessible(true);
            }
        } else {
            string2 = "No such accessible method: ";
            method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray);
        }
        if (method == null) {
            throw new NoSuchMethodException(string2 + string + "() on object: " + object.getClass().getName());
        }
        objectArray = MethodUtils.toVarArgs(method, objectArray);
        return method.invoke(object, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class<?>[] classArray) {
        return MethodUtils.invokeMethod(object, false, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string) {
        return MethodUtils.invokeExactMethod(object, string, ArrayUtils.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeExactMethod(Object object, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class<?>[] object2) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        object2 = ArrayUtils.nullToEmpty(object2);
        object2 = MethodUtils.getAccessibleMethod(object.getClass(), string, object2);
        if (object2 == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return ((Method)object2).invoke(object, objectArray);
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string, Object[] objectArray, Class<?>[] object) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        object = ArrayUtils.nullToEmpty(object);
        if ((object = MethodUtils.getAccessibleMethod(clazz, string, object)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        return ((Method)object).invoke(null, objectArray);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string, Object[] objectArray, Class<?>[] object) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        object = ArrayUtils.nullToEmpty(object);
        if ((object = MethodUtils.getMatchingAccessibleMethod(clazz, string, object)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on class: " + clazz.getName());
        }
        objectArray = MethodUtils.toVarArgs(object, objectArray);
        return ((Method)object).invoke(null, objectArray);
    }

    private static Object[] toVarArgs(Method classArray, Object[] objectArray) {
        if (classArray.isVarArgs()) {
            classArray = classArray.getParameterTypes();
            objectArray = MethodUtils.getVarArgs(objectArray, classArray);
        }
        return objectArray;
    }

    static Object[] getVarArgs(Object[] objectArray, Class<?>[] classArray) {
        if (objectArray.length == classArray.length && objectArray[objectArray.length - 1].getClass().equals(classArray[classArray.length - 1])) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[classArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, classArray.length - 1);
        Class<?> clazz = classArray[classArray.length - 1].getComponentType();
        int n2 = objectArray.length - classArray.length + 1;
        Object object = Array.newInstance(ClassUtils.primitiveToWrapper(clazz), n2);
        System.arraycopy(objectArray, classArray.length - 1, object, 0, n2);
        if (clazz.isPrimitive()) {
            object = ArrayUtils.toPrimitive(object);
        }
        objectArray2[classArray.length - 1] = object;
        return objectArray2;
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string, Object ... objectArray) {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeExactStaticMethod(clazz, string, objectArray, classArray);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class<?>[] classArray;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string, Class<?> ... classArray) {
        for (clazz = clazz.getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            Class<?>[] classArray3 = classArray2;
            classArray3 = classArray2;
            int n2 = classArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                GenericDeclaration genericDeclaration = classArray3[i2];
                if (!Modifier.isPublic(genericDeclaration.getModifiers())) continue;
                try {
                    return genericDeclaration.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    genericDeclaration = MethodUtils.getAccessibleMethodFromInterfaceNest(genericDeclaration, string, classArray);
                    if (genericDeclaration == null) continue;
                    return genericDeclaration;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> genericDeclarationArray, String string, Class<?> ... classArray) {
        try {
            Method method = genericDeclarationArray.getMethod(string, classArray);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object object;
            Object object2;
            Method method = null;
            Method[] methodArray = genericDeclarationArray.getMethods();
            genericDeclarationArray = methodArray;
            genericDeclarationArray = methodArray;
            int n2 = methodArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object2 = genericDeclarationArray[i2];
                if (!((Method)object2).getName().equals(string) || !MemberUtils.isMatchingMethod((Method)object2, classArray) || (object = MethodUtils.getAccessibleMethod((Method)object2)) == null || method != null && MemberUtils.compareMethodFit((Method)object, method, classArray) >= 0) continue;
                method = object;
            }
            if (method != null) {
                MemberUtils.setAccessibleWorkaround(method);
            }
            if (method != null && method.isVarArgs() && method.getParameterTypes().length > 0 && classArray.length > 0) {
                genericDeclarationArray = method.getParameterTypes();
                Class<?> clazz = genericDeclarationArray[genericDeclarationArray.length - 1].getComponentType();
                String string2 = ClassUtils.primitiveToWrapper(clazz).getName();
                object2 = classArray[classArray.length - 1].getName();
                object = classArray[classArray.length - 1].getSuperclass().getName();
                if (!string2.equals(object2) && !string2.equals(object)) {
                    return null;
                }
            }
            return method;
        }
    }

    public static Method getMatchingMethod(Class<?> object, String string, Class<?> ... classArray) {
        Method[] methodArray;
        Validate.notNull(object, "Null class not allowed.", new Object[0]);
        Validate.notEmpty(string, "Null or blank methodName not allowed.", new Object[0]);
        Method[] methodArray2 = ((Class)object).getDeclaredMethods();
        object = ClassUtils.getAllSuperclasses(object);
        object = object.iterator();
        while (object.hasNext()) {
            methodArray = object.next();
            methodArray2 = ArrayUtils.addAll(methodArray2, methodArray.getDeclaredMethods());
        }
        object = null;
        methodArray = methodArray2;
        int n2 = methodArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Method method = methodArray[i2];
            if (string.equals(method.getName()) && Objects.deepEquals(classArray, method.getParameterTypes())) {
                return method;
            }
            if (!string.equals(method.getName()) || !ClassUtils.isAssignable(classArray, method.getParameterTypes(), true)) continue;
            if (object == null) {
                object = method;
                continue;
            }
            if (MethodUtils.distance(classArray, method.getParameterTypes()) >= MethodUtils.distance(classArray, ((Method)object).getParameterTypes())) continue;
            object = method;
        }
        return object;
    }

    private static int distance(Class<?>[] classArray, Class<?>[] classArray2) {
        int n2 = 0;
        if (!ClassUtils.isAssignable(classArray, classArray2, true)) {
            return -1;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2].equals(classArray2[i2])) continue;
            if (ClassUtils.isAssignable(classArray[i2], classArray2[i2], true) && !ClassUtils.isAssignable(classArray[i2], classArray2[i2], false)) {
                ++n2;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils$Interfaces object) {
        Validate.notNull(method);
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        linkedHashSet.add(method);
        Object[] objectArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        object = ClassUtils.hierarchy(clazz, (ClassUtils$Interfaces)((Object)object)).iterator();
        object.next();
        block0: while (object.hasNext()) {
            GenericDeclaration genericDeclaration = (Class)object.next();
            if ((genericDeclaration = MethodUtils.getMatchingAccessibleMethod(genericDeclaration, method.getName(), objectArray)) == null) continue;
            if (Arrays.equals(((Method)genericDeclaration).getParameterTypes(), objectArray)) {
                linkedHashSet.add((Method)genericDeclaration);
                continue;
            }
            Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(clazz, ((Method)genericDeclaration).getDeclaringClass());
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Type type;
                Type type2 = TypeUtils.unrollVariables(map, method.getGenericParameterTypes()[i2]);
                if (!TypeUtils.equals(type2, type = TypeUtils.unrollVariables(map, ((Method)genericDeclaration).getGenericParameterTypes()[i2]))) continue block0;
            }
            linkedHashSet.add((Method)genericDeclaration);
        }
        return linkedHashSet;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return MethodUtils.getMethodsWithAnnotation(clazz, clazz2, false, false);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> clazz, Class<? extends Annotation> clazz2) {
        return MethodUtils.getMethodsListWithAnnotation(clazz, clazz2, false, false);
    }

    public static Method[] getMethodsWithAnnotation(Class<?> object, Class<? extends Annotation> clazz, boolean bl, boolean bl2) {
        object = MethodUtils.getMethodsListWithAnnotation(object, clazz, bl, bl2);
        return object.toArray(new Method[object.size()]);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> serializable, Class<? extends Annotation> clazz, boolean bl, boolean bl2) {
        Validate.isTrue(serializable != null, "The class must not be null", new Object[0]);
        Validate.isTrue(clazz != null, "The annotation class must not be null", new Object[0]);
        Object object = bl ? MethodUtils.getAllSuperclassesAndInterfaces(serializable) : new ArrayList();
        object.add(0, serializable);
        serializable = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Method[] methodArray = (Method[])object.next();
            Method[] methodArray2 = bl2 ? methodArray.getDeclaredMethods() : methodArray.getMethods();
            methodArray = methodArray2;
            methodArray = methodArray2;
            int n2 = methodArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Method method = methodArray[i2];
                if (method.getAnnotation(clazz) == null) continue;
                serializable.add((Method)method);
            }
        }
        return serializable;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> clazz, boolean bl, boolean bl2) {
        Validate.isTrue(method != null, "The method must not be null", new Object[0]);
        Validate.isTrue(clazz != null, "The annotation class must not be null", new Object[0]);
        if (!bl2 && !MemberUtils.isAccessible(method)) {
            return null;
        }
        A a2 = method.getAnnotation(clazz);
        if (a2 == null && bl) {
            Iterator<Class<?>> iterator = method.getDeclaringClass();
            iterator = MethodUtils.getAllSuperclassesAndInterfaces(iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                GenericDeclaration genericDeclaration = iterator.next();
                try {
                    genericDeclaration = bl2 ? ((Class)genericDeclaration).getDeclaredMethod(method.getName(), method.getParameterTypes()) : ((Class)genericDeclaration).getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                a2 = ((Method)genericDeclaration).getAnnotation(clazz);
                if (a2 == null) continue;
            }
        }
        return a2;
    }

    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> object) {
        if (object == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(object);
        int n2 = 0;
        object = ClassUtils.getAllInterfaces(object);
        int n3 = 0;
        while (n3 < object.size() || n2 < list.size()) {
            Class<?> clazz = n3 >= object.size() ? list.get(n2++) : (n2 < list.size() && n3 >= n2 && n2 < n3 ? list.get(n2++) : (Class<?>)object.get(n3++));
            arrayList.add(clazz);
        }
        return arrayList;
    }
}

