/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3.time;

import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.DurationFormatUtils$Token;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.SSS'S'";
    static final Object y = "y";
    static final Object M = "M";
    static final Object d = "d";
    static final Object H = "H";
    static final Object m = "m";
    static final Object s = "s";
    static final Object S = "S";

    public static String formatDurationHMS(long l2) {
        return DurationFormatUtils.formatDuration(l2, "HH:mm:ss.SSS");
    }

    public static String formatDurationISO(long l2) {
        return DurationFormatUtils.formatDuration(l2, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDuration(long l2, String string) {
        return DurationFormatUtils.formatDuration(l2, string, true);
    }

    public static String formatDuration(long l2, String durationFormatUtils$TokenArray, boolean bl) {
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, l2, "durationMillis must not be negative");
        durationFormatUtils$TokenArray = DurationFormatUtils.lexx((String)durationFormatUtils$TokenArray);
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, d)) {
            l3 = l2 / 86400000L;
            l7 = l2 - l3 * 86400000L;
        }
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, H)) {
            l4 = l7 / 3600000L;
            l7 -= l4 * 3600000L;
        }
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, m)) {
            l5 = l7 / 60000L;
            l7 -= l5 * 60000L;
        }
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, s)) {
            l6 = l7 / 1000L;
            l7 -= l6 * 1000L;
        }
        return DurationFormatUtils.format(durationFormatUtils$TokenArray, 0L, 0L, l3, l4, l5, l6, l7, bl);
    }

    public static String formatDurationWords(long l2, boolean bl, boolean bl2) {
        String string;
        String string2 = DurationFormatUtils.formatDuration(l2, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (bl) {
            string = StringUtils.replaceOnce(string2 = " " + string2, " 0 days", "");
            if (string.length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
                string2 = string;
                string2 = string = StringUtils.replaceOnce(string2, " 0 minutes", "");
                if (string.length() != string2.length()) {
                    string2 = StringUtils.replaceOnce(string, " 0 seconds", "");
                }
            }
            if (string2.length() != 0) {
                string2 = string2.substring(1);
            }
        }
        if (bl2 && (string = StringUtils.replaceOnce(string2, " 0 seconds", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 minutes", "")).length() != string2.length() && (string = StringUtils.replaceOnce(string2 = string, " 0 hours", "")).length() != string2.length()) {
            string2 = StringUtils.replaceOnce(string, " 0 days", "");
        }
        string2 = " " + string2;
        string2 = StringUtils.replaceOnce(string2, " 1 seconds", " 1 second");
        string2 = StringUtils.replaceOnce(string2, " 1 minutes", " 1 minute");
        string2 = StringUtils.replaceOnce(string2, " 1 hours", " 1 hour");
        string2 = StringUtils.replaceOnce(string2, " 1 days", " 1 day");
        return string2.trim();
    }

    public static String formatPeriodISO(long l2, long l3) {
        return DurationFormatUtils.formatPeriod(l2, l3, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String string) {
        return DurationFormatUtils.formatPeriod(l2, l3, string, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String durationFormatUtils$TokenArray, boolean bl, TimeZone timeZone) {
        Validate.isTrue(l2 <= l3, "startMillis must not be greater than endMillis", new Object[0]);
        durationFormatUtils$TokenArray = DurationFormatUtils.lexx((String)durationFormatUtils$TokenArray);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(new Date(l2));
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(new Date(l3));
        int n2 = calendar2.get(14) - calendar.get(14);
        int n3 = calendar2.get(13) - calendar.get(13);
        int n4 = calendar2.get(12) - calendar.get(12);
        int n5 = calendar2.get(11) - calendar.get(11);
        int n6 = calendar2.get(5) - calendar.get(5);
        int n7 = calendar2.get(2) - calendar.get(2);
        int n8 = calendar2.get(1) - calendar.get(1);
        while (n2 < 0) {
            n2 += 1000;
            --n3;
        }
        while (n3 < 0) {
            n3 += 60;
            --n4;
        }
        while (n4 < 0) {
            n4 += 60;
            --n5;
        }
        while (n5 < 0) {
            n5 += 24;
            --n6;
        }
        if (DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, M)) {
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
            while (n7 < 0) {
                n7 += 12;
                --n8;
            }
            if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, y) && n8 != 0) {
                while (n8 != 0) {
                    n7 += n8 * 12;
                    n8 = 0;
                }
            }
        } else {
            if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, y)) {
                n8 = calendar2.get(1);
                if (n7 < 0) {
                    --n8;
                }
                while (calendar.get(1) != n8) {
                    n6 += calendar.getActualMaximum(6) - calendar.get(6);
                    if (calendar instanceof GregorianCalendar && calendar.get(2) == 1 && calendar.get(5) == 29) {
                        ++n6;
                    }
                    calendar.add(1, 1);
                    n6 += calendar.get(6);
                }
                n8 = 0;
            }
            while (calendar.get(2) != calendar2.get(2)) {
                n6 += calendar.getActualMaximum(5);
                calendar.add(2, 1);
            }
            n7 = 0;
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
        }
        if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, d)) {
            n5 += n6 * 24;
            n6 = 0;
        }
        if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, H)) {
            n4 += n5 * 60;
            n5 = 0;
        }
        if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, m)) {
            n3 += n4 * 60;
            n4 = 0;
        }
        if (!DurationFormatUtils$Token.containsTokenWithValue(durationFormatUtils$TokenArray, s)) {
            n2 += n3 * 1000;
            n3 = 0;
        }
        return DurationFormatUtils.format(durationFormatUtils$TokenArray, n8, n7, n6, n5, n4, n3, n2, bl);
    }

    static String format(DurationFormatUtils$Token[] durationFormatUtils$TokenArray, long l2, long l3, long l4, long l5, long l6, long l7, long l8, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (DurationFormatUtils$Token durationFormatUtils$Token : durationFormatUtils$TokenArray) {
            Object object = durationFormatUtils$Token.getValue();
            int n3 = durationFormatUtils$Token.getCount();
            if (object instanceof StringBuilder) {
                stringBuilder.append(object.toString());
                continue;
            }
            if (object.equals(y)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(l2, bl, n3));
            } else if (object.equals(M)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(l3, bl, n3));
            } else if (object.equals(d)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(l4, bl, n3));
            } else if (object.equals(H)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(l5, bl, n3));
            } else if (object.equals(m)) {
                stringBuilder.append(DurationFormatUtils.paddedValue(l6, bl, n3));
            } else {
                if (object.equals(s)) {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l7, bl, n3));
                    n2 = 1;
                    continue;
                }
                if (!object.equals(S)) continue;
                if (n2 != 0) {
                    n2 = bl ? Math.max(3, n3) : 3;
                    stringBuilder.append(DurationFormatUtils.paddedValue(l8, true, n2));
                } else {
                    stringBuilder.append(DurationFormatUtils.paddedValue(l8, bl, n3));
                }
            }
            n2 = 0;
        }
        return stringBuilder.toString();
    }

    private static String paddedValue(long l2, boolean bl, int n2) {
        String string = Long.toString(l2);
        if (bl) {
            return StringUtils.leftPad(string, n2, '0');
        }
        return string;
    }

    static DurationFormatUtils$Token[] lexx(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>(string.length());
        boolean bl = false;
        Object object = null;
        Object object2 = null;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl && c2 != '\'') {
                ((StringBuilder)object).append(c2);
                continue;
            }
            Object object3 = null;
            switch (c2) {
                case '\'': {
                    if (bl) {
                        object = null;
                        bl = false;
                        break;
                    }
                    object = new StringBuilder();
                    arrayList.add(new DurationFormatUtils$Token(object));
                    bl = true;
                    break;
                }
                case 'y': {
                    object3 = y;
                    break;
                }
                case 'M': {
                    object3 = M;
                    break;
                }
                case 'd': {
                    object3 = d;
                    break;
                }
                case 'H': {
                    object3 = H;
                    break;
                }
                case 'm': {
                    object3 = m;
                    break;
                }
                case 's': {
                    object3 = s;
                    break;
                }
                case 'S': {
                    object3 = S;
                    break;
                }
                default: {
                    if (object == null) {
                        object = new StringBuilder();
                        arrayList.add(new DurationFormatUtils$Token(object));
                    }
                    ((StringBuilder)object).append(c2);
                }
            }
            if (object3 == null) continue;
            if (object2 != null && ((DurationFormatUtils$Token)object2).getValue().equals(object3)) {
                ((DurationFormatUtils$Token)object2).increment();
            } else {
                object = new DurationFormatUtils$Token(object3);
                arrayList.add(object);
                object2 = object;
            }
            object = null;
        }
        if (bl) {
            throw new IllegalArgumentException("Unmatched quote in format: " + string);
        }
        ArrayList<Object> arrayList2 = arrayList;
        return arrayList2.toArray(new DurationFormatUtils$Token[arrayList2.size()]);
    }
}

