/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3.time;

import com.aliyun.openservices.shade.org.apache.commons.lang3.time.DateParser;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$1;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$2;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$3;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$4;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$5;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$6;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$CaseInsensitiveTextStrategy;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$ISO8601TimeZoneStrategy;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$NumberStrategy;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$Strategy;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$StrategyAndWidth;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$StrategyParser;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDateParser$TimeZoneStrategy;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FastDateParser
implements DateParser,
Serializable {
    private static final long serialVersionUID = 3L;
    static final Locale JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private final int century;
    private final int startYear;
    private transient List<FastDateParser$StrategyAndWidth> patterns;
    private static final Comparator<String> LONGER_FIRST_LOWERCASE = new FastDateParser$1();
    private static final ConcurrentMap<Locale, FastDateParser$Strategy>[] caches = new ConcurrentMap[17];
    private static final FastDateParser$Strategy ABBREVIATED_YEAR_STRATEGY = new FastDateParser$2(1);
    private static final FastDateParser$Strategy NUMBER_MONTH_STRATEGY = new FastDateParser$3(2);
    private static final FastDateParser$Strategy LITERAL_YEAR_STRATEGY = new FastDateParser$NumberStrategy(1);
    private static final FastDateParser$Strategy WEEK_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(3);
    private static final FastDateParser$Strategy WEEK_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(4);
    private static final FastDateParser$Strategy DAY_OF_YEAR_STRATEGY = new FastDateParser$NumberStrategy(6);
    private static final FastDateParser$Strategy DAY_OF_MONTH_STRATEGY = new FastDateParser$NumberStrategy(5);
    private static final FastDateParser$Strategy DAY_OF_WEEK_STRATEGY = new FastDateParser$4(7);
    private static final FastDateParser$Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY = new FastDateParser$NumberStrategy(8);
    private static final FastDateParser$Strategy HOUR_OF_DAY_STRATEGY = new FastDateParser$NumberStrategy(11);
    private static final FastDateParser$Strategy HOUR24_OF_DAY_STRATEGY = new FastDateParser$5(11);
    private static final FastDateParser$Strategy HOUR12_STRATEGY = new FastDateParser$6(10);
    private static final FastDateParser$Strategy HOUR_STRATEGY = new FastDateParser$NumberStrategy(10);
    private static final FastDateParser$Strategy MINUTE_STRATEGY = new FastDateParser$NumberStrategy(12);
    private static final FastDateParser$Strategy SECOND_STRATEGY = new FastDateParser$NumberStrategy(13);
    private static final FastDateParser$Strategy MILLISECOND_STRATEGY = new FastDateParser$NumberStrategy(14);

    protected FastDateParser(String string, TimeZone timeZone, Locale locale) {
        this(string, timeZone, locale, null);
    }

    protected FastDateParser(String object, TimeZone timeZone, Locale locale, Date date) {
        int n2;
        this.pattern = object;
        this.timeZone = timeZone;
        this.locale = locale;
        object = Calendar.getInstance(timeZone, locale);
        if (date != null) {
            ((Calendar)object).setTime(date);
            n2 = ((Calendar)object).get(1);
        } else if (locale.equals(JAPANESE_IMPERIAL)) {
            n2 = 0;
        } else {
            ((Calendar)object).setTime(new Date());
            n2 = ((Calendar)object).get(1) - 80;
        }
        this.century = n2 / 100 * 100;
        this.startYear = n2 - this.century;
        this.init((Calendar)object);
    }

    private void init(Calendar object) {
        FastDateParser$StrategyAndWidth fastDateParser$StrategyAndWidth;
        this.patterns = new ArrayList<FastDateParser$StrategyAndWidth>();
        object = new FastDateParser$StrategyParser(this, (Calendar)object);
        while ((fastDateParser$StrategyAndWidth = ((FastDateParser$StrategyParser)object).getNextStrategy()) != null) {
            this.patterns.add(fastDateParser$StrategyAndWidth);
        }
    }

    private static boolean isFormatLetter(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDateParser)) {
            return false;
        }
        object = (FastDateParser)object;
        return this.pattern.equals(((FastDateParser)object).pattern) && this.timeZone.equals(((FastDateParser)object).timeZone) && this.locale.equals(((FastDateParser)object).locale);
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    public String toString() {
        return "FastDateParser[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream object) {
        ((ObjectInputStream)object).defaultReadObject();
        object = Calendar.getInstance(this.timeZone, this.locale);
        this.init((Calendar)object);
    }

    @Override
    public Object parseObject(String string) {
        return this.parse(string);
    }

    @Override
    public Date parse(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.parse(string, parsePosition);
        if (date == null) {
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\nUnparseable date: \"" + string, parsePosition.getErrorIndex());
            }
            throw new ParseException("Unparseable date: " + string, parsePosition.getErrorIndex());
        }
        return date;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.clear();
        if (this.parse(string, parsePosition, calendar)) {
            return calendar.getTime();
        }
        return null;
    }

    @Override
    public boolean parse(String string, ParsePosition parsePosition, Calendar calendar) {
        ListIterator<FastDateParser$StrategyAndWidth> listIterator = this.patterns.listIterator();
        while (listIterator.hasNext()) {
            FastDateParser$StrategyAndWidth fastDateParser$StrategyAndWidth = listIterator.next();
            int n2 = fastDateParser$StrategyAndWidth.getMaxWidth(listIterator);
            if (fastDateParser$StrategyAndWidth.strategy.parse(this, calendar, string, parsePosition, n2)) continue;
            return false;
        }
        return true;
    }

    private static StringBuilder simpleQuote(StringBuilder stringBuilder, String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder;
    }

    private static Map<String, Integer> appendDisplayNames(Calendar iterator, Locale locale, int n2, StringBuilder stringBuilder) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        iterator = ((Calendar)((Object)iterator)).getDisplayNames(n2, 0, locale);
        TreeSet<String> treeSet = new TreeSet<String>(LONGER_FIRST_LOWERCASE);
        for (Map.Entry entry : iterator.entrySet()) {
            String string = ((String)entry.getKey()).toLowerCase(locale);
            if (!treeSet.add(string)) continue;
            hashMap.put(string, (Integer)entry.getValue());
        }
        for (String string : treeSet) {
            FastDateParser.simpleQuote(stringBuilder, string).append('|');
        }
        return hashMap;
    }

    private int adjustYear(int n2) {
        int n3 = this.century + n2;
        if (n2 >= this.startYear) {
            return n3;
        }
        return n3 + 100;
    }

    private FastDateParser$Strategy getStrategy(char c2, int n2, Calendar calendar) {
        switch (c2) {
            default: {
                throw new IllegalArgumentException("Format '" + c2 + "' not supported");
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, calendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, calendar);
            }
            case 'H': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                if (n2 >= 3) {
                    return this.getLocaleSpecificStrategy(2, calendar);
                }
                return NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, calendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return HOUR12_STRATEGY;
            }
            case 'k': {
                return HOUR24_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'u': {
                return DAY_OF_WEEK_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'Y': 
            case 'y': {
                if (n2 > 2) {
                    return LITERAL_YEAR_STRATEGY;
                }
                return ABBREVIATED_YEAR_STRATEGY;
            }
            case 'X': {
                return FastDateParser$ISO8601TimeZoneStrategy.getStrategy(n2);
            }
            case 'Z': {
                if (n2 != 2) break;
                return FastDateParser$ISO8601TimeZoneStrategy.access$400();
            }
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, calendar);
    }

    private static ConcurrentMap<Locale, FastDateParser$Strategy> getCache(int n2) {
        ConcurrentMap<Locale, FastDateParser$Strategy>[] concurrentMapArray = caches;
        synchronized (caches) {
            if (caches[n2] == null) {
                FastDateParser.caches[n2] = new ConcurrentHashMap<Locale, FastDateParser$Strategy>(3);
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return caches[n2];
        }
    }

    private FastDateParser$Strategy getLocaleSpecificStrategy(int n2, Calendar calendar) {
        FastDateParser$Strategy fastDateParser$Strategy;
        ConcurrentMap<Locale, FastDateParser$Strategy> concurrentMap = FastDateParser.getCache(n2);
        FastDateParser$Strategy fastDateParser$Strategy2 = (FastDateParser$Strategy)concurrentMap.get(this.locale);
        if (fastDateParser$Strategy2 == null && (fastDateParser$Strategy = concurrentMap.putIfAbsent(this.locale, fastDateParser$Strategy2 = n2 == 15 ? new FastDateParser$TimeZoneStrategy(this.locale) : new FastDateParser$CaseInsensitiveTextStrategy(n2, calendar, this.locale))) != null) {
            return fastDateParser$Strategy;
        }
        return fastDateParser$Strategy2;
    }

    static /* synthetic */ String access$000(FastDateParser fastDateParser) {
        return fastDateParser.pattern;
    }

    static /* synthetic */ boolean access$100(char c2) {
        return FastDateParser.isFormatLetter(c2);
    }

    static /* synthetic */ FastDateParser$Strategy access$200(FastDateParser fastDateParser, char c2, int n2, Calendar calendar) {
        return fastDateParser.getStrategy(c2, n2, calendar);
    }

    static /* synthetic */ Map access$600(Calendar calendar, Locale locale, int n2, StringBuilder stringBuilder) {
        return FastDateParser.appendDisplayNames(calendar, locale, n2, stringBuilder);
    }

    static /* synthetic */ int access$700(FastDateParser fastDateParser, int n2) {
        return fastDateParser.adjustYear(n2);
    }

    static /* synthetic */ Comparator access$800() {
        return LONGER_FIRST_LOWERCASE;
    }

    static /* synthetic */ StringBuilder access$900(StringBuilder stringBuilder, String string) {
        return FastDateParser.simpleQuote(stringBuilder, string);
    }
}

