/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.org.apache.commons.lang3.time;

import com.aliyun.openservices.shade.org.apache.commons.lang3.exception.ExceptionUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.DatePrinter;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$CharacterLiteral;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$DayInWeekField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$Iso8601_Rule;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$NumberRule;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$PaddedNumberField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$Rule;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$StringLiteral;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TextField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TimeZoneDisplayKey;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TimeZoneNameRule;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TimeZoneNumberRule;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TwelveHourField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TwentyFourHourField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TwoDigitMonthField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TwoDigitNumberField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$TwoDigitYearField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$UnpaddedMonthField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$UnpaddedNumberField;
import com.aliyun.openservices.shade.org.apache.commons.lang3.time.FastDatePrinter$WeekYear;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FastDatePrinter
implements DatePrinter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient FastDatePrinter$Rule[] mRules;
    private transient int mMaxLengthEstimate;
    private static final int MAX_DIGITS = 10;
    private static final ConcurrentMap<FastDatePrinter$TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<FastDatePrinter$TimeZoneDisplayKey, String>(7);

    protected FastDatePrinter(String string, TimeZone timeZone, Locale locale) {
        this.mPattern = string;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private void init() {
        List<FastDatePrinter$Rule> list;
        List<FastDatePrinter$Rule> list2 = list = this.parsePattern();
        this.mRules = list2.toArray(new FastDatePrinter$Rule[list2.size()]);
        int n2 = 0;
        int n3 = this.mRules.length;
        while (--n3 >= 0) {
            n2 += this.mRules[n3].estimateLength();
        }
        this.mMaxLengthEstimate = n2;
    }

    protected List<FastDatePrinter$Rule> parsePattern() {
        String[] stringArray = new DateFormatSymbols(this.mLocale);
        ArrayList<FastDatePrinter$Rule> arrayList = new ArrayList<FastDatePrinter$Rule>();
        String[] stringArray2 = stringArray.getEras();
        String[] stringArray3 = stringArray.getMonths();
        String[] stringArray4 = stringArray.getShortMonths();
        String[] stringArray5 = stringArray.getWeekdays();
        String[] stringArray6 = stringArray.getShortWeekdays();
        stringArray = stringArray.getAmPmStrings();
        int n2 = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[0] = i2;
            FastDatePrinter fastDatePrinter = this;
            Object object = fastDatePrinter.parseToken(fastDatePrinter.mPattern, nArray);
            i2 = nArray[0];
            int n3 = ((String)object).length();
            if (n3 == 0) break;
            char c2 = ((String)object).charAt(0);
            switch (c2) {
                case 'G': {
                    object = new FastDatePrinter$TextField(0, stringArray2);
                    break;
                }
                case 'Y': 
                case 'y': {
                    object = n3 == 2 ? FastDatePrinter$TwoDigitYearField.INSTANCE : this.selectNumberRule(1, n3 < 4 ? 4 : n3);
                    if (c2 != 'Y') break;
                    object = new FastDatePrinter$WeekYear((FastDatePrinter$NumberRule)object);
                    break;
                }
                case 'M': {
                    if (n3 >= 4) {
                        object = new FastDatePrinter$TextField(2, stringArray3);
                        break;
                    }
                    if (n3 == 3) {
                        object = new FastDatePrinter$TextField(2, stringArray4);
                        break;
                    }
                    if (n3 == 2) {
                        object = FastDatePrinter$TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    object = FastDatePrinter$UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    object = this.selectNumberRule(5, n3);
                    break;
                }
                case 'h': {
                    object = new FastDatePrinter$TwelveHourField(this.selectNumberRule(10, n3));
                    break;
                }
                case 'H': {
                    object = this.selectNumberRule(11, n3);
                    break;
                }
                case 'm': {
                    object = this.selectNumberRule(12, n3);
                    break;
                }
                case 's': {
                    object = this.selectNumberRule(13, n3);
                    break;
                }
                case 'S': {
                    object = this.selectNumberRule(14, n3);
                    break;
                }
                case 'E': {
                    object = new FastDatePrinter$TextField(7, n3 < 4 ? stringArray6 : stringArray5);
                    break;
                }
                case 'u': {
                    object = new FastDatePrinter$DayInWeekField(this.selectNumberRule(7, n3));
                    break;
                }
                case 'D': {
                    object = this.selectNumberRule(6, n3);
                    break;
                }
                case 'F': {
                    object = this.selectNumberRule(8, n3);
                    break;
                }
                case 'w': {
                    object = this.selectNumberRule(3, n3);
                    break;
                }
                case 'W': {
                    object = this.selectNumberRule(4, n3);
                    break;
                }
                case 'a': {
                    object = new FastDatePrinter$TextField(9, stringArray);
                    break;
                }
                case 'k': {
                    object = new FastDatePrinter$TwentyFourHourField(this.selectNumberRule(11, n3));
                    break;
                }
                case 'K': {
                    object = this.selectNumberRule(10, n3);
                    break;
                }
                case 'X': {
                    object = FastDatePrinter$Iso8601_Rule.getRule(n3);
                    break;
                }
                case 'z': {
                    if (n3 >= 4) {
                        object = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    object = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        object = FastDatePrinter$TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n3 == 2) {
                        object = FastDatePrinter$Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    object = FastDatePrinter$TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    object = ((String)object).substring(1);
                    if (((String)object).length() == 1) {
                        object = new FastDatePrinter$CharacterLiteral(((String)object).charAt(0));
                        break;
                    }
                    object = new FastDatePrinter$StringLiteral((String)object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + (String)object);
                }
            }
            arrayList.add((FastDatePrinter$Rule)object);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        char c2 = string.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && (c3 = string.charAt(n2 + 1)) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 == '\'') {
                    if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return stringBuilder.toString();
    }

    protected FastDatePrinter$NumberRule selectNumberRule(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new FastDatePrinter$UnpaddedNumberField(n2);
            }
            case 2: {
                return new FastDatePrinter$TwoDigitNumberField(n2);
            }
        }
        return new FastDatePrinter$PaddedNumberField(n2, n3);
    }

    @Override
    @Deprecated
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((long)((Long)object), stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    String format(Object object) {
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object);
        }
        if (object instanceof Long) {
            return this.format((Long)object);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    @Override
    public String format(long l2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRulesToString(calendar);
    }

    private String applyRulesToString(Calendar calendar) {
        return this.applyRules(calendar, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    private Calendar newCalendar() {
        return Calendar.getInstance(this.mTimeZone, this.mLocale);
    }

    @Override
    public String format(Date date) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRulesToString(calendar);
    }

    @Override
    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.format(calendar.getTime(), stringBuffer);
    }

    @Override
    public <B extends Appendable> B format(long l2, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRules(calendar, b2);
    }

    @Override
    public <B extends Appendable> B format(Date date, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, b2);
    }

    @Override
    public <B extends Appendable> B format(Calendar calendar, B b2) {
        if (!calendar.getTimeZone().equals(this.mTimeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.mTimeZone);
        }
        return this.applyRules(calendar, b2);
    }

    @Deprecated
    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    private <B extends Appendable> B applyRules(Calendar calendar, B b2) {
        try {
            FastDatePrinter$Rule[] fastDatePrinter$RuleArray = this.mRules;
            int n2 = this.mRules.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                FastDatePrinter$Rule fastDatePrinter$Rule = fastDatePrinter$RuleArray[i2];
                fastDatePrinter$Rule.appendTo(b2, calendar);
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            ExceptionUtils.rethrow(iOException);
        }
        return b2;
    }

    @Override
    public String getPattern() {
        return this.mPattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDatePrinter)) {
            return false;
        }
        object = (FastDatePrinter)object;
        return this.mPattern.equals(((FastDatePrinter)object).mPattern) && this.mTimeZone.equals(((FastDatePrinter)object).mTimeZone) && this.mLocale.equals(((FastDatePrinter)object).mLocale);
    }

    public int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public String toString() {
        return "FastDatePrinter[" + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private static void appendDigits(Appendable appendable, int n2) {
        appendable.append((char)(n2 / 10 + 48));
        appendable.append((char)(n2 % 10 + 48));
    }

    private static void appendFullDigits(Appendable appendable, int n2, int n3) {
        if (n2 < 10000) {
            int n4 = 4;
            if (n2 < 1000) {
                --n4;
                if (n2 < 100) {
                    --n4;
                    if (n2 < 10) {
                        --n4;
                    }
                }
            }
            for (int i2 = n3 - n4; i2 > 0; --i2) {
                appendable.append('0');
            }
            switch (n4) {
                case 4: {
                    appendable.append((char)(n2 / 1000 + 48));
                    n2 %= 1000;
                }
                case 3: {
                    if (n2 >= 100) {
                        appendable.append((char)(n2 / 100 + 48));
                        n2 %= 100;
                    } else {
                        appendable.append('0');
                    }
                }
                case 2: {
                    if (n2 >= 10) {
                        appendable.append((char)(n2 / 10 + 48));
                        n2 %= 10;
                    } else {
                        appendable.append('0');
                    }
                }
                case 1: {
                    appendable.append((char)(n2 + 48));
                }
            }
            return;
        }
        char[] cArray = new char[10];
        int n5 = 0;
        while (n2 != 0) {
            cArray[n5++] = (char)(n2 % 10 + 48);
            n2 /= 10;
        }
        while (n5 < n3) {
            appendable.append('0');
            --n3;
        }
        while (--n5 >= 0) {
            appendable.append(cArray[n5]);
        }
    }

    static String getTimeZoneDisplay(TimeZone object, boolean bl, int n2, Locale locale) {
        FastDatePrinter$TimeZoneDisplayKey fastDatePrinter$TimeZoneDisplayKey = new FastDatePrinter$TimeZoneDisplayKey((TimeZone)object, bl, n2, locale);
        Object object2 = (String)cTimeZoneDisplayCache.get(fastDatePrinter$TimeZoneDisplayKey);
        if (object2 == null && (object = cTimeZoneDisplayCache.putIfAbsent(fastDatePrinter$TimeZoneDisplayKey, (String)(object2 = ((TimeZone)object).getDisplayName(bl, n2, locale)))) != null) {
            object2 = object;
        }
        return object2;
    }

    static /* synthetic */ void access$000(Appendable appendable, int n2) {
        FastDatePrinter.appendDigits(appendable, n2);
    }

    static /* synthetic */ void access$100(Appendable appendable, int n2, int n3) {
        FastDatePrinter.appendFullDigits(appendable, n2, n3);
    }
}

