/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.utils.IntSet;

public abstract class AbstractInput
implements Input {
    public final boolean[] pressedKeys;
    public final boolean[] justPressedKeys;
    private final IntSet keysToCatch = new IntSet();
    public int pressedKeyCount;
    public boolean keyJustPressed;

    public AbstractInput() {
        this.pressedKeys = new boolean[256];
        this.justPressedKeys = new boolean[256];
    }

    @Override
    public boolean isKeyPressed(int n2) {
        if (n2 == -1) {
            return this.pressedKeyCount > 0;
        }
        if (n2 < 0 || n2 > 255) {
            return false;
        }
        return this.pressedKeys[n2];
    }

    @Override
    public boolean isKeyJustPressed(int n2) {
        if (n2 == -1) {
            return this.keyJustPressed;
        }
        if (n2 < 0 || n2 > 255) {
            return false;
        }
        return this.justPressedKeys[n2];
    }

    @Override
    public void setCatchKey(int n2, boolean bl) {
        if (!bl) {
            this.keysToCatch.remove(n2);
            return;
        }
        this.keysToCatch.add(n2);
    }

    @Override
    public boolean isCatchKey(int n2) {
        return this.keysToCatch.contains(n2);
    }
}

