/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.CubemapLoader$CubemapLoaderInfo;
import com.badlogic.gdx.assets.loaders.CubemapLoader$CubemapParameter;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.glutils.KTXTextureData;
import com.badlogic.gdx.utils.Array;

public class CubemapLoader
extends AsynchronousAssetLoader<Cubemap, CubemapLoader$CubemapParameter> {
    CubemapLoader$CubemapLoaderInfo info = new CubemapLoader$CubemapLoaderInfo();

    public CubemapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string, FileHandle fileHandle, CubemapLoader$CubemapParameter cubemapLoader$CubemapParameter) {
        this.info.filename = string;
        if (cubemapLoader$CubemapParameter == null || cubemapLoader$CubemapParameter.cubemapData == null) {
            this.info.cubemap = null;
            if (cubemapLoader$CubemapParameter != null) {
                Pixmap$Format cfr_ignored_0 = cubemapLoader$CubemapParameter.format;
                this.info.cubemap = cubemapLoader$CubemapParameter.cubemap;
            }
            if (string.contains(".ktx") || string.contains(".zktx")) {
                this.info.data = new KTXTextureData(fileHandle, false);
            }
        } else {
            this.info.data = cubemapLoader$CubemapParameter.cubemapData;
            this.info.cubemap = cubemapLoader$CubemapParameter.cubemap;
        }
        if (!this.info.data.isPrepared()) {
            this.info.data.prepare();
        }
    }

    @Override
    public Cubemap loadSync(AssetManager disposable, String string, FileHandle fileHandle, CubemapLoader$CubemapParameter cubemapLoader$CubemapParameter) {
        if (this.info == null) {
            return null;
        }
        disposable = this.info.cubemap;
        if (disposable != null) {
            ((Cubemap)disposable).load(this.info.data);
        } else {
            disposable = new Cubemap(this.info.data);
        }
        if (cubemapLoader$CubemapParameter != null) {
            ((GLTexture)disposable).setFilter(cubemapLoader$CubemapParameter.minFilter, cubemapLoader$CubemapParameter.magFilter);
            ((GLTexture)disposable).setWrap(cubemapLoader$CubemapParameter.wrapU, cubemapLoader$CubemapParameter.wrapV);
        }
        return disposable;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String string, FileHandle fileHandle, CubemapLoader$CubemapParameter cubemapLoader$CubemapParameter) {
        return null;
    }
}

