/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.ModelLoader$ModelParameters;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider$AssetTextureProvider;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider$FileTextureProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap$Entry;
import java.util.Iterator;

public abstract class ModelLoader<P extends ModelLoader$ModelParameters>
extends AsynchronousAssetLoader<Model, P> {
    protected Array<ObjectMap$Entry<String, ModelData>> items = new Array();
    protected ModelLoader$ModelParameters defaultParameters = new ModelLoader$ModelParameters();

    public ModelLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    public abstract ModelData loadModelData(FileHandle var1, P var2);

    public ModelData loadModelData(FileHandle fileHandle) {
        return this.loadModelData(fileHandle, null);
    }

    public Model loadModel(FileHandle object, TextureProvider textureProvider, P p2) {
        if ((object = this.loadModelData((FileHandle)object, p2)) == null) {
            return null;
        }
        return new Model((ModelData)object, textureProvider);
    }

    public Model loadModel(FileHandle fileHandle, P p2) {
        return this.loadModel(fileHandle, new TextureProvider$FileTextureProvider(), p2);
    }

    public Model loadModel(FileHandle fileHandle, TextureProvider textureProvider) {
        return this.loadModel(fileHandle, textureProvider, null);
    }

    public Model loadModel(FileHandle fileHandle) {
        return this.loadModel(fileHandle, new TextureProvider$FileTextureProvider(), null);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String object, FileHandle object2, P object32) {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        if ((object2 = this.loadModelData((FileHandle)object2, object32)) == null) {
            return array;
        }
        ObjectMap$Entry objectMap$Entry = new ObjectMap$Entry();
        new ObjectMap$Entry().key = object;
        objectMap$Entry.value = object2;
        object = this.items;
        synchronized (object) {
            this.items.add(objectMap$Entry);
        }
        object = object32 != null ? ((ModelLoader$ModelParameters)object32).textureParameter : this.defaultParameters.textureParameter;
        for (ModelMaterial modelMaterial : ((ModelData)object2).materials) {
            if (modelMaterial.textures == null) continue;
            for (ModelTexture modelTexture : modelMaterial.textures) {
                array.add(new AssetDescriptor<Texture>(modelTexture.fileName, Texture.class, (AssetLoaderParameters<Texture>)object));
            }
        }
        return array;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string, FileHandle fileHandle, P p2) {
    }

    @Override
    public Model loadSync(AssetManager disposable, String string, FileHandle object, P object2) {
        object = null;
        object2 = this.items;
        synchronized (object2) {
            for (int i2 = 0; i2 < this.items.size; ++i2) {
                if (!((String)this.items.get((int)i2).key).equals(string)) continue;
                object = (ModelData)this.items.get((int)i2).value;
                this.items.removeIndex(i2);
            }
        }
        if (object == null) {
            return null;
        }
        object2 = new Model((ModelData)object, new TextureProvider$AssetTextureProvider((AssetManager)disposable));
        Iterator<Disposable> iterator = ((Model)object2).getManagedDisposables().iterator();
        while (iterator.hasNext()) {
            disposable = iterator.next();
            if (!(disposable instanceof Texture)) continue;
            iterator.remove();
        }
        return object2;
    }
}

