/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader$TextureLoaderInfo;
import com.badlogic.gdx.assets.loaders.TextureLoader$TextureParameter;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData$Factory;
import com.badlogic.gdx.utils.Array;

public class TextureLoader
extends AsynchronousAssetLoader<Texture, TextureLoader$TextureParameter> {
    TextureLoader$TextureLoaderInfo info = new TextureLoader$TextureLoaderInfo();

    public TextureLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public void loadAsync(AssetManager object, String string, FileHandle fileHandle, TextureLoader$TextureParameter textureLoader$TextureParameter) {
        this.info.filename = string;
        if (textureLoader$TextureParameter == null || textureLoader$TextureParameter.textureData == null) {
            object = null;
            boolean bl = false;
            this.info.texture = null;
            if (textureLoader$TextureParameter != null) {
                object = textureLoader$TextureParameter.format;
                bl = textureLoader$TextureParameter.genMipMaps;
                this.info.texture = textureLoader$TextureParameter.texture;
            }
            this.info.data = TextureData$Factory.loadFromFile(fileHandle, (Pixmap$Format)((Object)object), bl);
        } else {
            this.info.data = textureLoader$TextureParameter.textureData;
            this.info.texture = textureLoader$TextureParameter.texture;
        }
        if (!this.info.data.isPrepared()) {
            this.info.data.prepare();
        }
    }

    @Override
    public Texture loadSync(AssetManager disposable, String string, FileHandle fileHandle, TextureLoader$TextureParameter textureLoader$TextureParameter) {
        if (this.info == null) {
            return null;
        }
        disposable = this.info.texture;
        if (disposable != null) {
            ((Texture)disposable).load(this.info.data);
        } else {
            disposable = new Texture(this.info.data);
        }
        if (textureLoader$TextureParameter != null) {
            ((GLTexture)disposable).setFilter(textureLoader$TextureParameter.minFilter, textureLoader$TextureParameter.magFilter);
            ((GLTexture)disposable).setWrap(textureLoader$TextureParameter.wrapU, textureLoader$TextureParameter.wrapV);
        }
        return disposable;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String string, FileHandle fileHandle, TextureLoader$TextureParameter textureLoader$TextureParameter) {
        return null;
    }
}

