/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.Files$FileType;
import com.badlogic.gdx.Graphics$DisplayMode;
import com.badlogic.gdx.Graphics$Monitor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration$GLEmulation;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics$Lwjgl3DisplayMode;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics$Lwjgl3Monitor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowConfiguration;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.math.GridPoint2;
import java.io.PrintStream;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWVidMode$Buffer;

public class Lwjgl3ApplicationConfiguration
extends Lwjgl3WindowConfiguration {
    public static PrintStream errorStream = System.err;
    boolean disableAudio = false;
    int maxNetThreads = Integer.MAX_VALUE;
    int audioDeviceSimultaneousSources = 16;
    int audioDeviceBufferSize = 512;
    int audioDeviceBufferCount = 9;
    Lwjgl3ApplicationConfiguration$GLEmulation glEmulation = Lwjgl3ApplicationConfiguration$GLEmulation.GL20;
    int gles30ContextMajorVersion = 3;
    int gles30ContextMinorVersion = 2;
    int r = 8;
    int g = 8;
    int b = 8;
    int a = 8;
    int depth = 16;
    int stencil = 0;
    int samples = 0;
    boolean transparentFramebuffer;
    int idleFPS = 60;
    int foregroundFPS = 0;
    boolean pauseWhenMinimized = true;
    boolean pauseWhenLostFocus = false;
    String preferencesDirectory = ".prefs/";
    Files$FileType preferencesFileType = Files$FileType.External;
    HdpiMode hdpiMode = HdpiMode.Logical;
    boolean debug = false;
    PrintStream debugStream = System.err;

    static Lwjgl3ApplicationConfiguration copy(Lwjgl3ApplicationConfiguration lwjgl3ApplicationConfiguration) {
        Lwjgl3ApplicationConfiguration lwjgl3ApplicationConfiguration2 = new Lwjgl3ApplicationConfiguration();
        lwjgl3ApplicationConfiguration2.set(lwjgl3ApplicationConfiguration);
        return lwjgl3ApplicationConfiguration2;
    }

    void set(Lwjgl3ApplicationConfiguration lwjgl3ApplicationConfiguration) {
        super.setWindowConfiguration(lwjgl3ApplicationConfiguration);
        this.disableAudio = lwjgl3ApplicationConfiguration.disableAudio;
        this.audioDeviceSimultaneousSources = lwjgl3ApplicationConfiguration.audioDeviceSimultaneousSources;
        this.audioDeviceBufferSize = lwjgl3ApplicationConfiguration.audioDeviceBufferSize;
        this.audioDeviceBufferCount = lwjgl3ApplicationConfiguration.audioDeviceBufferCount;
        this.glEmulation = lwjgl3ApplicationConfiguration.glEmulation;
        this.gles30ContextMajorVersion = lwjgl3ApplicationConfiguration.gles30ContextMajorVersion;
        this.gles30ContextMinorVersion = lwjgl3ApplicationConfiguration.gles30ContextMinorVersion;
        this.r = lwjgl3ApplicationConfiguration.r;
        this.g = lwjgl3ApplicationConfiguration.g;
        this.b = lwjgl3ApplicationConfiguration.b;
        this.a = lwjgl3ApplicationConfiguration.a;
        this.depth = lwjgl3ApplicationConfiguration.depth;
        this.stencil = lwjgl3ApplicationConfiguration.stencil;
        this.samples = lwjgl3ApplicationConfiguration.samples;
        this.transparentFramebuffer = lwjgl3ApplicationConfiguration.transparentFramebuffer;
        this.idleFPS = lwjgl3ApplicationConfiguration.idleFPS;
        this.foregroundFPS = lwjgl3ApplicationConfiguration.foregroundFPS;
        this.pauseWhenMinimized = lwjgl3ApplicationConfiguration.pauseWhenMinimized;
        this.pauseWhenLostFocus = lwjgl3ApplicationConfiguration.pauseWhenLostFocus;
        this.preferencesDirectory = lwjgl3ApplicationConfiguration.preferencesDirectory;
        this.preferencesFileType = lwjgl3ApplicationConfiguration.preferencesFileType;
        this.hdpiMode = lwjgl3ApplicationConfiguration.hdpiMode;
        this.debug = lwjgl3ApplicationConfiguration.debug;
        this.debugStream = lwjgl3ApplicationConfiguration.debugStream;
    }

    @Override
    public void setInitialVisible(boolean bl) {
        this.initialVisible = bl;
    }

    public void disableAudio(boolean bl) {
        this.disableAudio = bl;
    }

    public void setMaxNetThreads(int n2) {
        this.maxNetThreads = n2;
    }

    public void setAudioConfig(int n2, int n3, int n4) {
        this.audioDeviceSimultaneousSources = n2;
        this.audioDeviceBufferSize = n3;
        this.audioDeviceBufferCount = n4;
    }

    public void setOpenGLEmulation(Lwjgl3ApplicationConfiguration$GLEmulation lwjgl3ApplicationConfiguration$GLEmulation, int n2, int n3) {
        this.glEmulation = lwjgl3ApplicationConfiguration$GLEmulation;
        this.gles30ContextMajorVersion = n2;
        this.gles30ContextMinorVersion = n3;
    }

    public void setBackBufferConfig(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.r = n2;
        this.g = n3;
        this.b = n4;
        this.a = n5;
        this.depth = n6;
        this.stencil = n7;
        this.samples = n8;
    }

    public void setTransparentFramebuffer(boolean bl) {
        this.transparentFramebuffer = bl;
    }

    public void setIdleFPS(int n2) {
        this.idleFPS = n2;
    }

    public void setForegroundFPS(int n2) {
        this.foregroundFPS = n2;
    }

    public void setPauseWhenMinimized(boolean bl) {
        this.pauseWhenMinimized = bl;
    }

    public void setPauseWhenLostFocus(boolean bl) {
        this.pauseWhenLostFocus = bl;
    }

    public void setPreferencesConfig(String string, Files$FileType files$FileType) {
        this.preferencesDirectory = string;
        this.preferencesFileType = files$FileType;
    }

    public void setHdpiMode(HdpiMode hdpiMode) {
        this.hdpiMode = hdpiMode;
    }

    public void enableGLDebugOutput(boolean bl, PrintStream printStream) {
        this.debug = bl;
        this.debugStream = printStream;
    }

    public static Graphics$DisplayMode getDisplayMode() {
        Lwjgl3Application.initializeGlfw();
        GLFWVidMode gLFWVidMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        return new Lwjgl3Graphics$Lwjgl3DisplayMode(GLFW.glfwGetPrimaryMonitor(), gLFWVidMode.width(), gLFWVidMode.height(), gLFWVidMode.refreshRate(), gLFWVidMode.redBits() + gLFWVidMode.greenBits() + gLFWVidMode.blueBits());
    }

    public static Graphics$DisplayMode getDisplayMode(Graphics$Monitor graphics$Monitor) {
        Lwjgl3Application.initializeGlfw();
        GLFWVidMode gLFWVidMode = GLFW.glfwGetVideoMode(((Lwjgl3Graphics$Lwjgl3Monitor)graphics$Monitor).monitorHandle);
        return new Lwjgl3Graphics$Lwjgl3DisplayMode(((Lwjgl3Graphics$Lwjgl3Monitor)graphics$Monitor).monitorHandle, gLFWVidMode.width(), gLFWVidMode.height(), gLFWVidMode.refreshRate(), gLFWVidMode.redBits() + gLFWVidMode.greenBits() + gLFWVidMode.blueBits());
    }

    public static Graphics$DisplayMode[] getDisplayModes() {
        Lwjgl3Application.initializeGlfw();
        GLFWVidMode$Buffer gLFWVidMode$Buffer = GLFW.glfwGetVideoModes(GLFW.glfwGetPrimaryMonitor());
        Graphics$DisplayMode[] graphics$DisplayModeArray = new Graphics$DisplayMode[gLFWVidMode$Buffer.limit()];
        for (int i2 = 0; i2 < graphics$DisplayModeArray.length; ++i2) {
            GLFWVidMode gLFWVidMode = (GLFWVidMode)gLFWVidMode$Buffer.get(i2);
            graphics$DisplayModeArray[i2] = new Lwjgl3Graphics$Lwjgl3DisplayMode(GLFW.glfwGetPrimaryMonitor(), gLFWVidMode.width(), gLFWVidMode.height(), gLFWVidMode.refreshRate(), gLFWVidMode.redBits() + gLFWVidMode.greenBits() + gLFWVidMode.blueBits());
        }
        return graphics$DisplayModeArray;
    }

    public static Graphics$DisplayMode[] getDisplayModes(Graphics$Monitor graphics$Monitor) {
        Lwjgl3Application.initializeGlfw();
        GLFWVidMode$Buffer gLFWVidMode$Buffer = GLFW.glfwGetVideoModes(((Lwjgl3Graphics$Lwjgl3Monitor)graphics$Monitor).monitorHandle);
        Graphics$DisplayMode[] graphics$DisplayModeArray = new Graphics$DisplayMode[gLFWVidMode$Buffer.limit()];
        for (int i2 = 0; i2 < graphics$DisplayModeArray.length; ++i2) {
            GLFWVidMode gLFWVidMode = (GLFWVidMode)gLFWVidMode$Buffer.get(i2);
            graphics$DisplayModeArray[i2] = new Lwjgl3Graphics$Lwjgl3DisplayMode(((Lwjgl3Graphics$Lwjgl3Monitor)graphics$Monitor).monitorHandle, gLFWVidMode.width(), gLFWVidMode.height(), gLFWVidMode.refreshRate(), gLFWVidMode.redBits() + gLFWVidMode.greenBits() + gLFWVidMode.blueBits());
        }
        return graphics$DisplayModeArray;
    }

    public static Graphics$Monitor getPrimaryMonitor() {
        Lwjgl3Application.initializeGlfw();
        return Lwjgl3ApplicationConfiguration.toLwjgl3Monitor(GLFW.glfwGetPrimaryMonitor());
    }

    public static Graphics$Monitor[] getMonitors() {
        Lwjgl3Application.initializeGlfw();
        PointerBuffer pointerBuffer = GLFW.glfwGetMonitors();
        Graphics$Monitor[] graphics$MonitorArray = new Graphics$Monitor[pointerBuffer.limit()];
        for (int i2 = 0; i2 < pointerBuffer.limit(); ++i2) {
            graphics$MonitorArray[i2] = Lwjgl3ApplicationConfiguration.toLwjgl3Monitor(pointerBuffer.get(i2));
        }
        return graphics$MonitorArray;
    }

    static Lwjgl3Graphics$Lwjgl3Monitor toLwjgl3Monitor(long l2) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        IntBuffer intBuffer2 = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetMonitorPos(l2, intBuffer, intBuffer2);
        int n2 = intBuffer.get(0);
        int n3 = intBuffer2.get(0);
        String string = GLFW.glfwGetMonitorName(l2);
        return new Lwjgl3Graphics$Lwjgl3Monitor(l2, n2, n3, string);
    }

    static GridPoint2 calculateCenteredWindowPosition(Lwjgl3Graphics$Lwjgl3Monitor lwjgl3Graphics$Lwjgl3Monitor, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
        IntBuffer intBuffer2 = BufferUtils.createIntBuffer(1);
        IntBuffer intBuffer3 = BufferUtils.createIntBuffer(1);
        IntBuffer intBuffer4 = BufferUtils.createIntBuffer(1);
        Graphics$DisplayMode graphics$DisplayMode = Lwjgl3ApplicationConfiguration.getDisplayMode(lwjgl3Graphics$Lwjgl3Monitor);
        GLFW.glfwGetMonitorWorkarea(lwjgl3Graphics$Lwjgl3Monitor.monitorHandle, intBuffer, intBuffer2, intBuffer3, intBuffer4);
        int n7 = intBuffer3.get(0);
        int n8 = intBuffer4.get(0);
        if (n2 > n7) {
            n6 = lwjgl3Graphics$Lwjgl3Monitor.virtualX;
            n7 = graphics$DisplayMode.width;
        } else {
            n6 = intBuffer.get(0);
        }
        if (n3 > n8) {
            n5 = lwjgl3Graphics$Lwjgl3Monitor.virtualY;
            n4 = graphics$DisplayMode.height;
        } else {
            n5 = intBuffer2.get(0);
            n4 = n8;
        }
        int n9 = n6;
        int n10 = n5;
        return new GridPoint2(Math.max(n9, n9 + (n7 - n2) / 2), Math.max(n10, n10 + (n4 - n3) / 2));
    }
}

