/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files$FileType;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationBase;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Cursor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Input;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window$1;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window$2;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window$3;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window$4;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window$5;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window$6;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowListener;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Blending;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWImage$Buffer;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowMaximizeCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.system.Struct;

public class Lwjgl3Window
implements Disposable {
    private long windowHandle;
    final ApplicationListener listener;
    private final Array<LifecycleListener> lifecycleListeners;
    final Lwjgl3ApplicationBase application;
    private boolean listenerInitialized = false;
    Lwjgl3WindowListener windowListener;
    private Lwjgl3Graphics graphics;
    private Lwjgl3Input input;
    private final Lwjgl3ApplicationConfiguration config;
    private final Array<Runnable> runnables = new Array();
    private final Array<Runnable> executedRunnables = new Array();
    private final IntBuffer tmpBuffer;
    private final IntBuffer tmpBuffer2;
    boolean iconified = false;
    boolean focused = false;
    boolean asyncResized = false;
    private boolean requestRendering = false;
    private final GLFWWindowFocusCallback focusCallback = new Lwjgl3Window$1(this);
    private final GLFWWindowIconifyCallback iconifyCallback = new Lwjgl3Window$2(this);
    private final GLFWWindowMaximizeCallback maximizeCallback = new Lwjgl3Window$3(this);
    private final GLFWWindowCloseCallback closeCallback = new Lwjgl3Window$4(this);
    private final GLFWDropCallback dropCallback = new Lwjgl3Window$5(this);
    private final GLFWWindowRefreshCallback refreshCallback = new Lwjgl3Window$6(this);

    Lwjgl3Window(ApplicationListener applicationListener, Array<LifecycleListener> array, Lwjgl3ApplicationConfiguration lwjgl3ApplicationConfiguration, Lwjgl3ApplicationBase lwjgl3ApplicationBase) {
        this.listener = applicationListener;
        this.lifecycleListeners = array;
        this.windowListener = lwjgl3ApplicationConfiguration.windowListener;
        this.config = lwjgl3ApplicationConfiguration;
        this.application = lwjgl3ApplicationBase;
        this.tmpBuffer = BufferUtils.createIntBuffer(1);
        this.tmpBuffer2 = BufferUtils.createIntBuffer(1);
    }

    void create(long l2) {
        this.windowHandle = l2;
        this.input = this.application.createInput(this);
        this.graphics = new Lwjgl3Graphics(this);
        GLFW.glfwSetWindowFocusCallback(l2, this.focusCallback);
        GLFW.glfwSetWindowIconifyCallback(l2, this.iconifyCallback);
        GLFW.glfwSetWindowMaximizeCallback(l2, this.maximizeCallback);
        GLFW.glfwSetWindowCloseCallback(l2, this.closeCallback);
        GLFW.glfwSetDropCallback(l2, this.dropCallback);
        GLFW.glfwSetWindowRefreshCallback(l2, this.refreshCallback);
        if (this.windowListener != null) {
            this.windowListener.created(this);
        }
    }

    public ApplicationListener getListener() {
        return this.listener;
    }

    public Lwjgl3WindowListener getWindowListener() {
        return this.windowListener;
    }

    public void setWindowListener(Lwjgl3WindowListener lwjgl3WindowListener) {
        this.windowListener = lwjgl3WindowListener;
    }

    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            return;
        }
    }

    public void setPosition(int n2, int n3) {
        GLFW.glfwSetWindowPos(this.windowHandle, n2, n3);
    }

    public int getPositionX() {
        GLFW.glfwGetWindowPos(this.windowHandle, this.tmpBuffer, this.tmpBuffer2);
        return this.tmpBuffer.get(0);
    }

    public int getPositionY() {
        GLFW.glfwGetWindowPos(this.windowHandle, this.tmpBuffer, this.tmpBuffer2);
        return this.tmpBuffer2.get(0);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            GLFW.glfwShowWindow(this.windowHandle);
            return;
        }
        GLFW.glfwHideWindow(this.windowHandle);
    }

    public void closeWindow() {
        GLFW.glfwSetWindowShouldClose(this.windowHandle, true);
    }

    public void iconifyWindow() {
        GLFW.glfwIconifyWindow(this.windowHandle);
    }

    public boolean isIconified() {
        return this.iconified;
    }

    public void restoreWindow() {
        GLFW.glfwRestoreWindow(this.windowHandle);
    }

    public void maximizeWindow() {
        GLFW.glfwMaximizeWindow(this.windowHandle);
    }

    public void focusWindow() {
        GLFW.glfwFocusWindow(this.windowHandle);
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setIcon(Pixmap ... pixmapArray) {
        Lwjgl3Window.setIcon(this.windowHandle, pixmapArray);
    }

    static void setIcon(long l2, String[] object, Files$FileType files$FileType) {
        if (SharedLibraryLoader.os == Os.MacOsX) {
            return;
        }
        Pixmap[] pixmapArray = new Pixmap[((String[])object).length];
        for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
            pixmapArray[i2] = new Pixmap(Gdx.files.getFileHandle(object[i2], files$FileType));
        }
        Lwjgl3Window.setIcon(l2, pixmapArray);
        Pixmap[] pixmapArray2 = pixmapArray;
        int n2 = pixmapArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            object = pixmapArray2[i3];
            object.dispose();
        }
    }

    static void setIcon(long l2, Pixmap[] pixmapArray) {
        if (SharedLibraryLoader.os == Os.MacOsX) {
            return;
        }
        GLFWImage$Buffer gLFWImage$Buffer = GLFWImage.malloc(pixmapArray.length);
        Pixmap[] pixmapArray2 = new Pixmap[pixmapArray.length];
        for (int i2 = 0; i2 < pixmapArray.length; ++i2) {
            Object object;
            Object object2 = pixmapArray[i2];
            if (((Pixmap)object2).getFormat() != Pixmap$Format.RGBA8888) {
                object = new Pixmap(((Pixmap)object2).getWidth(), ((Pixmap)object2).getHeight(), Pixmap$Format.RGBA8888);
                ((Pixmap)object).setBlending(Pixmap$Blending.None);
                ((Pixmap)object).drawPixmap((Pixmap)object2, 0, 0);
                pixmapArray2[i2] = object;
                object2 = object;
            }
            object = GLFWImage.malloc();
            ((GLFWImage)object).set(((Pixmap)object2).getWidth(), ((Pixmap)object2).getHeight(), ((Pixmap)object2).getPixels());
            gLFWImage$Buffer.put(object);
            ((Struct)object).free();
        }
        gLFWImage$Buffer.position(0);
        GLFW.glfwSetWindowIcon(l2, gLFWImage$Buffer);
        gLFWImage$Buffer.free();
        Pixmap[] pixmapArray3 = pixmapArray2;
        int n2 = pixmapArray2.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            Pixmap pixmap = pixmapArray3[i3];
            if (pixmap == null) continue;
            pixmap.dispose();
        }
    }

    public void setTitle(CharSequence charSequence) {
        GLFW.glfwSetWindowTitle(this.windowHandle, charSequence);
    }

    public void setSizeLimits(int n2, int n3, int n4, int n5) {
        Lwjgl3Window.setSizeLimits(this.windowHandle, n2, n3, n4, n5);
    }

    static void setSizeLimits(long l2, int n2, int n3, int n4, int n5) {
        GLFW.glfwSetWindowSizeLimits(l2, n2 >= 0 ? n2 : -1, n3 >= 0 ? n3 : -1, n4 >= 0 ? n4 : -1, n5 >= 0 ? n5 : -1);
    }

    Lwjgl3Graphics getGraphics() {
        return this.graphics;
    }

    Lwjgl3Input getInput() {
        return this.input;
    }

    public long getWindowHandle() {
        return this.windowHandle;
    }

    void windowHandleChanged(long l2) {
        this.windowHandle = l2;
        this.input.windowHandleChanged(l2);
    }

    boolean update() {
        if (!this.listenerInitialized) {
            this.initializeListener();
        }
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.executedRunnables.addAll(this.runnables);
            this.runnables.clear();
        }
        for (Runnable object2 : this.executedRunnables) {
            object2.run();
        }
        boolean bl = this.executedRunnables.size > 0 || this.graphics.isContinuousRendering();
        this.executedRunnables.clear();
        if (!this.iconified) {
            this.input.update();
        }
        Lwjgl3Window lwjgl3Window = this;
        synchronized (lwjgl3Window) {
            bl |= this.requestRendering && !this.iconified;
            this.requestRendering = false;
        }
        if (this.asyncResized) {
            this.asyncResized = false;
            this.graphics.updateFramebufferInfo();
            this.graphics.gl20.glViewport(0, 0, this.graphics.getBackBufferWidth(), this.graphics.getBackBufferHeight());
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
            this.graphics.update();
            this.listener.render();
            GLFW.glfwSwapBuffers(this.windowHandle);
            return true;
        }
        if (bl) {
            this.graphics.update();
            this.listener.render();
            GLFW.glfwSwapBuffers(this.windowHandle);
        }
        if (!this.iconified) {
            this.input.prepareNext();
        }
        return bl;
    }

    void requestRendering() {
        Lwjgl3Window lwjgl3Window = this;
        synchronized (lwjgl3Window) {
            this.requestRendering = true;
            return;
        }
    }

    boolean shouldClose() {
        return GLFW.glfwWindowShouldClose(this.windowHandle);
    }

    Lwjgl3ApplicationConfiguration getConfig() {
        return this.config;
    }

    boolean isListenerInitialized() {
        return this.listenerInitialized;
    }

    void initializeListener() {
        if (!this.listenerInitialized) {
            this.listener.create();
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
            this.listenerInitialized = true;
        }
    }

    void makeCurrent() {
        Gdx.graphics = this.graphics;
        Gdx.gl32 = this.graphics.getGL32();
        Gdx.gl31 = Gdx.gl32 != null ? Gdx.gl32 : this.graphics.getGL31();
        Gdx.gl30 = Gdx.gl31 != null ? Gdx.gl31 : this.graphics.getGL30();
        Gdx.gl20 = Gdx.gl30 != null ? Gdx.gl30 : this.graphics.getGL20();
        Gdx.gl = Gdx.gl20;
        Gdx.input = this.input;
        GLFW.glfwMakeContextCurrent(this.windowHandle);
    }

    @Override
    public void dispose() {
        this.listener.pause();
        this.listener.dispose();
        Lwjgl3Cursor.dispose(this);
        this.graphics.dispose();
        this.input.dispose();
        GLFW.glfwSetWindowFocusCallback(this.windowHandle, null);
        GLFW.glfwSetWindowIconifyCallback(this.windowHandle, null);
        GLFW.glfwSetWindowCloseCallback(this.windowHandle, null);
        GLFW.glfwSetDropCallback(this.windowHandle, null);
        GLFW.glfwDestroyWindow(this.windowHandle);
        this.focusCallback.free();
        this.iconifyCallback.free();
        this.maximizeCallback.free();
        this.closeCallback.free();
        this.dropCallback.free();
        this.refreshCallback.free();
    }

    public int hashCode() {
        int n2 = 31 + (int)(this.windowHandle ^ this.windowHandle >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Lwjgl3Window)object;
        return this.windowHandle == ((Lwjgl3Window)object).windowHandle;
    }

    public void flash() {
        GLFW.glfwRequestWindowAttention(this.windowHandle);
    }

    static /* synthetic */ Lwjgl3ApplicationConfiguration access$000(Lwjgl3Window lwjgl3Window) {
        return lwjgl3Window.config;
    }

    static /* synthetic */ Array access$100(Lwjgl3Window lwjgl3Window) {
        return lwjgl3Window.lifecycleListeners;
    }
}

