/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.backends.lwjgl3.Sync$1;
import com.badlogic.gdx.backends.lwjgl3.Sync$RunningAvg;
import org.lwjgl.glfw.GLFW;

class Sync {
    private static final long NANOS_IN_SECOND = 1000000000L;
    private long nextFrame = 0L;
    private boolean initialised = false;
    private Sync$RunningAvg sleepDurations = new Sync$RunningAvg(this, 10);
    private Sync$RunningAvg yieldDurations = new Sync$RunningAvg(this, 10);

    public void sync(int n2) {
        if (n2 <= 0) {
            return;
        }
        if (!this.initialised) {
            this.initialise();
        }
        try {
            long l2;
            long l3 = this.getTime();
            while (this.nextFrame - l3 > this.sleepDurations.avg()) {
                Thread.sleep(1L);
                l2 = this.getTime();
                this.sleepDurations.add(l2 - l3);
                l3 = l2;
            }
            this.sleepDurations.dampenForLowResTicker();
            l3 = this.getTime();
            while (this.nextFrame - l3 > this.yieldDurations.avg()) {
                Thread.yield();
                l2 = this.getTime();
                this.yieldDurations.add(l2 - l3);
                l3 = l2;
            }
        }
        catch (InterruptedException interruptedException) {}
        this.nextFrame = Math.max(this.nextFrame + 1000000000L / (long)n2, this.getTime());
    }

    private void initialise() {
        this.initialised = true;
        this.sleepDurations.init(1000000L);
        this.yieldDurations.init((int)((double)(-(this.getTime() - this.getTime())) * 1.333));
        this.nextFrame = this.getTime();
        Object object = System.getProperty("os.name");
        if (((String)object).startsWith("Win")) {
            object = new Thread(new Sync$1(this));
            ((Thread)object).setName("LWJGL3 Timer");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }
    }

    private long getTime() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }
}

