/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.backends.lwjgl3.audio.OpenALLwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALMusic;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.MP3Decoder;
import javazoom.jl.decoder.OutputBuffer;

public class Mp3$Music
extends OpenALMusic {
    private Bitstream bitstream;
    private OutputBuffer outputBuffer;
    private MP3Decoder decoder;

    public Mp3$Music(OpenALLwjgl3Audio object, FileHandle fileHandle) {
        super((OpenALLwjgl3Audio)object, fileHandle);
        if (((OpenALLwjgl3Audio)object).noDevice) {
            return;
        }
        this.bitstream = new Bitstream(fileHandle.read());
        this.decoder = new MP3Decoder();
        try {
            object = this.bitstream.readFrame();
            if (object == null) {
                throw new GdxRuntimeException("Empty MP3");
            }
            int n2 = ((Header)object).mode() == 3 ? 1 : 2;
            this.outputBuffer = new OutputBuffer(n2, false);
            this.decoder.setOutputBuffer(this.outputBuffer);
            this.setup(n2, 16, ((Header)object).getSampleRate());
            return;
        }
        catch (BitstreamException bitstreamException) {
            throw new GdxRuntimeException("Error while preloading MP3", bitstreamException);
        }
    }

    @Override
    public int read(byte[] byArray) {
        try {
            Header header;
            int n2;
            int n3;
            boolean bl = this.bitstream == null;
            if (bl) {
                this.bitstream = new Bitstream(this.file.read());
                this.decoder = new MP3Decoder();
            }
            int n4 = byArray.length - 4608;
            for (n2 = 0; n2 <= n4 && (header = this.bitstream.readFrame()) != null; n2 += n3) {
                if (bl) {
                    n3 = header.mode() == 3 ? 1 : 2;
                    this.outputBuffer = new OutputBuffer(n3, false);
                    this.decoder.setOutputBuffer(this.outputBuffer);
                    this.setup(n3, 16, header.getSampleRate());
                    bl = false;
                }
                try {
                    this.decoder.decodeFrame(header, this.bitstream);
                }
                catch (Exception exception) {}
                this.bitstream.closeFrame();
                n3 = this.outputBuffer.reset();
                System.arraycopy(this.outputBuffer.getBuffer(), 0, byArray, n2, n3);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ((OpenALMusic)this).reset();
            throw new GdxRuntimeException("Error reading audio data.", throwable);
        }
    }

    @Override
    public void reset() {
        if (this.bitstream == null) {
            return;
        }
        try {
            this.bitstream.close();
        }
        catch (BitstreamException bitstreamException) {}
        this.bitstream = null;
    }
}

