/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.BufferUtils;

public class OggInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 512;
    private int convsize = 2048;
    private byte[] convbuffer;
    private InputStream input;
    private Info oggInfo = new Info();
    private boolean endOfStream;
    private SyncState syncState = new SyncState();
    private StreamState streamState = new StreamState();
    private Page page = new Page();
    private Packet packet = new Packet();
    private Comment comment = new Comment();
    private DspState dspState = new DspState();
    private Block vorbisBlock = new Block(this.dspState);
    byte[] buffer;
    int bytes = 0;
    boolean bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    boolean endOfBitStream = true;
    boolean inited = false;
    private int readIndex;
    private ByteBuffer pcmBuffer;
    private int total;

    public OggInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public OggInputStream(InputStream inputStream, OggInputStream oggInputStream) {
        if (oggInputStream == null) {
            this.convbuffer = new byte[this.convsize];
            this.pcmBuffer = BufferUtils.createByteBuffer(2048000);
        } else {
            this.convbuffer = oggInputStream.convbuffer;
            this.pcmBuffer = oggInputStream.pcmBuffer;
        }
        this.input = inputStream;
        try {
            this.total = inputStream.available();
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException(iOException);
        }
        this.init();
    }

    public int getLength() {
        return this.total;
    }

    public int getChannels() {
        return this.oggInfo.channels;
    }

    public int getSampleRate() {
        return this.oggInfo.rate;
    }

    private void init() {
        this.initVorbis();
        this.readPCM();
    }

    @Override
    public int available() {
        if (this.endOfStream) {
            return 0;
        }
        return 1;
    }

    private void initVorbis() {
        this.syncState.init();
    }

    private boolean getPageAndPacket() {
        int n2 = this.syncState.buffer(512);
        if (n2 == -1) {
            return false;
        }
        this.buffer = this.syncState.data;
        if (this.buffer == null) {
            this.endOfStream = true;
            return false;
        }
        try {
            this.bytes = this.input.read(this.buffer, n2, 512);
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Failure reading Vorbis.", exception);
        }
        this.syncState.wrote(this.bytes);
        if (this.syncState.pageout(this.page) != 1) {
            if (this.bytes < 512) {
                return false;
            }
            throw new GdxRuntimeException("Input does not appear to be an Ogg bitstream.");
        }
        this.streamState.init(this.page.serialno());
        this.oggInfo.init();
        this.comment.init();
        if (this.streamState.pagein(this.page) < 0) {
            throw new GdxRuntimeException("Error reading first page of Ogg bitstream.");
        }
        if (this.streamState.packetout(this.packet) != 1) {
            throw new GdxRuntimeException("Error reading initial header packet.");
        }
        if (this.oggInfo.synthesis_headerin(this.comment, this.packet) < 0) {
            throw new GdxRuntimeException("Ogg bitstream does not contain Vorbis audio data.");
        }
        int n3 = 0;
        while (n3 < 2) {
            while (n3 < 2 && (n2 = this.syncState.pageout(this.page)) != 0) {
                if (n2 != 1) continue;
                this.streamState.pagein(this.page);
                while (n3 < 2 && (n2 = this.streamState.packetout(this.packet)) != 0) {
                    if (n2 == -1) {
                        throw new GdxRuntimeException("Corrupt secondary header.");
                    }
                    this.oggInfo.synthesis_headerin(this.comment, this.packet);
                    ++n3;
                }
            }
            n2 = this.syncState.buffer(512);
            if (n2 == -1) {
                return false;
            }
            this.buffer = this.syncState.data;
            try {
                this.bytes = this.input.read(this.buffer, n2, 512);
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Failed to read Vorbis.", exception);
            }
            if (this.bytes == 0 && n3 < 2) {
                throw new GdxRuntimeException("End of file before finding all Vorbis headers.");
            }
            this.syncState.wrote(this.bytes);
        }
        this.convsize = 512 / this.oggInfo.channels;
        this.dspState.synthesis_init(this.oggInfo);
        this.vorbisBlock.init(this.dspState);
        return true;
    }

    private void readPCM() {
        boolean bl = false;
        while (true) {
            if (this.endOfBitStream) {
                if (!this.getPageAndPacket()) break;
                this.endOfBitStream = false;
            }
            if (!this.inited) {
                this.inited = true;
                return;
            }
            float[][][] fArrayArray = new float[1][][];
            int[] nArray = new int[this.oggInfo.channels];
            while (!this.endOfBitStream) {
                int n2;
                while (!this.endOfBitStream && (n2 = this.syncState.pageout(this.page)) != 0) {
                    if (n2 == -1) {
                        Gdx.app.error("gdx-audio", "Error reading OGG: Corrupt or missing data in bitstream.");
                        continue;
                    }
                    this.streamState.pagein(this.page);
                    while ((n2 = this.streamState.packetout(this.packet)) != 0) {
                        if (n2 == -1) continue;
                        if (this.vorbisBlock.synthesis(this.packet) == 0) {
                            this.dspState.synthesis_blockin(this.vorbisBlock);
                        }
                        while ((n2 = this.dspState.synthesis_pcmout(fArrayArray, nArray)) > 0) {
                            int n3;
                            float[][] fArray = fArrayArray[0];
                            n2 = n2 < this.convsize ? n2 : this.convsize;
                            for (n3 = 0; n3 < this.oggInfo.channels; ++n3) {
                                int n4 = n3 << 1;
                                int n5 = nArray[n3];
                                for (int i2 = 0; i2 < n2; ++i2) {
                                    int n6 = (int)((double)fArray[n3][n5 + i2] * 32767.0);
                                    if (n6 > Short.MAX_VALUE) {
                                        n6 = Short.MAX_VALUE;
                                    }
                                    if (n6 < Short.MIN_VALUE) {
                                        n6 = Short.MIN_VALUE;
                                    }
                                    if (n6 < 0) {
                                        n6 |= 0x8000;
                                    }
                                    if (this.bigEndian) {
                                        this.convbuffer[n4] = (byte)(n6 >>> 8);
                                        this.convbuffer[n4 + 1] = (byte)n6;
                                    } else {
                                        this.convbuffer[n4] = (byte)n6;
                                        this.convbuffer[n4 + 1] = (byte)(n6 >>> 8);
                                    }
                                    n4 += 2 * this.oggInfo.channels;
                                }
                            }
                            n3 = 2 * this.oggInfo.channels * n2;
                            if (n3 > this.pcmBuffer.remaining()) {
                                throw new GdxRuntimeException("Ogg block too big to be buffered: " + n3 + " :: " + this.pcmBuffer.remaining());
                            }
                            this.pcmBuffer.put(this.convbuffer, 0, n3);
                            bl = true;
                            this.dspState.synthesis_read(n2);
                        }
                    }
                    if (this.page.eos() != 0) {
                        this.endOfBitStream = true;
                    }
                    if (this.endOfBitStream || !bl) continue;
                    return;
                }
                if (this.endOfBitStream) continue;
                this.bytes = 0;
                n2 = this.syncState.buffer(512);
                if (n2 >= 0) {
                    this.buffer = this.syncState.data;
                    try {
                        this.bytes = this.input.read(this.buffer, n2, 512);
                    }
                    catch (Exception exception) {
                        throw new GdxRuntimeException("Error during Vorbis decoding.", exception);
                    }
                } else {
                    this.bytes = 0;
                }
                this.syncState.wrote(this.bytes);
                if (this.bytes != 0) continue;
                this.endOfBitStream = true;
            }
            this.streamState.clear();
            this.vorbisBlock.clear();
            this.dspState.clear();
            this.oggInfo.clear();
        }
        this.syncState.clear();
        this.endOfStream = true;
    }

    @Override
    public int read() {
        if (this.readIndex >= this.pcmBuffer.position()) {
            ((Buffer)this.pcmBuffer).clear();
            this.readPCM();
            this.readIndex = 0;
        }
        if (this.readIndex >= this.pcmBuffer.position()) {
            return -1;
        }
        int n2 = this.pcmBuffer.get(this.readIndex);
        if (n2 < 0) {
            n2 += 256;
        }
        ++this.readIndex;
        return n2;
    }

    public boolean atEnd() {
        return this.endOfStream && this.readIndex >= this.pcmBuffer.position();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = this.read();
            if (n4 < 0) {
                if (n2 == 0) {
                    return -1;
                }
                return n2;
            }
            byArray[n2] = (byte)n4;
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public void close() {
        StreamUtils.closeQuietly(this.input);
    }
}

