/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;

public class Wav$WavInputStream
extends FilterInputStream {
    public int channels;
    public int bitDepth;
    public int sampleRate;
    public int dataRemaining;
    public int type;

    public Wav$WavInputStream(FileHandle fileHandle) {
        super(fileHandle.read());
        try {
            if (this.read() != 82 || this.read() != 73 || this.read() != 70 || this.read() != 70) {
                throw new GdxRuntimeException("RIFF header not found: " + fileHandle);
            }
            this.skipFully(4);
            if (this.read() != 87 || this.read() != 65 || this.read() != 86 || this.read() != 69) {
                throw new GdxRuntimeException("Invalid wave file header: " + fileHandle);
            }
            int n2 = this.seekToChunk('f', 'm', 't', ' ');
            this.type = this.read() & 0xFF | (this.read() & 0xFF) << 8;
            if (this.type == 85) {
                return;
            }
            if (this.type != 1 && this.type != 3) {
                Wav$WavInputStream wav$WavInputStream = this;
                throw new GdxRuntimeException("WAV files must be PCM, unsupported format: " + wav$WavInputStream.getCodecName(wav$WavInputStream.type) + " (" + this.type + ")");
            }
            this.channels = this.read() & 0xFF | (this.read() & 0xFF) << 8;
            this.sampleRate = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
            this.skipFully(6);
            this.bitDepth = this.read() & 0xFF | (this.read() & 0xFF) << 8;
            if (this.type == 1) {
                if (this.bitDepth != 8 && this.bitDepth != 16) {
                    throw new GdxRuntimeException("PCM WAV files must be 8 or 16-bit: " + this.bitDepth);
                }
            } else if (this.type == 3 && this.bitDepth != 32 && this.bitDepth != 64) {
                throw new GdxRuntimeException("Floating-point WAV files must be 32 or 64-bit: " + this.bitDepth);
            }
            this.skipFully(n2 - 16);
            this.dataRemaining = this.seekToChunk('d', 'a', 't', 'a');
            return;
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(this);
            throw new GdxRuntimeException("Error reading WAV file: " + fileHandle, throwable);
        }
    }

    private int seekToChunk(char c2, char c3, char c4, char c5) {
        while (true) {
            boolean bl = this.read() == c2;
            bl = bl & this.read() == c3;
            bl &= this.read() == c4;
            bl &= this.read() == c5;
            int n2 = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
            if (n2 == -1) {
                throw new IOException("Chunk not found: " + c2 + c3 + c4 + c5);
            }
            if (bl) {
                return n2;
            }
            this.skipFully(n2);
        }
    }

    private void skipFully(int n2) {
        while (n2 > 0) {
            long l2 = this.in.skip(n2);
            if (l2 <= 0L) {
                throw new EOFException("Unable to skip.");
            }
            n2 = (int)((long)n2 - l2);
        }
    }

    @Override
    public int read(byte[] byArray) {
        int n2;
        if (this.dataRemaining == 0) {
            return -1;
        }
        int n3 = 0;
        do {
            if ((n2 = Math.min(super.read(byArray, n3, byArray.length - n3), this.dataRemaining)) == -1) {
                if (n3 > 0) {
                    return n3;
                }
                return -1;
            }
            this.dataRemaining -= n2;
        } while ((n3 += n2) < byArray.length);
        return n3;
    }

    private String getCodecName(int n2) {
        switch (n2) {
            case 2: {
                return "Microsoft ADPCM";
            }
            case 6: {
                return "ITU-T G.711 A-law";
            }
            case 7: {
                return "ITU-T G.711 u-law";
            }
            case 17: {
                return "IMA ADPCM";
            }
            case 34: {
                return "DSP Group TrueSpeech";
            }
            case 49: {
                return "Microsoft GSM 6.10";
            }
            case 64: {
                return "Antex G.721 ADPCM";
            }
            case 112: {
                return "Lernout & Hauspie CELP 4.8kbps";
            }
            case 114: {
                return "Lernout & Hauspie CBS 12kbps";
            }
            case 65534: {
                return "Extensible";
            }
        }
        return "Unknown";
    }
}

