/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;

abstract class AbstractController
implements Controller,
Disposable {
    private final Array<ControllerListener> listeners = new Array();
    private boolean connected = true;

    AbstractController() {
    }

    @Override
    public void dispose() {
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            this.listeners.clear();
        }
        this.connected = false;
    }

    protected void notifyListenersButtonUp(int n2) {
        Object object = Controllers.getListeners();
        Array<ControllerListener> array = object;
        synchronized (object) {
            ControllerListener controllerListener;
            object = ((Array)object).iterator();
            while (object.hasNext() && !(controllerListener = (ControllerListener)object.next()).buttonUp(this, n2)) {
            }
            // ** MonitorExit[var3_5] (shouldn't be in output)
            array = this.listeners;
            synchronized (array) {
                object = this.listeners.iterator();
                while (object.hasNext() && !(controllerListener = (ControllerListener)object.next()).buttonUp(this, n2)) {
                }
                return;
            }
        }
    }

    protected void notifyListenersButtonDown(int n2) {
        Object object = Controllers.getListeners();
        Array<ControllerListener> array = object;
        synchronized (object) {
            ControllerListener controllerListener;
            object = ((Array)object).iterator();
            while (object.hasNext() && !(controllerListener = (ControllerListener)object.next()).buttonDown(this, n2)) {
            }
            // ** MonitorExit[var3_5] (shouldn't be in output)
            array = this.listeners;
            synchronized (array) {
                object = this.listeners.iterator();
                while (object.hasNext() && !(controllerListener = (ControllerListener)object.next()).buttonDown(this, n2)) {
                }
                return;
            }
        }
    }

    protected void notifyListenersAxisMoved(int n2, float f2) {
        Object object = Controllers.getListeners();
        Array<ControllerListener> array = object;
        synchronized (object) {
            ControllerListener controllerListener;
            object = ((Array)object).iterator();
            while (object.hasNext() && !(controllerListener = (ControllerListener)object.next()).axisMoved(this, n2, f2)) {
            }
            // ** MonitorExit[var4_6] (shouldn't be in output)
            array = this.listeners;
            synchronized (array) {
                object = this.listeners.iterator();
                while (object.hasNext() && !(controllerListener = (ControllerListener)object.next()).axisMoved(this, n2, f2)) {
                }
                return;
            }
        }
    }

    @Override
    public void addListener(ControllerListener controllerListener) {
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            if (!this.listeners.contains(controllerListener, true)) {
                this.listeners.add(controllerListener);
            }
            return;
        }
    }

    @Override
    public void removeListener(ControllerListener controllerListener) {
        Array<ControllerListener> array = this.listeners;
        synchronized (array) {
            this.listeners.removeValue(controllerListener, true);
            return;
        }
    }

    @Override
    public boolean canVibrate() {
        return false;
    }

    @Override
    public boolean isVibrating() {
        return false;
    }

    @Override
    public void startVibration(int n2, float f2) {
    }

    @Override
    public void cancelVibration() {
    }

    @Override
    public boolean supportsPlayerIndex() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public int getPlayerIndex() {
        return -1;
    }

    @Override
    public void setPlayerIndex(int n2) {
    }
}

