/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Application$ApplicationType;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.ControllerManager;
import com.badlogic.gdx.controllers.ControllerManagerStub;
import com.badlogic.gdx.controllers.Controllers$1;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.reflect.ClassReflection;

public class Controllers {
    private static final String TAG = "Controllers";
    static final ObjectMap<Application, ControllerManager> managers = new ObjectMap();
    public static String preferredManager = null;

    public static Array<Controller> getControllers() {
        Controllers.initialize();
        return Controllers.getManager().getControllers();
    }

    public static Controller getCurrent() {
        Controllers.initialize();
        return Controllers.getManager().getCurrentController();
    }

    public static void addListener(ControllerListener controllerListener) {
        Controllers.initialize();
        Controllers.getManager().addListener(controllerListener);
    }

    public static void removeListener(ControllerListener controllerListener) {
        Controllers.initialize();
        Controllers.getManager().removeListener(controllerListener);
    }

    public static void clearListeners() {
        Controllers.initialize();
        Controllers.getManager().clearListeners();
    }

    public static Array<ControllerListener> getListeners() {
        Controllers.initialize();
        return Controllers.getManager().getListeners();
    }

    private static ControllerManager getManager() {
        return managers.get(Gdx.app);
    }

    private static void initialize() {
        if (managers.containsKey(Gdx.app)) {
            return;
        }
        String string = null;
        Object object = Gdx.app.getType();
        ControllerManager controllerManager = null;
        if (preferredManager != null) {
            string = preferredManager;
        } else if (object == Application$ApplicationType.Android) {
            string = "com.badlogic.gdx.controllers.android.AndroidControllers";
        } else if (object == Application$ApplicationType.Desktop) {
            string = "com.badlogic.gdx.controllers.desktop.JamepadControllerManager";
        } else if (object == Application$ApplicationType.WebGL) {
            string = "com.badlogic.gdx.controllers.gwt.GwtControllers";
        } else if (object == Application$ApplicationType.iOS) {
            string = "com.badlogic.gdx.controllers.IosControllerManager";
        } else {
            Gdx.app.log(TAG, "No controller manager is available for: " + (Object)((Object)Gdx.app.getType()));
            controllerManager = new ControllerManagerStub();
        }
        if (controllerManager == null) {
            try {
                object = ClassReflection.forName(string);
                controllerManager = (ControllerManager)ClassReflection.newInstance(object);
            }
            catch (Throwable throwable) {
                throw new GdxRuntimeException("Error creating controller manager: " + string, throwable);
            }
        }
        managers.put(Gdx.app, controllerManager);
        object = Gdx.app;
        Gdx.app.addLifecycleListener(new Controllers$1((Application)object));
        Gdx.app.log(TAG, "added manager for application, " + Controllers.managers.size + " managers active");
    }
}

