/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.desktop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.AbstractControllerManager;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.desktop.JamepadControllerManager$ManageControllers;
import com.badlogic.gdx.controllers.desktop.support.CompositeControllerListener;
import com.badlogic.gdx.controllers.desktop.support.JamepadControllerMonitor;
import com.badlogic.gdx.controllers.desktop.support.JamepadShutdownHook;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.studiohartman.jamepad.Configuration;
import com.studiohartman.jamepad.ControllerManager;

public class JamepadControllerManager
extends AbstractControllerManager
implements Disposable {
    public static Configuration jamepadConfiguration;
    private static boolean nativeLibInitialized;
    private static ControllerManager controllerManager;
    private final CompositeControllerListener compositeListener = new CompositeControllerListener();

    public JamepadControllerManager() {
        this.compositeListener.addListener(new JamepadControllerManager$ManageControllers(this, null));
        if (!nativeLibInitialized) {
            if (jamepadConfiguration == null) {
                jamepadConfiguration = new Configuration();
            }
            controllerManager = new ControllerManager(jamepadConfiguration);
            controllerManager.initSDLGamepad();
            JamepadControllerMonitor jamepadControllerMonitor = new JamepadControllerMonitor(controllerManager, this.compositeListener);
            jamepadControllerMonitor.run();
            Gdx.app.addLifecycleListener(new JamepadShutdownHook(controllerManager));
            Gdx.app.postRunnable(jamepadControllerMonitor);
            nativeLibInitialized = true;
        }
    }

    @Override
    public void addListener(ControllerListener controllerListener) {
        this.compositeListener.addListener(controllerListener);
    }

    @Override
    public void removeListener(ControllerListener controllerListener) {
        this.compositeListener.removeListener(controllerListener);
    }

    @Override
    public Array<ControllerListener> getListeners() {
        Array<ControllerListener> array = new Array<ControllerListener>();
        array.add(this.compositeListener);
        return array;
    }

    @Override
    public void clearListeners() {
        this.compositeListener.clear();
        this.compositeListener.addListener(new JamepadControllerManager$ManageControllers(this, null));
    }

    @Override
    public void dispose() {
        controllerManager.quitSDLGamepad();
    }

    public static void addMappingsFromFile(String string) {
        controllerManager.addMappingsFromFile(string);
    }

    public static void logLastNativeGamepadError() {
        Gdx.app.error("Jamepad", controllerManager.getLastNativeError());
    }

    static /* synthetic */ Array access$100(JamepadControllerManager jamepadControllerManager) {
        return jamepadControllerManager.controllers;
    }

    static /* synthetic */ Array access$200(JamepadControllerManager jamepadControllerManager) {
        return jamepadControllerManager.controllers;
    }

    static /* synthetic */ Array access$300(JamepadControllerManager jamepadControllerManager) {
        return jamepadControllerManager.controllers;
    }

    static /* synthetic */ Array access$400(JamepadControllerManager jamepadControllerManager) {
        return jamepadControllerManager.controllers;
    }

    static {
        nativeLibInitialized = false;
    }
}

