/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.desktop.support;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.controllers.ControllerPowerLevel;
import com.badlogic.gdx.controllers.desktop.support.CompositeControllerListener;
import com.badlogic.gdx.controllers.desktop.support.JamepadMapping;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.Logger;
import com.badlogic.gdx.utils.TimeUtils;
import com.studiohartman.jamepad.ControllerAxis;
import com.studiohartman.jamepad.ControllerButton;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import java.util.UUID;

public class JamepadController
implements Controller {
    private static final IntMap<ControllerButton> CODE_TO_BUTTON = new IntMap(ControllerButton.values().length);
    private static final IntMap<ControllerAxis> CODE_TO_AXIS = new IntMap(ControllerAxis.values().length);
    private static final Logger logger = new Logger(JamepadController.class.getSimpleName());
    private final CompositeControllerListener compositeControllerListener = new CompositeControllerListener();
    private final ControllerIndex controllerIndex;
    private final IntMap<Boolean> buttonState = new IntMap();
    private final IntMap<Float> axisState = new IntMap();
    private final String uuid;
    private boolean connected = true;
    private Boolean canVibrate = null;
    private long vibrationEndMs;
    private int axisCount = -1;
    private int maxButtonIndex = -1;

    public JamepadController(ControllerIndex controllerIndex) {
        this.controllerIndex = controllerIndex;
        this.uuid = UUID.randomUUID().toString();
        this.initializeState();
    }

    @Override
    public boolean getButton(int n2) {
        try {
            ControllerButton controllerButton = this.toButton(n2);
            return controllerButton != null && this.controllerIndex.isButtonPressed(controllerButton);
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return false;
        }
    }

    @Override
    public float getAxis(int n2) {
        try {
            ControllerAxis controllerAxis = this.toAxis(n2);
            if (controllerAxis == null) {
                return 0.0f;
            }
            return this.controllerIndex.getAxisState(controllerAxis);
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return 0.0f;
        }
    }

    @Override
    public String getName() {
        try {
            return this.controllerIndex.getName();
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return "Unknown";
        }
    }

    private void setDisconnected() {
        if (this.connected) {
            this.connected = false;
            logger.info("Failed querying controller at index: " + this.controllerIndex.getIndex());
            this.compositeControllerListener.disconnected(this);
        }
    }

    @Override
    public void addListener(ControllerListener controllerListener) {
        this.compositeControllerListener.addListener(controllerListener);
    }

    @Override
    public void removeListener(ControllerListener controllerListener) {
        this.compositeControllerListener.removeListener(controllerListener);
    }

    public boolean update() {
        this.updateButtonsState();
        this.updateAxisState();
        return this.connected;
    }

    private ControllerButton toButton(int n2) {
        return CODE_TO_BUTTON.get(n2);
    }

    private ControllerAxis toAxis(int n2) {
        return CODE_TO_AXIS.get(n2);
    }

    private void updateAxisState() {
        for (ControllerAxis controllerAxis : ControllerAxis.values()) {
            int n2 = controllerAxis.ordinal();
            float f2 = this.getAxis(n2);
            if (f2 != this.axisState.get(n2).floatValue()) {
                if (logger.getLevel() == 3) {
                    logger.debug("Axis [" + n2 + " - " + (Object)((Object)this.toAxis(n2)) + "] moved [" + f2 + "]");
                }
                this.compositeControllerListener.axisMoved(this, n2, f2);
            }
            this.axisState.put(n2, Float.valueOf(f2));
        }
    }

    private void updateButtonsState() {
        for (ControllerButton controllerButton : ControllerButton.values()) {
            int n2 = controllerButton.ordinal();
            boolean bl = this.getButton(n2);
            if (bl != this.buttonState.get(n2)) {
                if (bl) {
                    this.compositeControllerListener.buttonDown(this, n2);
                } else {
                    this.compositeControllerListener.buttonUp(this, n2);
                }
                if (logger.getLevel() == 3) {
                    logger.debug("Button [" + n2 + " - " + (Object)((Object)this.toButton(n2)) + "] is " + (bl ? "pressed" : "released"));
                }
            }
            this.buttonState.put(n2, bl);
        }
    }

    private void initializeState() {
        for (ControllerAxis enum_ : ControllerAxis.values()) {
            this.axisState.put(enum_.ordinal(), Float.valueOf(0.0f));
        }
        for (Enum enum_ : ControllerButton.values()) {
            this.buttonState.put(enum_.ordinal(), Boolean.FALSE);
        }
    }

    @Override
    public boolean canVibrate() {
        if (this.canVibrate == null) {
            try {
                this.canVibrate = this.controllerIndex.canVibrate();
            }
            catch (ControllerUnpluggedException controllerUnpluggedException) {
                this.setDisconnected();
            }
        }
        return this.canVibrate;
    }

    @Override
    public boolean isVibrating() {
        return this.canVibrate() && TimeUtils.millis() < this.vibrationEndMs;
    }

    @Override
    public void startVibration(int n2, float f2) {
        try {
            float f3 = f2;
            if (this.controllerIndex.doVibration(f3, f3, n2)) {
                this.vibrationEndMs = TimeUtils.millis() + (long)n2;
                this.canVibrate = Boolean.TRUE;
            }
            return;
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return;
        }
    }

    @Override
    public void cancelVibration() {
        if (this.isVibrating()) {
            this.startVibration(0, 0.0f);
        }
    }

    @Override
    public String getUniqueId() {
        return this.uuid;
    }

    @Override
    public boolean supportsPlayerIndex() {
        return true;
    }

    @Override
    public int getPlayerIndex() {
        try {
            return this.controllerIndex.getPlayerIndex();
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return -1;
        }
    }

    @Override
    public void setPlayerIndex(int n2) {
        try {
            this.controllerIndex.setPlayerIndex(n2);
            return;
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
            return;
        }
    }

    @Override
    public int getMinButtonIndex() {
        return 0;
    }

    @Override
    public int getMaxButtonIndex() {
        if (this.maxButtonIndex >= 0) {
            return this.maxButtonIndex;
        }
        this.maxButtonIndex = JamepadController.CODE_TO_BUTTON.size - 1;
        try {
            while (this.maxButtonIndex > 0 && !this.controllerIndex.isButtonAvailable(CODE_TO_BUTTON.get(this.maxButtonIndex))) {
                --this.maxButtonIndex;
            }
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
        }
        return this.maxButtonIndex;
    }

    @Override
    public int getAxisCount() {
        if (this.axisCount >= 0) {
            return this.axisCount;
        }
        this.axisCount = JamepadController.CODE_TO_AXIS.size;
        try {
            while (this.axisCount > 0 && !this.controllerIndex.isAxisAvailable(CODE_TO_AXIS.get(this.axisCount - 1))) {
                --this.axisCount;
            }
        }
        catch (ControllerUnpluggedException controllerUnpluggedException) {
            this.setDisconnected();
        }
        return this.axisCount;
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.controllerIndex.isConnected();
    }

    @Override
    public ControllerMapping getMapping() {
        return JamepadMapping.getInstance();
    }

    @Override
    public ControllerPowerLevel getPowerLevel() {
        try {
            switch (this.controllerIndex.getPowerLevel()) {
                case POWER_MAX: 
                case POWER_FULL: {
                    return ControllerPowerLevel.POWER_FULL;
                }
                case POWER_MEDIUM: {
                    return ControllerPowerLevel.POWER_MEDIUM;
                }
                case POWER_LOW: {
                    return ControllerPowerLevel.POWER_LOW;
                }
                case POWER_EMPTY: {
                    return ControllerPowerLevel.POWER_EMPTY;
                }
                case POWER_WIRED: {
                    return ControllerPowerLevel.POWER_WIRED;
                }
            }
            return ControllerPowerLevel.POWER_UNKNOWN;
        }
        catch (Throwable throwable) {
            return ControllerPowerLevel.POWER_UNKNOWN;
        }
    }

    static {
        for (ControllerButton enum_ : ControllerButton.values()) {
            CODE_TO_BUTTON.put(enum_.ordinal(), enum_);
        }
        for (Enum enum_ : ControllerAxis.values()) {
            CODE_TO_AXIS.put(enum_.ordinal(), (ControllerAxis)enum_);
        }
    }
}

